/*---------------------------- HEADER quickdraw.h ----------------------------*/
/* Copyright 1989 Brown University -- Jeffrey Vogel                           */
/*----------------------------------------------------------------------------*/

/*--------------------------------- typedefs ---------------------------------*/
/*----------------------------------------------------------------------------*/

typedef struct  {
   int x, y;
} Point;

typedef struct {
   int  top, left, bottom, right;
} Rect;

typedef struct {
   int    num_vertices;
   Point  *vertices;
} Polygon;


/*----------------------------- Type Definitions -----------------------------*/
/* GenericPtr : a generic pointer used as a user pointer                      */
/* FunctionPtr : a pointer to a function that returns void.                   */
/* Boolean : the basic boolean type                                           */
/*----------------------------------------------------------------------------*/

typedef void (*FunctionPtr)();
typedef unsigned char Byte;
typedef Byte    Boolean;

#ifndef FALSE
#define FALSE  0
#endif

#ifndef TRUE
#define TRUE   1
#endif

#ifndef NULL
		#undef NULL
#define NULL   0
#endif



/*-------------------------------- Constants ---------------------------------*/
/*----------------------------------------------------------------------------*/

#define QD__MAX_FONTS  4

















/*----------------------------- Enumerated types -----------------------------*/
/*----------------------------------------------------------------------------*/

typedef enum {
   white,
   ltGray,
   gray,
   dkGray,
   black
}  Patterns;

typedef enum {
   whiteColor,
   blackColor,
   redColor,
   greenColor,
   blueColor,
   magentaColor,
   cyanColor,
   yellowColor
} Colors;

typedef enum {
   patCopy,
   patXor
} PenModes;

typedef enum {
   FONT__SMALL,
   FONT__MEDIUM,
   FONT__LARGE,
   FONT__LARGEST
} Fonts;

typedef enum {
   LINE_STYLE__SOLID,
   LINE_STYLE__ON_OFF_DASH,
   LINE_STYLE__DOUBLE_DASH
} LineStyles;


/*---------------------------------- Limits ----------------------------------*/
/*----------------------------------------------------------------------------*/

#define LINE_WIDTH__MIN 1
#define LINE_WIDTH__MAX 5

#define QD__MAX_COLOR   7

/*--------------------------------- Defaults ---------------------------------*/
/*----------------------------------------------------------------------------*/

#define LINE_WIDTH__DEFAULT    1
#define FUNCTION__DEFAULT      GXcopy
#define LINE_STYLE__DEFAULT    LineSolid
#define JOIN_STYLE__DEFAULT    JoinMiter
#define FONT__DEFAULT          FONT__MEDIUM









/*--------------------------------- Externs ----------------------------------*/
/*----------------------------------------------------------------------------*/

extern void  QDclose();
extern void  QDreset();
extern void  QDopen();
extern void  QDallowKeypress();

extern void  InitDraw();
extern void  InitDraw4();
extern void  ClearAll();
extern void  QuitDraw();
extern void  GetDrawingRect();
extern void  DrawGrid();
extern void  SetErrorHandler();

extern int   Random();
extern void  Randomize();
extern void  WaitDraw();

extern Boolean Button();
extern void    GetMouse();
extern void    GetMousePt();

extern void    SetLineWidth();
extern void    GetLineWidth();
extern void    SetLineStyle();
extern void    GetLineStyle();
extern void    PenMode();
extern void    GetPenMode();
extern void    SetFont();
extern void    GetFont();

extern void    DrawLine();
extern void    EraseLine();

extern void    FrameRect();
extern void    PaintRect();
extern void    EraseRect();
extern void    InvertRect();
extern void    FrameOval();
extern void    PaintOval();
extern void    EraseOval();
extern void    InvertOval();
extern void    FrameArc();
extern void    PaintArc();
extern void    EraseArc();
extern void    InvertArc();
extern void    EraseCircle();
extern void    PaintCircle();
extern void    FrameCircle();

extern void    DrawString();
extern void    QueryStringSize();

extern void    SetRect();
extern void    SetPt();
extern void    OffsetRect();
extern void    InRect();
extern Boolean PtInRect();

extern void    SetColor();
extern void    PenPat();



extern void    LineTo();
extern void    MoveTo();

extern Polygon CreatePoly();
extern Polygon CopyPoly();
extern void    PolyAddPt();
extern void    PolyQueryPt();
extern void    FramePoly();
extern void    PaintPoly();
extern void    ErasePoly();
extern void    InsetPoly();
extern void    OffsetPoly();






















































