/*
 * "The Road goes ever on and on, down from the door where it began."
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "EXTERN.h"
#include "perl.h"

#ifdef __cplusplus
}
#  define EXTERN_C extern "C"
#else
#  define EXTERN_C extern
#endif

static void xs_init _((void));
static PerlInterpreter *my_perl;

int
#ifdef CAN_PROTOTYPE
main(int argc, char **argv, char **env)
#else
main(argc, argv, env)
int argc;
char **argv;
char **env;
#endif
{
    int exitstatus;

    PERL_SYS_INIT(&argc,&argv);

    perl_init_i18nl10n(1);

    if (!do_undump) {
	my_perl = perl_alloc();
	if (!my_perl)
	    exit(1);
	perl_construct( my_perl );
	perl_destruct_level = 0;
    }

    exitstatus = perl_parse( my_perl, xs_init, argc, argv, (char **) NULL );
    if (!exitstatus) {
	exitstatus = perl_run( my_perl );
    }

    perl_destruct( my_perl );
    perl_free( my_perl );

    PERL_SYS_TERM();

    exit( exitstatus );
}

/* Register any extra external extensions */

/* Do not delete this line--writemain depends on it */
EXTERN_C void boot_DynaLoader _((CV* cv));
EXTERN_C void boot_Fcntl _((CV* cv));
EXTERN_C void boot_IO _((CV* cv));
EXTERN_C void boot_NDBM_File _((CV* cv));
EXTERN_C void boot_ODBM_File _((CV* cv));
EXTERN_C void boot_Opcode _((CV* cv));
EXTERN_C void boot_SDBM_File _((CV* cv));
EXTERN_C void boot_Socket _((CV* cv));

static void
xs_init()
{
    char *file = __FILE__;
    dXSUB_SYS;
        newXS("DynaLoader::boot_DynaLoader", boot_DynaLoader, file);
        newXS("Fcntl::bootstrap", boot_Fcntl, file);
        newXS("IO::bootstrap", boot_IO, file);
        newXS("NDBM_File::bootstrap", boot_NDBM_File, file);
        newXS("ODBM_File::bootstrap", boot_ODBM_File, file);
        newXS("Opcode::bootstrap", boot_Opcode, file);
        newXS("SDBM_File::bootstrap", boot_SDBM_File, file);
        newXS("Socket::bootstrap", boot_Socket, file);
}
