


ELMALIAS(1L)                                         ELMALIAS(1L)


NNAAMMEE
       elmalias - expand and display Elm address aliases

SSYYNNOOPPSSIISS
       eellmmaalliiaass [ --aaddeennrrssuuvvVV ] [ --ff format ] [ name  ... ]

       _$_l_i_b/pprrlloonngg [ options ... ] < _f_i_l_e

DDEESSCCRRIIPPTTIIOONN
       _E_l_m_a_l_i_a_s  allows you to examine information about aliases.
       The alias databases are consulted for  each  _n_a_m_e  on  the
       command  line, and the alias value is displayed, one value
       per line of output.  If _n_a_m_e is not a known alias, then it
       is  displayed  unchanged.  If no _n_a_m_e is given on the com-
       mand line then all alias values in the databases are  dis-
       played.   All  of these actions are default behaviors that
       may be modified by command line options.

       There are two possible alias  databases,  a  user-specific
       alias  file  (usually in _$_H_O_M_E_/_._e_l_m_/_a_l_i_a_s_e_s) and a system-
       wide alias file (usually  in  _$_l_i_b_/_a_l_i_a_s_e_s).   By  default
       both  files are searched, first the user-specific file and
       then the system-wide file.  If  an  alias  file  does  not
       exist  then _e_l_m_a_l_i_a_s silently ignores it and continues on.
       The --ss and --uu command line options (discussed shortly) can
       restrict what files are files searched.

       There  are  two types of aliases, Person aliases and Group
       aliases.  A Person alias expands to an individual  address
       and  a  Group  alias contains a list of addresses, some of
       which may be aliases.  By default, _e_l_m_a_l_i_a_s  displays  the
       defined  value  of  an  alias, regardless of type.  The --ee
       command line option (discussed shortly) fully expands  out
       Group aliases.

       The default output produced is just the ``Address'' infor-
       mation for each _n_a_m_e on the command  line.   A  number  of
       command  line  options  (discussed shortly) may be used to
       select different output information or specify a format of
       your choosing.  The following information is maintained in
       the alias databases, and may be accessed by  the  _e_l_m_a_l_i_a_s
       utility:

            +o Alias (the alias name)
            +o Last Name
            +o Name (the user's full name)
            +o Comment (not displayed in mail headers)
            +o Address (the alias value)
            +o Type (Person, Group, or Unknown)


       When the _n_a_m_e specified on the command line is not a known
       alias, both the ``Alias'' and ``Address'' information will
       display as the _n_a_m_e, the ``Type'' information will display



USENET Community Trust   Elm Version 2.4                        1





ELMALIAS(1L)                                         ELMALIAS(1L)


       as ``Unknown'', and all other items will be blank.

       The available command line options are:


       --aa     Selects  an   alternative   output   format.    The
              ``Alias''  information  is displayed in addition to
              and preceding the usual ``Address'' information.

       --dd     Turns debugging on. Has no effect  unless  _e_l_m_a_l_i_a_s
              was compiled with debugging enabled.

       --ee     Tells _e_l_m_a_l_i_a_s to fully expand group aliases.  This
              option can be used only when _n_a_m_es are given on the
              command line.

       --ff     The  output  produced will be in the specified _f_o_r_-
              _m_a_t.   Format  specifications  will  be   discussed
              shortly.

       --nn     Selects an alternative output format.  The ``Name''
              information, if it exists, is displayed in addition
              to and following the usual ``Address'' information.
              The ``Name'' will be enclosed in parenthesis.

       --rr     If a specified _n_a_m_e does not correspond to a  known
              alias then _e_l_m_a_l_i_a_s will display a message and exit
              with a nonzero status.

       --ss     Normally _e_l_m_a_l_i_a_s examines both  the  user-specific
              and  system-wide alias files.  This option requests
              that _e_l_m_a_l_i_a_s use the system-wide alias  file,  and
              unless  the  --uu  option is also specified the user-
              specific alias file will be ignored.

       --uu     Normally _e_l_m_a_l_i_a_s examines both  the  user-specific
              and  system-wide alias files.  This option requests
              that _e_l_m_a_l_i_a_s use the user-specific alias file, and
              unless  the --ss option is also specified the system-
              wide alias file will be ignored.

       --vv     Selects  a  verbose  output   format.    Both   the
              ``Alias'' and the ``Name'' information will be dis-
              played in addition to the ``Address''  information.
              The   ``Alias''   information   will   precede  the
              ``Address'' information, and the ``Name''  informa-
              tion will be enclosed in parenthesis and follow it.
              If there is no ``Name'' information for this  alias
              then that portion of the output will be ignored.

       --VV     Selects  a  very verbose, multi-line output format.
              Displays all available information on aliases.

       The output produced by _e_l_m_a_l_i_a_s is fully customizable with



USENET Community Trust   Elm Version 2.4                        2





ELMALIAS(1L)                                         ELMALIAS(1L)


       the --ff option.  The _f_o_r_m_a_t string uses a syntax similar to
       _d_a_t_e_(_1_) (System V version) and _p_r_i_n_t_f_(_3_).   The  following
       field descriptors may be used in _f_o_r_m_a_t specifications:

            %a   Alias (the alias name)
            %l   Last Name
            %n   Name (the user's full name)
            %c   Comment (not displayed in mail headers)
            %v   Address (the alias value)
            %t   Type (Person, Group, or Unknown)

       Field  widths  in  a  _[_-_]_[_m_]_[_._n_] format (again, similar to
       _p_r_i_n_t_f_(_3_)) may also  be  used.   For  example,  "%-20.20a"
       means  print the ``Alias'' information left justified in a
       field twenty characters long, with the value truncated  to
       twenty characters.

       The  following special character sequences are also recog-
       nized in format specifications:

            \b   A backspace.
            \f   A formfeed.
            \n   A newline.
            \r   A return.
            \t   A tab.
            \_c   Literal character ``_c''.

       There is a very simplistic conditional  evaluation  mecha-
       nism  that may be used in format specifications.  The con-
       ditional text should be surrounded by question marks,  and
       a  single  character  that specifies the condition immedi-
       ately follows the  first  question  mark.   The  condition
       characters correspond to the ``%'' field specifier charac-
       ters, and the condition is true if the corresponding alias
       information  is defined and nonempty.  For example, if you
       want to display the  ``Name''  information  surrounded  by
       parenthesis,  but omit it if the information is not avail-
       able, you may use ``?n(%n)?'' in the format specification.

       The  command line switches that select an alternative for-
       mat correspond to the following format specifiers.

            _d_e_f_a_u_l_t   "%v"
            -a   "%-20.20a %v"
            -n   "%v?n (%n)?"
            -v   "%-20.20a %v?n (%n)?"
            -V   "Alias:\t\t%a\n\
                   Address:\t%v\n\
                   Type:\t\t%t\n\
                 ?n  Name:\t\t%n\n?\
                 ?l  Last Name:\t%l\n?\
                 ?c  Comment:\t%c\n?"





USENET Community Trust   Elm Version 2.4                        3





ELMALIAS(1L)                                         ELMALIAS(1L)


       The _p_r_l_o_n_g utility formats long amounts of  data,  folding
       across multiple lines.  It is useful to reformat output of
       _e_l_m_a_l_i_a_s.  _P_r_l_o_n_g reads data from its standard input,  one
       line  at a time, and tries to place as much information as
       possible on each  output  line.   A  field  seperator,  by
       default a single space, seperates each input record in the
       output lines.  Every output line is preceded by  a  leader
       field.   By default the leader of the first output line is
       an empty string, and the leader for all subsequent  output
       lines  is  a single tab.  _p_r_l_o_n_g will never split an input
       record.  If an input record  exceeds  the  maximum  output
       line  length,  it will appear unmodified on an output line
       all by itself.

       The following options may be used  to  modify  the  _p_r_l_o_n_g
       behavior.

       --ww _w_i_d_t_h    Constrains  output  lines  to _w_i_d_t_h columns in
                   length (not counting an appended newline char-
                   acter).  The default is 78 columns.  The width
                   calculation assumes that tabstops occur  every
                   eight spaces.

       --ff _s_t_r_i_n_g   Seperates each input record with the indicated
                   _s_t_r_i_n_g when  displayed  to  the  output.   The
                   default is a single space.

       --11 _s_t_r_i_n_g   Specifies the leader _s_t_r_i_n_g used for the first
                   line of output.  (This  option  is  the  digit
                   ``one''.)  The default is an empty string.

       --ll _s_t_r_i_n_g   Specifies the leader _s_t_r_i_n_g for all subsequent
                   lines of output.  (This option is a lower-case
                   ``ell''.) The default is a single tab.

EEXXAAMMPPLLEESS
       Consider an _a_l_i_a_s_e_s_._t_e_x_t file that contains:

            ffrriieennddss == LLiisstt ooff FFrriieennddss == ttoomm,, ddiicckk,, hhaarrrryy
            ttoomm == TToomm SSmmiitthh == sslleeeeppyy!!ttoomm
            ddiicckk == DDiicckk JJoonneess == ddooppeeyy!!ddiicckk
            hhaarrrryy == == ggrruummppyy!!hhaarrrryy

       Below  are shown some example commands and the output pro-
       duced.

            $$ _e_l_m_a_l_i_a_s _f_r_i_e_n_d_s
            ttoomm,,ddiicckk,,hhaarrrryy
            $$ _e_l_m_a_l_i_a_s _m_i_k_e
            mmiikkee
            $$ _e_l_m_a_l_i_a_s _-_r _m_i_k_e
            eellmmaalliiaass:: ""mmiikkee"" iiss nnoott aa kknnoowwnn aalliiaass
            $$ _e_l_m_a_l_i_a_s _-_n _f_r_i_e_n_d_s
            ttoomm,,ddiicckk,,hhaarrrryy ((LLiisstt ooff FFrriieennddss))



USENET Community Trust   Elm Version 2.4                        4





ELMALIAS(1L)                                         ELMALIAS(1L)


            $$ _e_l_m_a_l_i_a_s _-_a _f_r_i_e_n_d_s
            ffrriieennddss              ttoomm,,ddiicckk,,hhaarrrryy
            $$ _e_l_m_a_l_i_a_s _-_V _f_r_i_e_n_d_s
            AAlliiaass::          ffrriieennddss
              AAddddrreessss::      ttoomm,,ddiicckk,,hhaarrrryy
              TTyyppee::         GGrroouupp
              NNaammee::         LLiisstt ooff FFrriieennddss
              LLaasstt NNaammee::    LLiisstt ooff FFrriieennddss
            $$ _e_l_m_a_l_i_a_s _-_e _f_r_i_e_n_d_s
            ttoomm@@sslleeeeppyy..aaccmmee..ccoomm
            ddiicckk@@ddooppeeyy..aaccmmee..ccoomm
            hhaarrrryy@@ggrruummppyy..aaccmmee..ccoomm
            $$ _e_l_m_a_l_i_a_s _-_v_e _f_r_i_e_n_d_s
            ttoomm                  ttoomm@@sslleeeeppyy..aaccmmee..ccoomm ((TToomm SSmmiitthh))
            ddiicckk                 ddiicckk@@ddooppeeyy..aaccmmee..ccoomm ((DDiicckk JJoonneess))
            hhaarrrryy                hhaarrrryy@@ggrruummppyy..aaccmmee..ccoomm
            $$ _e_l_m_a_l_i_a_s _-_f _"_a_l_i_a_s _%_a _i_s _\_"_%_v_\_" _?_n_(_%_n_)_?_" _-_e _f_r_i_e_n_d_s
            aalliiaass ttoomm iiss ""ttoomm@@sslleeeeppyy..aaccmmee..ccoomm"" ((TToomm SSmmiitthh))
            aalliiaass ddiicckk iiss ""ddiicckk@@ddooppeeyy..aaccmmee..ccoomm"" ((DDiicckk JJoonneess))
            aalliiaass hhaarrrryy iiss ""hhaarrrryy@@ggrruummppyy..aaccmmee..ccoomm""
            $$ _e_l_m_a_l_i_a_s _-_e_n _f_r_i_e_n_d_s _| _/_u_s_r_/_l_i_b_/_e_l_m_/_p_r_l_o_n_g _-_w_4_0
            ttoomm@@sslleeeeppyy..aaccmmee..ccoomm ((TToomm SSmmiitthh))
                    ddiicckk@@ddooppeeyy..aaccmmee..ccoomm ((DDiicckk JJoonneess))
                    hhaarrrryy@@ggrruummppyy..aaccmmee..ccoomm
            $$ _e_l_m_a_l_i_a_s _-_e_n _f_r_i_e_n_d_s _| _/_u_s_r_/_l_i_b_/_e_l_m_/_p_r_l_o_n_g _-_1 _"_T_o_: _" _-_f _"_, _" _-_w_4_0
            TToo:: ttoomm@@sslleeeeppyy..aaccmmee..ccoomm ((TToomm SSmmiitthh)),,
                    ddiicckk@@ddooppeeyy..aaccmmee..ccoomm ((DDiicckk JJoonneess)),,
                    hhaarrrryy@@ggrruummppyy..aaccmmee..ccoomm


The _c_h_e_c_k_a_l_i_a_s(1L) and _l_i_s_t_a_l_i_a_s(1L) scripts distributed with the
Elm  package  provide further examples of the _e_l_m_a_l_i_a_s and _p_r_l_o_n_g
utilities.

AAUUTTHHOORR
       Elm Development Group

SSEEEE AALLSSOO
       checkalias(1L), elm(1L), listalias(1L), newalias(1L)

BBUUGGSS
       There is no centralized, comprehensive  interface  to  the
       Elm  2.4  alias  system, so every program in the Elm suite
       that uses aliases implements  its  own  interfaces.   It's
       possible  for  inconsistencies  to  creep  in between what
       _e_l_m_a_l_i_a_s says and what some Elm utility does.  If you find
       an inconsistency please report it to us!

       Boy, there sure are a lot of command line switches in this
       thing.

       Note that the precedence of aliases is user file then sys-
       tem  file.  This means that a user can 'overload' an alias
       by having one defined in the system file also  defined  in



USENET Community Trust   Elm Version 2.4                        5





ELMALIAS(1L)                                         ELMALIAS(1L)


       theirs.   This  shouldn't turn out to be a problem, but is
       something for the system administrator  to  keep  in  mind
       when creating the system alias file.

BBUUGG RREEPPOORRTTSS TTOO
       Syd Weinstein  elm@DSI.COM    (dsinc!elm)

CCOOPPYYRRIIGGHHTTSS
       Copyright 1993 by The USENET Community Trust
















































USENET Community Trust   Elm Version 2.4                        6


