/*
 * 
 * $Copyright
 * Copyright 1993, 1994 , 1995 Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * Copyright (c) 1991-1995, Locus Computing Corporation
 * All rights reserved
 */
/* 
 * HISTORY
 * $Log: rtask.h,v $
 * Revision 1.13  1995/02/01  21:47:18  bolsen
 *  Reviewer(s): Jerry Toman
 *  Risk: Medium (lots of files)
 *  Module(s): Too many to list
 *  Configurations built: STD, LITE, & RAMDISK
 *
 *  Added or Updated the Locus Copyright message.
 *
 * Revision 1.12  1994/12/20  23:01:16  suri
 *  Reviewer: jlitvin
 *  Risk: Low
 *  Benefit or PTS #: 11640
 *  Testing: Specific Testcase
 *  Module(s): Backing out the fix for PTS-11270/11317/10593 (vm_allocate/sbrk
 *  changes), as it was causing excessive wiring down of memory on the compute
 *  nodes under some specific cases (the testcase for PTS-11640 is one of them).
 *  The vm_allocate/sbrk changes have to be reimplemented, perhaps using
 *  vm_reserve().
 *
 * Revision 1.11  1994/11/18  20:43:39  mtm
 * Copyright additions/changes
 *
 * Revision 1.10  1994/10/25  23:48:49  suri
 *  Reviewer: jlitvin
 *  Risk: M
 *  Benefit or PTS #: 11317
 *  Testing: Specific testcase, fileio, pthreads, xtrnl, NQS/MACs EATs
 *  Module(s): obreak() in server/bsd/kern_mman.c
 *            setrlimit() in server/bsd/kern_resource.c
 *            coff_getxfile() in server/bsd/kern_exec.c
 *            user struct in server/sys/user.h
 *            rf_data struct in server/tnc/rtask.h
 *            rfork_pproc_load_msg() in server/tnc/rtask_cli_pproc.c
 *            rfork_pproc_unload_msg() in server/tnc/rtask_svr_pproc.c
 *
 * Revision 1.9  1994/06/02  22:28:49  chrisp
 * In dpvpop_reap(), perform PVPOP_RMV_PGRP_LIST() for zombie child
 * only if child's pgrp leader is not its parent; return child pgid.
 * In dvpop_wait(), analyze pgid returned for zombie child and call
 * PVPOP_RMV_PGRP_LIST() if this is the parent pid.
 *
 * Support added for waitmulti() - viz: elder reporting and reap multi
 * operation (refer to rtask_cli_vproc.c).
 *
 *  Reviewer: cfj
 *  Risk: M
 *  Benefit or PTS #: 6463
 *  Testing:
 *  Module(s): dpvproc.h dvp_pvpops.c dvp_vpops.c pvp.ops pvps.ops rtask.h
 * 	    rtask_cli_vproc.c rtask_server.c rtask_svr_vproc.c
 * 	    spanning_tree.c tnc_async.defs tnc_server_side.c
 * 	    tnc_types.defs tnc_types.h tnc_types_gen.c
 *
 * Revision 1.8  1993/11/03  19:17:01  yazz
 * Establish a sequence number mechanism whereby process group signals, such as
 * those generated by CTRL/C, are guaranteed to be delivered to child processes
 * of a reproducing (fork(), rfork(), rforkmulti(), etc.) task.  Many unixes
 * have a timing window where new child procs can miss out on a pgrp-style signal.
 *
 * Revision 1.7  1993/07/14  18:33:20  cfj
 * OSF/1 AD 1.0.4 code drop from Locus.
 *
 * Revision 1.1.1.4  1993/07/01  20:45:43  cfj
 * Adding new code from vendor
 *
 * Revision 1.6  1993/05/06  19:22:54  cfj
 * ad103+tnc merged with Intel code.
 *
 * Revision 1.1.1.2  1993/05/03  17:45:43  cfj
 * Initial 1.0.3 code drop
 *
 * Revision 1.5  1993/04/03  03:08:51  brad
 * Merge of PFS branch (tagged PFS_End) into CVS trunk (tagged
 * Main_Before_PFS_Merge).  The result is tagged PFS_Merge_Into_Main_April_2.
 *
 * Revision 1.1.2.2.2.1  1992/12/16  06:02:14  brad
 * Merged trunk (as of the Main_After_Locus_12_1_92_Bugdrop_OK tag)
 * into the PFS branch.
 *
 * Revision 1.4  1992/12/11  03:01:44  cfj
 * Merged 12-1-92 bug drop from Locus.
 *
 * Revision 1.3  1992/11/30  22:47:37  dleslie
 * Copy of NX branch back into main trunk
 *
 * Revision 1.1.2.2  1992/11/06  20:31:23  dleslie
 * Merged bug drop from Locus November 3, 1992, with NX development
 *
 * Revision 1.1.2.1  1992/11/05  22:45:49  dleslie
 * Local changes for NX through noon, November 5, 1992.
 *
 * Revision 3.12  1992/10/24  20:39:44  cfj
 * Reset MAX_VPROC_LIST back to 100.
 *
 * Revision 3.11  1992/10/23  02:00:02  cfj
 * T6 merge.
 *
 * Revision 3.12  93/06/19  15:18:28  yazz
 * [ ad1.04 merge ]
 * 	Replace now-deleted define MAX_MMAP_REGIONS with TNC_MAX_MMAP_REGIONS,
 * 	which TNC still uses when loading and unloading proc structures in
 * 	remote tasking operations.
 * 
 * Revision 3.11  93/06/02  12:26:08  yazz
 * For Sys V IPC under TNC add svipc flag field to data structures used
 * in migrate, remote fork and remote exec.
 * 
 * Revision 3.10  92/11/02  11:40:24  roman
 * Change sizes of vproc list and credentials cache to lower limits. Makes
 * 	normal RPC faster. Larger values handled with out-of-line data.
 *
 * Revision 3.9  92/10/01  10:29:34  roman
 * Minor formatting fix.
 * 
 * Revision 3.8  92/09/29  08:03:46  roman
 * Fix types for u_sigtramp field for clean compilations.
 * Add field for foster parent for migrate and rexec.
 * 
 * Revision 3.7  92/07/13  07:38:47  chrisp
 * Remove p_issig_count fields from migrate and rexec proc load structures.
 * 
 * Revision 3.6  92/06/16  10:42:47  chrisp
 * Include u_sigtramp field for transfer in the i860 case also.
 * 
 * Revision 3.5  92/06/05  15:37:46  roman
 * Add new "node" field to structure for mapped files (V0.89 integration).
 * 
 * Revision 3.4  92/03/27  11:24:28  roman
 * Add node list size for credentials cache.
 * 
 * Revision 3.3  92/03/12  15:24:23  roman
 * Pass the parent's pgid and parent's sid for migrate and rexec (needed
 * to set up the new pvproc fields).
 * 
 * Revision 3.2  92/02/14  08:46:21  roman
 * Put in maximum size of vproc list (used for parent-child-sibling lists,
 * pgrp lists, session lists) as a symbolic constant.
 * 
 * Revision 3.1  92/01/07  18:21:08  roman
 * Add mmap structure that will be passed between servers for
 * rfork/rexec/migrate.
 * 
 * Revision 3.0  91/12/13  09:11:59  roman
 * Initial submission. This file contains data structures used in
 * server-to-server communication for rfork/rexec/migrate.
 * 
 */

#ifndef	_H_TNC_RTASK
#define	_H_TNC_RTASK


#include <sys/types.h>
#include <sys/signal.h>
#include <sys/resource.h>
#include <sys/param.h>

/*
 * Define used for size of list of children, pgrp members, and sessions.
 */
#define	MAX_VPROC_LIST	20

/*
 * Define used for size of list of credentials cache information.
 */
#define CREDENTIALS_CACHE_SIZE	20

/*
 * Data structure used for passing mmap structures server-to-server,
 * along with the maximum number of them we will pass in a remote
 * tasking operation.
 */
#define TNC_MAX_MMAP_REGIONS	128
struct mmap_struct {
	vm_address_t	start;
	vm_size_t	length;
	unsigned	node;
	vm_offset_t	offset;
	unsigned	flags;
};

/*
 * Data for rfork system call.
 */
struct rf_data {
	long	rf_p_nice;		/* info held in proc structure */
	long	rf_p_sigmask;
	long	rf_p_sigignore;
	long	rf_p_sigcatch;
	long	rf_p_flag;
	long	rf_p_ruid;
	long	rf_p_svuid;
	long	rf_p_rgid;
	long	rf_p_svgid;
	long	rf_p_cr_uid;
#ifdef NX
	long	rf_p_cr_acctid;
#endif /* NX */
	long	rf_p_cr_ngroups;
	long	rf_p_cr_gid;
	long	rf_p_cr_groups[NGROUPS];
#if defined(MACH_AFS)
	long	rf_p_cr_pag;
#endif
	long	rf_p_pid;
	long	rf_p_pgid;
	long	rf_p_sid;
	long	rf_p_pgrp_mem_seqno;
	long	rf_p_realtimer_coe;	/* shouldn't fork zero this out? */

	long	rf_u_tsize;		/* info held in utask structure */
	long	rf_u_dsize;
	long	rf_u_ssize;
	caddr_t	rf_u_text_start;
	caddr_t	rf_u_data_start;
	caddr_t	rf_u_stack_start;
	caddr_t	rf_u_stack_end;
	long	rf_u_stack_grows_up;
	long	rf_u_outime;	/* ??????????? reinitted at fork time? */
	sig_t	rf_u_signal[NSIG+1];
	long	rf_u_sigmask[NSIG+1];
#ifdef i386
	int	(*rf_u_sigreturn)();
#endif
#ifdef multimax
	long	rf_u_sigcatch;
#endif
#if defined(balance) || defined(mips) || defined(i860)
	int	(*rf_u_sigtramp)();
#endif
	long	rf_u_sigonstack;
	long	rf_u_sigintr;
	long	rf_u_oldmask;
	char	*rf_u_sigstack_ss_sp;
	long	rf_u_sigstack_ss_onstack;

	/*
	 * Struct utask_nd: holds rootdir, curdir and a lock.  For now,
	 * we leave these out and they are initialized on the new node
	 * to just be root.  When they are file ports, they will have to
	 * come over as ports and will be added, as ports, to the MiG
	 * definitions.  (The lock field is initialized anew.)
	 */

	long	rf_u_cmask;
	long	rf_u_ioch;		/* shouldn't this be zeroed on fork? */
	struct itimerval
		rf_u_timer[3];
	short	*rf_u_prof_base;
	long	rf_u_prof_size;
	long	rf_u_prof_off;
	long	rf_u_prof_scale;
	long	rf_u_maxuprc;
	struct rlimit
		rf_u_rlimit[RLIM_NLIMITS];

	long	rf_u_shmsegs;

	/*
	 * Process locks are not inherited by child processes and plock()
	 * isn't implemented yet.
	 */

	long	rf_u_argp;
	long	rf_u_envp;
	long	rf_u_arg_size;
	long	rf_u_env_size;
#ifdef NX
        unsigned long nx_flags;
#endif /* NX */
};

/*
 * Data for migrate system call.
 */
struct mi_data {
	long	mi_p_nice;		/* info held in proc structure */
	long	mi_p_cursig;
	long	mi_p_sig;
	long	mi_p_sigmask;
	long	mi_p_sigignore;
	long	mi_p_sigcatch;
	long	mi_p_flag;
	long	mi_p_ruid;
	long	mi_p_svuid;
	long	mi_p_rgid;
	long	mi_p_svgid;
	long	mi_p_cr_uid;
#ifdef NX
	long	mi_p_cr_acctid;
#endif /* NX */
	long	mi_p_cr_ngroups;
	long	mi_p_cr_gid;
	long	mi_p_cr_groups[NGROUPS];
#if defined(MACH_AFS)
	long	mi_p_cr_pag;
#endif
	long	mi_p_pid;
	long	mi_p_ppid;
	long	mi_p_foster_ppid;
	long	mi_p_pgid;
	long	mi_p_sid;
	long	mi_p_pgrp_mem_seqno;
	long	mi_p_pgrp_ldr_seqno;
	long	mi_pp_pgid;
	long	mi_pp_sid;
	long	mi_p_realtimer_coe;
	long	mi_p_stopsig;
	struct	itimerval mi_p_realtimer;
	long	mi_p_logdev;
	long	mi_sigwait;

	long	mi_u_tsize;		/* info held in utask structure */
	long	mi_u_dsize;
	long	mi_u_ssize;
	caddr_t	mi_u_text_start;
	caddr_t	mi_u_data_start;
	caddr_t	mi_u_stack_start;
	caddr_t	mi_u_stack_end;
	long	mi_u_stack_grows_up;
	long	mi_u_outime;
	sig_t	mi_u_signal[NSIG+1];
	long	mi_u_sigmask[NSIG+1];
#ifdef i386
	int	(*mi_u_sigreturn)();
#endif
#ifdef multimax
	long	mi_u_sigcatch;
#endif
#if defined(balance) || defined(mips) || defined(i860)
	int	(*mi_u_sigtramp)();
#endif
	long	mi_u_sigonstack;
	long	mi_u_sigintr;
	long	mi_u_oldmask;
	char	*mi_u_sigstack_ss_sp;
	long	mi_u_sigstack_ss_onstack;

	/*
	 * Struct utask_nd: holds rootdir, curdir and a lock.  For now,
	 * we leave these out and they are initialized on the new node
	 * to just be root.  When they are file ports, they will have to
	 * come over as ports and will be added, as ports, to the MiG
	 * definitions.  (The lock field is initialized anew.)
	 */

	long	mi_u_cmask;
	long	mi_u_ioch;
	struct rusage mi_u_ru;
	struct rusage mi_u_cru;
	struct itimerval
		mi_u_timer[3];
	short	*mi_u_prof_base;
	long	mi_u_prof_size;
	long	mi_u_prof_off;
	long	mi_u_prof_scale;
	long	mi_u_maxuprc;
	struct rlimit
		mi_u_rlimit[RLIM_NLIMITS];

	long	mi_u_svipc_flag;
	long	mi_u_shmsegs;

	/*
	 * Process locks are not inherited by child processes and plock()
	 * isn't implemented yet.
	 */

	long	mi_u_argp;
	long	mi_u_envp;
	long	mi_u_arg_size;
	long	mi_u_env_size;
#ifdef NX
        unsigned long nx_flags;
#endif /* NX */
};

/*
 * Data for rexec system call.
 */
struct re_data {
	long	re_p_nice;		/* info held in proc structure */
	long	re_p_cursig;
	long	re_p_sig;
	long	re_p_sigmask;
	long	re_p_sigignore;
	long	re_p_sigcatch;
	long	re_p_flag;
	long	re_p_ruid;
	long	re_p_svuid;
	long	re_p_rgid;
	long	re_p_svgid;
	long	re_p_cr_uid;
#ifdef NX
	long	re_p_cr_acctid;
#endif /* NX */
	long	re_p_cr_ngroups;
	long	re_p_cr_gid;
	long	re_p_cr_groups[NGROUPS];
#if defined(MACH_AFS)
	long	re_p_cr_pag;
#endif
	long	re_p_pid;
	long	re_p_ppid;
	long	re_p_foster_ppid;
	long	re_p_pgid;
	long	re_p_sid;
	long	re_p_pgrp_mem_seqno;
	long	re_p_pgrp_ldr_seqno;
	long	re_pp_pgid;
	long	re_pp_sid;
	long	re_p_realtimer_coe;
	long	re_p_stopsig;
	struct	itimerval re_p_realtimer;
	long	re_p_logdev;
	long	re_sigwait;

	long	re_u_outime;		/* info held in utask structure */
	sig_t	re_u_signal[NSIG+1];
	long	re_u_sigmask[NSIG+1];
#ifdef i386
	int	(*re_u_sigreturn)();
#endif
#ifdef multimax
	long	re_u_sigcatch;
#endif
#if defined(balance) || defined(mips) || defined(i860)
	int	(*re_u_sigtramp)();
#endif
	long	re_u_sigintr;
	long	re_u_oldmask;

	/*
	 * Struct utask_nd: holds rootdir, curdir and a lock.  For now,
	 * we leave these out and they are initialized on the new node
	 * to just be root.  When they are file ports, they will have to
	 * come over as ports and will be added, as ports, to the MIG
	 * definitions.  (The lock field is initialized anew.)
	 */

	long	re_u_cmask;
	long	re_u_ioch;
	struct rusage re_u_ru;
	struct rusage re_u_cru;
	struct itimerval
		re_u_timer[3];
	long	re_u_maxuprc;
	struct rlimit
		re_u_rlimit[RLIM_NLIMITS];

	long	re_u_svipc_flag;
	long	re_u_shmsegs;

	/*
	 * Process locks are not inherited by child processes and plock()
	 * isn't implemented yet.
	 */

#ifdef NX
        unsigned long nx_flags;
#endif /* NX */
};

/*
 * Structure used by reap_multi to return process info.
 */
struct rstat {
	int	state;		/* PV_SZOMB | PV_SSTOP | PV_LEFT_PGRP */
	int	wstat;		/* wait status */
	pid_t	pgid;		/* pgid of terminated child */
};
typedef struct rstat rstat_t;

#endif	_H_TNC_RTASK
