/*
 * 
 * $Copyright
 * Copyright 1993, 1994 , 1995 Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 

/*
 * Copyright (c) 1991-1995, Locus Computing Corporation
 * All rights reserved
 */
/* 
 * $Log: dvp_init.c,v $
 * Revision 1.20  1995/02/01  21:40:42  bolsen
 *  Reviewer(s): Jerry Toman
 *  Risk: Medium (lots of files)
 *  Module(s): Too many to list
 *  Configurations built: STD, LITE, & RAMDISK
 *
 *  Added or Updated the Locus Copyright message.
 *
 * Revision 1.19  1994/11/18  20:43:07  mtm
 * Copyright additions/changes
 *
 * Revision 1.18  1994/09/20  18:26:55  yazz
 *  Author: Mike Leibensperger
 *  Reviewer: Suri Brahmaroutu
 *  Risk: Lo
 *  Benefit or PTS #: Instrumentation for #9421
 *  Testing: Sched EAT, misc networking testing also
 *  Module(s): server/uxkern/const_region.h, server/bsd/init_main.c,
 * 	server/bsd/uipc_proto.c, server/netinet/in_proto.c,
 * 	server/tnc/dvp_init.c
 *
 * Implement a mechanism in assertful servers whereby areas of the data
 * segment known to be constant can be vm_protect()'d against unintended
 * overwriting.  Corrupted jump tables are known to cause #9421.
 *
 * Revision 1.17  1994/06/29  17:02:50  johannes
 * dpvproc_struct_init(): initializing of extra 'pvp_core_data' field
 *
 *  Initial check-in of parallel core dumping
 *  Reviewer: stefan, jlitvin
 *  Risk: Medium
 *  Benefit or PTS #: OS support for Postmortem Debugging
 *  Testing: developer tests
 *  Module(s):
 * 	svr/server/conf/MASTER
 * 	svr/server/conf/MASTER.i860
 * 	svr/server/conf/files.i860
 * 	svr/server/paracore/core_types.h
 * 	svr/server/paracore/allocinfo.c
 * 	svr/server/paracore/core.c
 * 	svr/server/paracore/dump.c
 * 	svr/server/paracore/dvp_pvpcore.c
 * 	svr/server/sys/allocinfo.h
 * 	svr/server/sys/core.h
 * 	svr/server/sys/user.h
 * 	svr/server/nx/nx.defs
 * 	svr/server/nx/nx.c
 * 	svr/server/bsd/kern_exit.c
 * 	svr/server/bsd/kern_fork.c
 * 	svr/server/bsd/kern_sig.c
 * 	svr/server/tnc/dpvproc.h
 * 	svr/server/tnc/dvp_init.c
 * 	svr/server/tnc/dvp_pvpops.c
 * 	svr/server/tnc/pvp.ops
 * 	svr/server/uxkern/fsvr_msg.c
 * 	cmds_libs/src/usr/sbin/allocator/alloc.defs
 * 	cmds_libs/src/usr/sbin/allocator/misc_rpcs.c
 * 	cmds_libs/src/usr/sbin/allocator/Makefile
 * 	cmds_libs/src/usr/include/README.locate
 * 	cmds_libs/src/usr/include/sys/Makefile
 *
 * Revision 1.16  1994/03/14  02:04:37  slk
 * Checkpoint Restart Code Drop
 *  Reviewer: Stefan Tritscher
 *  Risk: Medium
 *  Benefit or PTS #: Enhancement
 *  Testing: Locus VSTNC, EATS TCP-IP, Individual Checkpoint/Restart tests.
 *  Module(s):
 *
 * Revision 1.15  1993/11/12  16:04:06  cfj
 * Backout the change which put the node number in the upper 16 bits of
 * pid 0 (The OSF/1 server) due to problem in that the server may really
 * try to manipulate it's own task as if it was a real process.
 *
 *  Reviewer:
 *  Risk:
 *  Benefit or PTS #:
 *  Testing:
 *  Module(s):
 *
 * Revision 1.14  1993/11/10  18:34:42  cfj
 * Or in the node number for vproc 0 so that when the user does a
 * "ps ax", the "OSF/1 server" entries do not have identical pids.
 *
 *  Reviewer:bolsen@locus.com
 *  Risk:L
 *  Benefit or PTS #:4878
 *  Testing:Tested again WW45.
 *  Module(s):
 *
 * Revision 1.13  1993/11/03  19:07:51  yazz
 * Establish a sequence number mechanism whereby process group signals, such as
 * those generated by CTRL/C, are guaranteed to be delivered to child process(es)
 * of a reproducing (fork(), rfork(), rforkmulti(), etc.) task.  Many unixes
 * have a timing window where new child procs can miss out on a pgrp-style signal.
 *
 * Revision 1.12  1993/10/21  23:33:41  bolsen
 * 10-21-93 Locus code drop for Generic Spanning Tree.
 *
 * Revision 1.11  1993/07/14  18:32:25  cfj
 * OSF/1 AD 1.0.4 code drop from Locus.
 *
 * Revision 1.1.1.5  1993/07/01  20:43:58  cfj
 * Adding new code from vendor
 *
 * Revision 1.10  1993/05/06  19:21:35  cfj
 * ad103+tnc merged with Intel code.
 *
 * Revision 1.1.1.3  1993/05/03  17:44:35  cfj
 * Initial 1.0.3 code drop
 *
 * Revision 1.9  1993/04/16  22:50:04  cfj
 * Merge with T9.5.
 *
 * Revision 1.6.4.2  1993/04/16  22:48:27  cfj
 * Fix deadlock in tnc_locate_vproc_pid().
 *
 * Revision 3.32  93/09/16  08:30:37  chrisp
 * [SPE 0030] Generic Spanning Trees: *_ops_gen.h renamed *_protos_gen.h.
 * 
 * Revision 3.31  93/04/22  16:36:17  roman
 * [Bug 223] vproc_dealloc() called with vproc_list_lock already locked.
 * [Bug 224] Timing window with vproc_release() where the vproc lists
 * 	can end up being corrupted.
 * 
 * Revision 3.30  93/01/26  14:36:39  yazz
 * Better fix for bug #0152:
 * Move the check for invalid node-of-origin within a pid to the
 * tnc_fetch_vproc_port(), and #ifdef it with OSF1_SERVER since an
 * underlying Mach IPC bug is the underlying problem.
 * 
 * Revision 3.29  93/01/20  19:00:29  yazz
 * In tnc_locate_vproc_pid(), if the origin node number contained in the
 * passed pid is not a valid node number, return failure (NULL).
 * 
 * Revision 3.28  92/12/29  13:00:42  chrisp
 * In dvp_init0(), initialize the vproc and pvproc zones.
 * Make checks that vprocs for procs 0/1 are indeed vprocs 0/1 conditional
 * 	on VPROC_DEBUG because vp_index field is conditioned likewise.
 * 
 * Revision 3.27  92/10/28  15:07:55  roman
 * Change inclusion of files generated by makeTNCtables.sh to match
 * 	latest version of file.
 * 
 * Revision 3.26  92/10/09  09:53:41  roman
 * Fix up typecast for a clean 860 compilation.
 * 
 * Revision 3.25  92/10/08  17:01:47  chrisp
 * Include operations tables from automatically generated files. Alter
 * 	names to be consistent across all tables.
 * 
 * Revision 3.24  92/09/29  07:39:46  roman
 * Change all lock initializations and lock invocations to use new macros.
 * Change dpvproc_init() to use a vproc parameter rather than a pvproc
 * 	parameter.
 * Update the vproc and pvproc table initializations with the new operations.
 * Add concept of virtual process system operations and private virtual
 * 	process system operations.
 * Change reference to pvproc fields to use the new (more consistant)
 * 	naming scheme.
 * 
 * Revision 3.23  92/09/21  14:09:56  chrisp
 * Not keeping the vproc hash list locked during VPOP_FREE() (which may go
 * remote) requires extra logic in locate_vproc_pid() to avoid catching a
 * vproc which is being freed but still appears in the hash list.
 * 
 * Revision 3.22  92/07/10  08:56:52  chrisp
 * Initialize the port operation condition in each pvproc.
 * 
 * Revision 3.21  92/07/08  09:07:00  roman
 * Remove tnc_mynode variable, and use this_node variable instead
 * 	(this_node is used by the rest of OSF/1 AD).
 * 
 * Revision 3.20  92/06/17  09:12:25  roman
 * [Bug 0026] New vproc op VPOP_GET_TASK_PORT() added to get task_by_pid() 
 *	system call working.
 * 
 * Revision 3.19  92/03/18  12:08:27  roman
 * Initialize locks to support multi-threaded interruptible server.
 * 
 * Revision 3.18  92/03/12  15:10:28  roman
 * Remove pvproc op for resign_pgrp().
 * Add pvproc op for set_attr().
 * Move call to tnc_init() after vproc 0 is allocated.
 * vproc_hash_list mutex eliminated. Both the free and the hash list are now
 * 	protected by the vproc_list_lock mutex.
 * 
 * Revision 3.17  92/03/03  16:13:57  chrisp
 * Add ADD_CHILD_TO_PARENT.
 * 
 * Revision 3.16  92/02/14  08:44:07  roman
 * Turn on the PV_IS_LOCAL flag for proc 0 and proc 1.
 * 
 * Revision 3.15  92/01/30  14:15:53  chrisp
 * Add ptrace vpop.
 * 
 * Revision 3.14  92/01/15  16:40:58  roman
 * Move call to tnc_init() earlier, so the tnc_mynode is set up by the time
 * the first call to newproc() is made.
 * 
 * Revision 3.13  92/01/10  15:51:48  yazz
 * Comment correction.
 * 
 * Revision 3.12  92/01/10  14:49:58  yazz
 * Credentials (version .74) merge.  Comment change only.
 * 
 * Revision 3.11  92/01/08  16:42:09  chrisp
 * Split dpvproc_init into 2 routines for proc0 and proc1 separately.
 * 
 * Revision 3.10  92/01/03  11:08:34  chrisp
 * Session leader flag changed from proc 0 to proc 1.
 * 
 * Revision 3.9  91/12/24  10:23:39  roman
 * Initialize pvproc using dpvproc_struct_init() rather than just bzero().
 * Add routine dpvproc_struct_init() itself. THis is doe to make sure mutex in
 * pvproc is initialized correctly.
 * 
 * Revision 3.8  91/12/20  16:37:16  chrisp
 * SETPGID becomes a PVPOP. PVPROC_FLAG goes. Orphan pgrp handling revamped.
 * 
 * Revision 3.7  91/12/13  11:01:02  roman
 * Fix bug where the rvpop table was not in sync with dvpop table.
 * 
 * Revision 3.6  91/12/04  07:49:08  chrisp
 * Add pvpops CTTY_GETATTR and SET_CTTY.
 * Set vproc 0 to be considered a session leader to allow it to set its 
 * controlling tty.
 * 
 * Revision 3.5  91/11/26  11:54:43  chrisp
 * Add setsid pvpop.
 * 
 * Revision 3.4  91/11/22  10:19:11  chrisp
 * set_stop_state becomes set_state.
 * 
 * Revision 3.3  91/11/18  11:30:58  chrisp
 * Controlling terminal VPOP changes.
 * 
 * Revision 3.2  91/11/01  17:15:17  roman
 * Add new vproc op VPOP_FREE() to table.
 * 
 * Revision 3.1  91/10/30  14:15:43  roman
 * Change name of routine used by LOCATE_VPROC_PID() macro.
 * 
 * Revision 3.0  91/10/25  10:25:55  roman
 * First appearance of this file in the tnc directory. Used to be in the
 * pvproc directory, which is being deleted. Also changes to so the
 * server can be compiled both with and without TNC.
 * 
 */
#include <sys/vproc.h>
#include <tnc/dpvproc.h>

/*
 * Declarations of ops table for systems with distributed vproc capability
 */
#include <tnc/dvproc_protos_gen.h>
#include <tnc/dvps_protos_gen.h>
#include <tnc/dpvproc_protos_gen.h>
#include <tnc/dpvps_protos_gen.h>

#if MACH_ASSERT
#include <uxkern/const_region.h>
START_CONST_REGION(dvpop);
#endif

#include <tnc/dvpop_tables_gen.c>

#if MACH_ASSERT
END_CONST_REGION(dvpop);
#endif

/*
 * Actually initialize the pvproc table and vproc/pvproc 0.
 */
dpvproc_init0(struct proc *proc0)
{
	struct vproc *v, *w;
	struct pvproc *pvp;
	int hashidx;
	extern struct vproc *vproc_alloc();
	extern struct vproc *tnc_locate_vproc_pid(pid_t pid);
	extern zone_t vproc_zone, pvproc_zone;

	/*
	 * Set up the virtual process system operations table.
	 */
	vps_ops = &dvps_ops_table;

	/*
	 * Set things up so the LOCATE_VPROC_PID() macro works.
	 */
	locate_vproc_pid_routine = tnc_locate_vproc_pid;

	/*
	 * Pre-allocate space for the vproc and pvproc tables.
	 * Though the number of vprocs is actually 0 at his stage.
	 */
	vproc_zone  = zinit(sizeof(struct vproc), 0,
			    nvproc*sizeof(struct vproc), "vproc_table");
	pvproc_zone = zinit(sizeof(struct pvproc), 0,
			    nvproc*sizeof(struct pvproc), "pvproc_table");
	if (vproc_zone == NULL || pvproc_zone == NULL)
		panic("dpvproc_init0: unable to zinit (p)vproc table");
	nvproc = 0;

	/*
	 * Allocate and initialize the vproc and pvproc for vproc[0]
	 * (a dummy process, never used).
	 */

	/* allocate a vproc */
	if ((v = vproc_alloc()) == NULL)
		panic("dpvproc_init0: unable to allocate vproc[0]");
#ifdef	VPROC_DEBUG
	if (v->vp_index != 0)
		panic("dpvproc_init0: initial vproc is not vproc[0]");
#endif
	v->vp_pid = 0;
	pvp = PVP(v);
	dpvproc_struct_init(v);
	pvp->pvp_flag |= PV_IS_LOCAL | PV_IS_ORIGIN;

	/* put the vproc on the vproc hash chain */
	w = vproc_hash[hashidx = VPROCPIDHASH(v->vp_pid)];
	v->vp_hashbwd = NULL;
	v->vp_hashfwd = w;
	vproc_hash[hashidx] = v;
	if (w)
		w->vp_hashbwd = v;

	v->vp_ops = &dvproc_ops_table;
	pvp->pvp_ops = &dpvproc_ops_table;

	VPROC_HOLD(v, "dpvproc_init0");

	/*
	 * Allocate a Mach port for the vproc.
	 */
	(void) vproc_port_allocate(v);
	pvp->pvp_flag |= PV_HAS_PORT_RIGHT;

	/*
	 * point the vproc at the physical process
	 */
	pvp->pvp_pproc = proc0;

	/* sort out the immediate family relationships */
	pvp->pvp_childl = NULL;
	pvp->pvp_head_childl = NULL;
	pvp->pvp_ppid = 0;
	pvp->pvp_foster_ppid = 0;
	pvp->pvp_pgid = 0;
	pvp->pvp_sid = 0;
	pvp->pvp_pgrp_ldr_seqno = 0;
	pvp->pvp_pgrp_mem_seqno = 0;

	VPROC_HOLD(v, "dpvproc_init0");

	/*
	 * Initialize the process structure with values from the pvproc.
	 */
	pproc_set_attr(pvp->pvp_pproc, 
		       v, 
		       &v->vp_pid, 
		       &pvp->pvp_ppid, 
		       &pvp->pvp_pgid, 
		       &pvp->pvp_sid,
		       0);

	/*
	 * Initialize the TNC environment.
	 */
	tnc_init();

}

/*
 * Allocate and initialize the vproc and pvproc for vproc[1]
 * (the init process)
 */
dpvproc_init1(struct proc *proc1)
{
	struct vproc *v, *w;
	struct pvproc *pvp;
	int hashidx;
	extern struct vproc *vproc_alloc();
	extern struct vproc *tnc_locate_vproc_pid(pid_t pid);

	/* allocate a vproc */
	if ((v = vproc_alloc()) == NULL)
		panic("dpvproc_init: unable to allocate vproc[1]");
#ifdef	VPROC_DEBUG
	if (v->vp_index != 1)
		panic("dpvproc_init: initial vproc is not vproc[1]");
#endif
	v->vp_pid = 1;
	pvp = PVP(v);
	dpvproc_struct_init(v);
	pvp->pvp_flag |= PV_IS_LOCAL | PV_IS_ORIGIN;

	/* put the vproc on the vproc hash chain */
	w = vproc_hash[hashidx = VPROCPIDHASH(v->vp_pid)];
	v->vp_hashbwd = NULL;
	v->vp_hashfwd = w;
	vproc_hash[hashidx] = v;
	if (w)
		w->vp_hashbwd = v;

	v->vp_ops = &dvproc_ops_table;
	pvp->pvp_ops = &dpvproc_ops_table;

	VPROC_HOLD(v, "dpvproc_init1");

	/*
	 * Allocate a Mach port for the vproc.
	 */
	(void) vproc_port_allocate(v);
	pvp->pvp_flag |= PV_HAS_PORT_RIGHT;

	/*
	 * point the vproc at the physical process
	 */
	pvp->pvp_pproc = proc1;

	/* sort out the immediate family relationships */
	pvp->pvp_childl = NULL;
	pvp->pvp_head_childl = NULL;
	pvp->pvp_ppid = 0;
	pvp->pvp_foster_ppid = 0;
	pvp->pvp_pgid = 0;
	pvp->pvp_sid = 0;
	pvp->pvp_pgrp_ldr_seqno = 0;
	pvp->pvp_pgrp_mem_seqno = 0;
	pvp->pvp_flag |= PV_SESSIONLEADER;

	VPROC_HOLD(v, "dpvproc_init1");

	/* initialize the process structure with values from the pvproc */
	pproc_set_attr(pvp->pvp_pproc, 
		       v, 
		       &v->vp_pid, 
		       &pvp->pvp_ppid, 
		       &pvp->pvp_pgid, 
		       &pvp->pvp_sid,
		       0);
}


/*
 * Initialization routine necessary for pid generation.
 */

pid_t tnc_pid_node;

void
tnc_pidgen_init()
{
	tnc_pid_node = this_node << NODESHIFT;
}


/*
 * Routine used for LOCATE_VPROC_PID() if TNC is enabled.
 */
struct vproc*
tnc_locate_vproc_pid(
	pid_t	pid)				
{
	register struct vproc *vp;
	struct vproc *nvp = NULL, *w;
	int hashidx;
	extern struct vproc *vproc_alloc();

	/*
	 * First determine if the vproc for this pid exists or not.
	 */
	ASSERT(pid != (pid_t)-1);
	VPROC_LIST_LOCK();
restart:
	for (vp = vproc_hash[VPROCPIDHASH(pid)]; vp != 0; vp = vp->vp_hashfwd)
		if (vp->vp_pid == pid) 
			break;

	/*
	 * If the vproc exists, we just return it, else we do more
	 * checking.
	 */
	if (vp == NULL){

		/*
		 * If this is the origin node of the pid, we just return
		 * 0 because the origin should always retain a vproc
		 * for all its generated pids.
		 */
		if (this_node == VPROCNODE(pid)){
			VPROC_LIST_UNLOCK();
			return(NULL);
		}

		/* 
		 * Since this is not the origin node of the pid, the process
		 * could have migrated to a different node.  We create a vproc
		 * handle to send the rpvpop command -- unless we already have
		 * a vproc in hand.
		 */
		if (nvp == NULL) {
			VPROC_LIST_UNLOCK();
			if ((nvp = vproc_alloc()) == NULL) {
				printf("locate_vproc_pid(): "
				       "vproc_alloc() failure\n");
				return(NULL);
			}
			VPROC_LIST_LOCK();
		}

		/*
		 * Make sure here that during the last vproc_alloc()
		 * call, nobody has created a new vproc for this pid.
		 */
		for (vp = vproc_hash[VPROCPIDHASH(pid)]; 
				vp != 0; 
				vp = vp->vp_hashfwd)
			if (vp->vp_pid == pid) 
				break;
		if (vp == NULL) {
			vp = nvp;
			nvp = NULL;
			dpvproc_struct_init(vp);

			/*
			 * Put the vproc on the vproc hash chain.
			 */
			vp->vp_pid = pid;
			w = vproc_hash[hashidx = VPROCPIDHASH(pid)];
			vp->vp_hashbwd = NULL;
			vp->vp_hashfwd = w;
			vproc_hash[hashidx] = vp;
			if (w)
				w->vp_hashbwd = vp;

			/*
			 * Since this vproc is going to be used for remote
			 * processing, we assign it the rpvproc_ops_table 
			 * instead of the regular pvpop_table.
			 */
			vp->vp_ops = &dvproc_ops_table;
			PVP(vp)->pvp_ops = &rpvproc_ops_table;
		}
	}

	/*
	 * Make a final check that we haven't latched onto a vproc that
	 * is in the process of being freed (special pid -1). We cannot
	 * reliably spot the pid of -1 until the refcnt lock is locked.
	 * If we find a vproc in the process of being freed, then we restart
	 * the search from scratch. Otherwise, increment the reference
	 * count and we're done.
	 */
	VPROC_REFCNT_LOCK(vp);
	if (vp->vp_pid == (pid_t)-1) {
		ASSERT(vp->vp_ref_cnt == 0);
		VPROC_REFCNT_UNLOCK(vp);
		goto restart;
	}
	vp->vp_ref_cnt++;
	VPROC_REFCNT_UNLOCK(vp);
	VPROC_LIST_UNLOCK();

	/*
	 * If we ended up allocating a new vproc but not using it,
	 * it's now safe to de_allocate it (now that the lists are unlocked).
	 */
	if (nvp != NULL)
		vproc_dealloc(nvp);
	return(vp);
}


void
dpvproc_struct_init(
	struct vproc	*v)
{
	struct pvproc	*pvp = PVP(v);

	bzero((caddr_t) pvp, sizeof(struct pvproc));
	VPROC_LOCK_INIT(v);
	VPROC_LOCK_PGRP_LIST_INIT(v);
	VPROC_LOCK_SESSION_LIST_INIT(v);
	VPROC_LOCK_FLAG_INIT(v);
	VPROC_HOLD_MOVEMENT_INIT(v);
	VPROC_LOCK_SCTTY_CACHE_INIT(&pvp->pvp_sctty_cache);
	VPROC_LOCK_PGRP_MEM_SEQNO_INIT(v);
	VPROC_LOCK_PGRP_LDR_SEQNO_INIT(v);
#ifdef PARACORE
	pvp->pvp_core_data = NULL;
#endif /* PARACORE */
}
