/*
 * 
 * $Copyright
 * Copyright 1993, 1994, 1995  Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * (c) Copyright 1990, 1991, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0.2
 */
/*
 * savecore.c	3.2 23:03:59 6/19/90 SecureWare
 *
 * Copyright (c) 1980, 1986, 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that: (1) source distributions retain this entire copyright
 * notice and comment, and (2) distributions including binaries display
 * the following acknowledgement:  ``This product includes software
 * developed by the University of California, Berkeley and its contributors''
 * in the documentation or other materials provided with the distribution
 * and in all advertising materials mentioning features or use of this
 * software. Neither the name of the University nor the names of its
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * "(c) 1980, 1986, 1989 The Regents of the University of California.
 * All rights reserved. "
 *
 * "savecore.c	5.22 (Berkeley) 6/1/90";
 */

#include <sys/secdefines.h>
#if SEC_BASE
#include <sys/security.h>
#include <prot.h>

extern priv_t *privvec();
#endif
#include <stdio.h>
#include <nlist.h>
#include <sys/param.h>
#if	BSD > 43
#include <ufs/fs.h>
#else
#include <sys/fs.h>
#endif
#include <sys/mount.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/syslog.h>
#include <dirent.h>
#include <paths.h>

#define	DAY	(60L*60L*24L)
#define	LEEWAY	(3*DAY)

#define eq(a,b) (!strcmp(a,b))
#if defined(vax) || defined(mips)
#define ok(number) ((number)&0x7fffffff)
#else
#if defined(tahoe) || defined(i386)
#define ok(number) ((number)&~0xc0000000)
#else
#define ok(number) (number)
#endif
#endif

struct nlist current_nl[] = {	/* namelist for currently running system */
#define X_DUMPDEV	0
	{ "_dumpdev" },
#define X_DUMPLO	1
	{ "_dumplo" },
#define X_TIME		2
	{ "_time" },
#define	X_DUMPSIZE	3
	{ "_dumpsize" },
#define X_VERSION	4
	{ "_version" },
#define X_PANICSTR	5
	{ "_panicstr" },
#define	X_DUMPMAG	6
	{ "_dumpmag" },
	{ "" },
};

struct nlist dump_nl[] = {	/* name list for dumped system */
	{ "_dumpdev" },		/* entries MUST be the same as */
	{ "_dumplo" },		/*	those in current_nl[]  */
	{ "_time" },
	{ "_dumpsize" },
	{ "_version" },
	{ "_panicstr" },
	{ "_dumpmag" },
	{ "" },
};

char	*system;
char	*dirname;			/* directory to save dumps in */
char	*ddname;			/* name of dump device */
char	*bddname;			/* name of dump block device */
int	dumpfd;				/* read/write descriptor on block dev */
char	*find_dev();
dev_t	dumpdev;			/* dump device */
time_t	dumptime;			/* time the dump was taken */
int	dumplo;				/* where dump starts on dumpdev */
int	dumpsize;			/* amount of memory dumped */
int	dumpmag;			/* magic number in dump */
time_t	now;				/* current date */
char	*path();
char	*malloc();
char	*ctime();
char	vers[80];
char	core_vers[80];
char	panic_mesg[80];
int	panicstr;
off_t	lseek();
off_t	Lseek();
int	Verbose;
int	force;
int	clear;
extern	int errno;

main(argc, argv)
	char **argv;
	int argc;
{
	char *cp;

#if SEC_BASE
	set_auth_parameters(argc, argv);
	initprivs();

	if (!authorized_user("sysadmin")) {
		fprintf(stderr, "%s: need sysadmin authorization\n",
			command_name);
		exit(1);
	}
	if (forceprivs(privvec(SEC_ALLOWDACACCESS,
#if SEC_MAC
				SEC_ALLOWMACACCESS,
#endif
#if SEC_ILB
				SEC_ILNOFLOAT,
#endif
#if SEC_NCAV
				SEC_ALLOWNCAVACCESS,
#endif
				-1), (priv_t *) 0)) {
		fprintf(stderr, "%s: insufficient privileges\n", command_name);
		exit(1);
	}
#endif /* SEC_BASE */
	argc--, argv++;
	while (argc > 0 && argv[0][0] == '-') {
		for (cp = &argv[0][1]; *cp; cp++) switch (*cp) {

		case 'f':
			force++;
			break;

		case 'v':
			Verbose++;
			break;

		case 'c':
			clear++;
			break;

		default:
		usage:
			fprintf(stderr,
			    "usage: savecore [-f] [-v] [-c] dirname [ system ]\n");
			exit(1);
		}
		argc--, argv++;
	}
	if (argc != 1 && argc != 2)
		goto usage;
	dirname = argv[0];
	if (argc == 2)
		system = argv[1];
	openlog("savecore", LOG_ODELAY, LOG_AUTH);
	if (access(dirname, W_OK) < 0) {
		Perror(LOG_ERR, "%s: %m\n", dirname);
		exit(1);
	}
	read_kmem();
	if (!dump_exists()) {
		if (Verbose)
			fprintf(stderr, "savecore: No dump exists.\n");
		if (!force)
			exit(0);
	}
	if (clear) {
		clear_dump();
		exit(0);
	}
	(void) time(&now);
	check_kmem();
	if (panicstr)
		syslog(LOG_CRIT, "reboot after panic: %s\n", panic_mesg);
	else
		syslog(LOG_CRIT, "reboot\n");
	if ((!get_crashtime() && !force) || !check_space())
		exit(1);
	save_core();
	clear_dump();
	exit(0);
}

dump_exists()
{
	int word;

	dumpfd = Open(bddname, O_RDONLY);
	Lseek(dumpfd, (off_t)(dumplo + ok(dump_nl[X_DUMPMAG].n_value)), L_SET);
	Read(dumpfd, (char *)&word, sizeof (word));
	close(dumpfd);
	if (Verbose && word != dumpmag) {
		printf("dumplo = %d (%d bytes)\n", dumplo/DEV_BSIZE, dumplo);
		printf("magic number mismatch: %x != %x\n", word, dumpmag);
	}
	return (word == dumpmag);
}

clear_dump()
{
	int zero = 0;

	dumpfd = Open(bddname, O_WRONLY);
	Lseek(dumpfd, (off_t)(dumplo + ok(dump_nl[X_DUMPMAG].n_value)), L_SET);
	Write(dumpfd, (char *)&zero, sizeof (zero));
	close(dumpfd);
}

char *
find_dev(dev, type)
	register dev_t dev;
	register int type;
{
	register DIR *dfd = opendir(_PATH_DEV);
	struct dirent *dir;
	struct stat statb;
	static char devname[MAXPATHLEN + 1];
	char *dp;

	strcpy(devname, _PATH_DEV);
	while ((dir = readdir(dfd))) {
		strcpy(devname + sizeof(_PATH_DEV) - 1, dir->d_name);
		if (stat(devname, &statb)) {
			perror(devname);
			continue;
		}
		if ((statb.st_mode&S_IFMT) != type)
			continue;
		if (dev == statb.st_rdev) {
			closedir(dfd);
			dp = malloc(strlen(devname)+1);
			strcpy(dp, devname);
			return (dp);
		}
	}
	closedir(dfd);
	log(LOG_ERR, "Can't find device %d/%d\n", major(dev), minor(dev));
	exit(1);
	/*NOTREACHED*/
}

char *
rawname(s)
	char *s;
{
	static char name[MAXPATHLEN];
	char *sl, *rindex();

	if ((sl = rindex(s, '/')) == NULL || sl[1] == '0') {
		log(LOG_ERR, "can't make raw dump device name from %s?\n", s);
		return (s);
	}
	sprintf(name, "%.*s/r%s", sl - s, s, sl + 1);
	return (name);
}

int	cursyms[] =
    { X_DUMPDEV, X_DUMPLO, X_VERSION, X_DUMPMAG, -1 };
int	dumpsyms[] =
    { X_TIME, X_DUMPSIZE, X_VERSION, X_PANICSTR, X_DUMPMAG, -1 };
read_kmem()
{
	register char *cp;
	FILE *fp;
	char *dump_sys;
	int kmem, i;
	int nlret;

	dump_sys = system ? system : _PATH_UNIX;
	if ((nlret = nlist(_PATH_UNIX, current_nl)) == -1) {
		perror("nlist for current_nl");
		exit(1);
	}
	else if (nlret != 0)
		printf("%d symbols not found in %s\n", nlret, _PATH_UNIX);

	if ((nlret = nlist(dump_sys, dump_nl)) == -1) {
		perror("nlist for dump_nl");
		exit(1);
	}
	else if (nlret != 0)
		printf("%d symbols not found in %s\n", nlret, dump_sys);

	/*
	 * Some names we need for the currently running system,
	 * others for the system that was running when the dump was made.
	 * The values obtained from the current system are used
	 * to look for things in /dev/kmem that cannot be found
	 * in the dump_sys namelist, but are presumed to be the same
	 * (since the disk partitions are probably the same!)
	 */
	for (i = 0; cursyms[i] != -1; i++)
		if (current_nl[cursyms[i]].n_value == 0) {
			log(LOG_ERR, "%s: %s not in namelist\n", _PATH_UNIX,
			    current_nl[cursyms[i]].n_name);
			exit(1);
		}
	for (i = 0; dumpsyms[i] != -1; i++)
		if (dump_nl[dumpsyms[i]].n_value == 0) {
			log(LOG_ERR, "%s: %s not in namelist\n", dump_sys,
			    dump_nl[dumpsyms[i]].n_name);
			exit(1);
		}
	kmem = Open(_PATH_KMEM, O_RDONLY);
	Lseek(kmem, (long)current_nl[X_DUMPDEV].n_value, L_SET);
	Read(kmem, (char *)&dumpdev, sizeof (dumpdev));
	Lseek(kmem, (long)current_nl[X_DUMPLO].n_value, L_SET);
	Read(kmem, (char *)&dumplo, sizeof (dumplo));
	if (Verbose)
		printf("dumplo = %d (%d * %d)\n", dumplo, dumplo/DEV_BSIZE,
		    DEV_BSIZE);
	Lseek(kmem, (long)current_nl[X_DUMPMAG].n_value, L_SET);
	Read(kmem, (char *)&dumpmag, sizeof (dumpmag));
	dumplo *= DEV_BSIZE;
	bddname = find_dev(dumpdev, S_IFBLK); /* block device, for individual items */
	ddname = rawname(bddname); /* raw device, for copying image */
	fp = fdopen(kmem, "r");
	if (fp == NULL) {
		log(LOG_ERR, "Couldn't fdopen kmem\n");
		exit(1);
	}
	if (system)
		return;
	fseek(fp, (long)current_nl[X_VERSION].n_value, L_SET);
	fgets(vers, sizeof (vers), fp);
	fclose(fp);
}

check_kmem()
{
	FILE *fp;
	register char *cp;

	fp = fopen(bddname, "r");
	if (fp == NULL) {
		Perror(LOG_ERR, "%s: %m", bddname);
		exit(1);
	}
	fseek(fp, (off_t)(dumplo+ok(dump_nl[X_VERSION].n_value)), L_SET);
	fgets(core_vers, sizeof (core_vers), fp);
	if (!eq(vers, core_vers) && system == 0) {
		log(LOG_WARNING, "Warning: %s version mismatch:\n", _PATH_UNIX);
		log(LOG_WARNING, "\t%s\n", vers);
		log(LOG_WARNING, "and\t%s\n", core_vers);
	}
	fseek(fp, (off_t)(dumplo + ok(dump_nl[X_PANICSTR].n_value)), L_SET);
	fread((char *)&panicstr, sizeof (panicstr), 1, fp);
	if (panicstr) {
		fseek(fp, dumplo + ok(panicstr), L_SET);
		cp = panic_mesg;
		do
			*cp = getc(fp);
		while (*cp++ && cp < &panic_mesg[sizeof(panic_mesg)]);
	}
	fseek(fp, (off_t)(dumplo + ok(dump_nl[X_DUMPSIZE].n_value)), L_SET);
	fread((char *)&dumpsize, sizeof (dumpsize), 1, fp);
        fclose(fp);
}

get_crashtime()
{
	int dumpfd;
	time_t clobber = (time_t)0;

	dumpfd = Open(bddname, O_RDONLY);
	Lseek(dumpfd, (off_t)(dumplo + ok(dump_nl[X_TIME].n_value)), L_SET);
	Read(dumpfd, (char *)&dumptime, sizeof dumptime);
	close(dumpfd);
	if (dumptime == 0) {
		if (Verbose)
			printf("Dump time is zero.\n");
		return (0);
	}
	printf("System went down at %s", ctime(&dumptime));
	if (dumptime < now - LEEWAY || dumptime > now + LEEWAY) {
		printf("dump time is unreasonable\n");
		return (0);
	}
	return (1);
}

char *
path(file)
	char *file;
{
	register char *cp = malloc(strlen(file) + strlen(dirname) + 2);

	(void) strcpy(cp, dirname);
	(void) strcat(cp, "/");
	(void) strcat(cp, file);
	return (cp);
}

check_space()
{
	long blocks_needed, minfree, spacefree;
	struct statfs fsbuf;
	struct stat sbuf;
	char *image_path;

	image_path = system ? system : _PATH_UNIX;
	if (stat(image_path, &sbuf) < 0) {
		Perror(LOG_ERR, "stat of %s: %m\n", image_path);
		exit(1);
	}

	blocks_needed = (sbuf.st_size + dumpsize*NBPG) / 1024;

	if (statfs(dirname, &fsbuf) < 0) {
		Perror(LOG_ERR, "%s: %m\n", dirname);
		exit(1);
	}
 	spacefree = fsbuf.f_bavail * fsbuf.f_fsize / 1024;
	if (spacefree < blocks_needed) {
		log(LOG_WARNING, "Dump omitted, not enough space on device\n");
		return (0);
	}
	minfree = read_number("minfree");
 	if (spacefree - blocks_needed < minfree) {
		if (!force) {
			log(LOG_WARNING, "Dump omitted, would cross free space threshold\n");
			return (0);
		}
		else
			log(LOG_WARNING,
			    "Dump performed, but free space threshold crossed\n");
	}
	return (1);
}

read_number(fn)
	char *fn;
{
	char lin[80];
	register FILE *fp;

	fp = fopen(path(fn), "r");
	if (fp == NULL)
		return (0);
	if (fgets(lin, 80, fp) == NULL) {
		fclose(fp);
		return (0);
	}
	fclose(fp);
	return (atoi(lin));
}

#define	BUFSIZE		(256*1024)		/* 1/4 Mb */

save_core()
{
	register int n;
	register char *cp;
	register int ifd, ofd, bounds;
	int ret;
	char *bfile;
	register FILE *fp;

	cp = malloc(BUFSIZE);
	if (cp == 0) {
		log(LOG_ERR, "savecore: Can't allocate i/o buffer.\n");
		return;
	}
	bounds = read_number("bounds");
	ifd = Open(system ? system : _PATH_UNIX, O_RDONLY);
	(void)sprintf(cp, "vmunix.%d", bounds);
#if SEC_BASE
	ofd = Create(path(cp), 0600);
#else
	ofd = Create(path(cp), 0644);
#endif
	while((n = Read(ifd, cp, BUFSIZ)) > 0)
		Write(ofd, cp, n);
	close(ifd);
	close(ofd);
	if ((ifd = open(ddname, O_RDONLY)) == -1) {
		Perror(LOG_ERR, "%s: %m", ddname);
		log(LOG_WARNING, "Cannot open raw device, reading from block device\n");
		ifd = Open(bddname, O_RDONLY);
	}
	(void)sprintf(cp, "vmcore.%d", bounds);
#if SEC_BASE
	ofd = Create(path(cp), 0600);
#else
	ofd = Create(path(cp), 0644);
#endif
	Lseek(ifd, (off_t)dumplo, L_SET);
	dumpsize *= NBPG;
	log(LOG_NOTICE, "Saving %d bytes of image in vmcore.%d\n",
	    dumpsize, bounds);
	while (dumpsize > 0) {
		n = read(ifd, cp,
		    dumpsize > BUFSIZE ? BUFSIZE : dumpsize);
		if (n <= 0) {
			if (n == 0)
				log(LOG_WARNING,
				    "WARNING: EOF on dump device; %s\n",
				    "vmcore may be incomplete");
			else
				Perror(LOG_ERR, "read from dumpdev: %m",
				    "read");
			break;
		}
		if ((ret = write(ofd, cp, n)) < n) {
			if (ret < 0)
				Perror(LOG_ERR, "write: %m", "write");
			else
				log(LOG_ERR, "short write: wrote %d of %d\n",
				    ret, n);
			log(LOG_WARNING, "WARNING: vmcore may be incomplete\n");
			break;
		}
		dumpsize -= n;
	}
	close(ifd);
	close(ofd);
	bfile = path("bounds");
	fp = fopen(bfile, "w");
	if (fp) {
		fprintf(fp, "%d\n", bounds+1);
		fclose(fp);
	} else
		Perror(LOG_ERR, "Can't create bounds file %s: %m", bfile);
	free(cp);
}

/*
 * Versions of std routines that exit on error.
 */
Open(name, rw)
	char *name;
	int rw;
{
	int fd;

	fd = open(name, rw);
	if (fd < 0) {
		Perror(LOG_ERR, "%s: %m", name);
		exit(1);
	}
	return (fd);
}

Read(fd, buff, size)
	int fd, size;
	char *buff;
{
	int ret;

	ret = read(fd, buff, size);
	if (ret < 0) {
		Perror(LOG_ERR, "read: %m", "read");
		exit(1);
	}
	return (ret);
}

off_t
Lseek(fd, off, flag)
	int fd, flag;
	long off;
{
	long ret;

	ret = lseek(fd, off, flag);
	if (ret == -1) {
		Perror(LOG_ERR, "lseek: %m", "lseek");
		exit(1);
	}
	return (ret);
}

Create(file, mode)
	char *file;
	int mode;
{
	register int fd;

	fd = creat(file, mode);
	if (fd < 0) {
		Perror(LOG_ERR, "%s: %m", file);
		exit(1);
	}
	return (fd);
}

Write(fd, buf, size)
	int fd, size;
	char *buf;
{
	int n;

	if ((n = write(fd, buf, size)) < size) {
		if (n < 0)
			Perror(LOG_ERR, "write: %m", "write");
		else
			log(LOG_ERR, "short write: wrote %d of %d\n", n, size);
		exit(1);
	}
}

log(level, msg, a1, a2)
	int level;
	char *msg;
{

	fprintf(stderr, msg, a1, a2);
	syslog(level, msg, a1, a2);
}

Perror(level, msg, s)
	int level;
	char *msg;
        char *s;
{
	int oerrno = errno;
	
	perror(s);
	errno = oerrno;
	syslog(level, msg, s);
}
