      SUBROUTINE DVECTOR(DIR, N, NB, X )
      CHARACTER*1    DIR
      INTEGER        N, NB
      DOUBLE PRECISION   X( * )
*
*  Purpose
*  =======
*
*  Generate vector
*
*  Arguments
*  =========
*
*
*  DIR    (input) character*1
*         direction in which vector is to be distributed
*         'Column' or 'Row'
*
*  N      (input) integer
*         total length of vector
*
*  NB     (input) integer
*         block size used for wrapping the vector
*
*  x      (output) DOUBLE PRECISION array, dimension ( myn )
*         local portion of the vector
*
*
*  Details
*  =======
*
*  The vector is generated distributed like the first column
*  of the matrix generated by the subroutine matrix().  See
*  the documentation of that routine
*
*     THIS VERSION DATED 08/18/92
*     R. VAN DE GEIJN
*
*     All rights reserved
*  .. 
*  .. Local Scalars ..
*
*     nprow          row dimension of node grid
*     npcol          column dimension of node grid
*     myrow          my row index
*     mycol          my column index
*
      INTEGER        NPROW, NPCOL, MYROW, MYCOL
*
*     myn            size of local portion of vector
*
      INTEGER        MYN
*
*     misc.
*
      INTEGER        I, J, II, IDUMMY
*  .. 
*  .. Local Arrays ..
*  .. 
*  .. Intrinsic Functions ..
*  .. 
*  .. External Functions ..
      DOUBLE PRECISION     DDUMMY
      DOUBLE PRECISION RAND
      LOGICAL        LSAME
*  .. 
*  .. External Subroutines ..
      EXTERNAL       PLAMCH2, IMYPART
*     ..
*     .. Executable Statements ..

      CALL PLAMCH2(NPROW, NPCOL, MYROW, MYCOL)
*    
*     compute where my part of matrix starts
*     inefficient, but it works
*
      IF ( LSAME( DIR, 'C' ) ) THEN
         DDUMMY = RAND( 1 )
c
c     New seed to ensure the same test matrix is always generated
c     regardless of nprow, npcol, nb
c

         II = 1
         DO 100 I=0, MYROW-1
            CALL IMYPART( 1, N, NB, IDUMMY, MYN, I, NPROW )
            II = II+MYN
 100      CONTINUE

*
*        this node's portion of the vector is size myn
*
         CALL IMYPART( 1, N, NB, IDUMMY, MYN, MYROW, NPROW )
*
*        generate the portion of the matrix that starts at 
*        element ii of size myn
*
         do I=II, II+MYN-1
            x( I-II+1 ) = 0.0d00 
         enddo

         do J=1,N
            do I=1, II-1
               ddummy = rand(0)
            enddo
            
            do I=II, II+MYN-1
               X( I-II+1 ) = X( I-II+1 ) +  
     $              rand(0)
            enddo

            do I=II+MYN, N
               ddummy = rand(0)
            enddo
         enddo

      ELSE IF ( LSAME( DIR, 'R') ) THEN
         II = 1
         DO 120 I=0, MYCOL-1
            CALL IMYPART( 1, N, NB, IDUMMY, MYN, I, NPCOL )
            II = II+MYN
 120     CONTINUE

*
*        this node's portion of the vector is size myn
*
         CALL IMYPART( 1, N, NB, IDUMMY, MYN, MYCOL, NPCOL )
*
*        generate the portion of the matrix that starts at 
*        element ii of size myn
*
         do 125 I=1, II-1
            ddummy = rand(0)
 125     continue

         DO 130 I=II, II+MYN-1
*     
*           x( i-ii+1 ) = ith element of vector
*
            X( I-II+1 ) = rand( 0 )
 130     CONTINUE

         do 225 I=II+MYN, n
            ddummy = rand(0)
 225     continue
      ENDIF

      RETURN
      END

