/*
 * 
 * $Copyright
 * Copyright 1993, 1994, 1995  Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*==========================================================================*
 *                                                                          *
 *                 (C) Copyright 1993 Intel Corporation                     *
 *                         All rights reserved                              *
 *                                                                          *
 *               INTEL CORPORATION PROPRIETARY INFORMATION                  *
 *                                                                          *
 *   This software is supplied under the terms of a license agreement or    *
 *   nondisclosure agreement with Intel Corporation and may not be copied   *
 *   or disclosed except in accordance with the terms of that agreement.    *
 *                                                                          *
 *==========================================================================*/

/*==========================================================================*
 *
 *     Title:
 *        $Id: allocsys2.c,v 1.7 1994/11/19 02:29:03 mtm Exp $
 *
 *     Description:
 *        Partition library calls:
 *              int        _nx_allocator_ignore()
 *
 *     History:
 *        $Log: allocsys2.c,v $
 * Revision 1.7  1994/11/19  02:29:03  mtm
 * Copyright additions/changes
 *
 * Revision 1.6  1993/12/01  01:14:03  carbajal
 * _allocator_ingore now makes a system call instead of calling allocator
 * directly
 *  Reviewer: None
 *  Risk: Low
 *  Benefit or PTS #: Generic interface for call, reduces reliance on MIG
 *  stubs to allocator
 *  Testing:
 *  Module(s):
 *
 * Revision 1.5  1993/07/20  17:33:37  carbajal
 * Removed Usage(), this is no longer needed.
 *
 * Revision 1.4  1993/06/04  16:49:58  carbajal
 * Added a null function Usage() to allow for
 * proper linking
 *
 * Revision 1.3  1993/05/26  21:38:39  carbajal
 * Changed all user visable calls and types to be prefixed by nx_
 *
 * Revision 1.2  1993/05/18  19:51:09  carbajal
 * Moved get_part_names from allocsys2.c to allocsys.c
 *
 * Revision 1.1  1993/05/11  21:06:03  carbajal
 * Allocator system calls for tools support
 *
 *
 *==========================================================================*/
static char rcsid[] = "$Id: allocsys2.c,v 1.7 1994/11/19 02:29:03 mtm Exp $";

#include <mach/kern_return.h>
#include <mach/mach_types.h>
#include <sys/limits.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <errno.h>
#include <dirent.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>


/***************************************************************************
//    
//    Calling Sequence:
//          _nx_allocator_ignore()
//    
//    Description:
//          From a root priviledged process, send a remove_nx_appl
//          message to the allocator indicating that this process
//          group does not exist.  Thus the root priviledged process
//          can create an NX application, tell the allocator it 
//          no longer exists and thus can be free of the roll-in/roll-out
//          signals generated by the allocator.
//    
//    Parameters:
//          None
//    
//    Returns:
//          Returns 0 if success or -1 if failure
//    
***************************************************************************/

int
_nx_allocator_ignore()
{
	return(nx_alloc_exit_rpc(getpgrp()));
}

