/*
 * 
 * $Copyright
 * Copyright 1993, 1994, 1995  Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*++ nqsmgrhelp.c - Network Queueing System
 *
 * /afs/ssd/i860/CVS/cmds_libs/src/usr/bin/qmgr/nqsmgrhelp.c,v
 *
 * DESCRIPTION:
 *
 *	Construct Qmgr help include constant file:
 *
 *		./nqsmgrhelp.h
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	September 9, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: (1.1 1992/12/18 00:36:19 Exp)
 * nqsmgrhelp.c,v
 * Revision 1.1  1992/12/18  00:36:19  rkl
 * Builds help include file for qmgr.
 *
 * Revision 3.2  91/02/11  16:59:17  root
 * Version 2.0 Source
 * 
 * Revision 2.2  87/04/22  15:12:14  hender
 * Sterling version 4/22/87
 * 
 *
 */

#include <stdio.h>
#include <sys/types.h>			/* Get time_t definition */
#include <sys/time.h>

extern int errno;			/* System call error number */
extern char *fmttime();			/* Format date and time string */
extern char *sys_errlist[];		/* Error list explanation */
extern time_t time();			/* Get current time */

/*** main
 *
 *
 *	int main():
 */
main ()
{
	static char temp[] = "XQMGR_TEMP.H";
	/*
	static char qmgr_hlp[] = "../../lib/nqs/qmgr.hlp";
	*/
	static char qmgr_hlp[] = "qmgr.hlp";

					/* Temporary version of nqsmgrhelp.h */
	FILE *helpfile;			/* NQS qmgr help file */
	FILE *includefile;		/* Nqsmgrhelp.h include file under */
					/* construction */
	int fd;				/* Integer file descriptor */
	long offset;			/* Help file offset */
	register short prevch;		/* Previous character */
	register short ch;		/* Current character */
	time_t time_val;		/* Current time */

	time (&time_val);		/* Get current time */
	if ((fd = creat (temp, 0444)) == -1) {
		/*
		 *  Unable to open temporary file.
		 */
		printf ("Unable to open temp file: %s.\n", temp);
		printf ("Reason: %s.\n", sys_errlist [errno]);
		exit (1);
	}
	includefile = fdopen (fd, "w");
	if ((helpfile = fopen (qmgr_hlp, "r")) == NULL) {
		/*
		 *  Unable to open source help file.
		 */
		printf ("Unable to open qmgr help file: %s.\n", qmgr_hlp);
		printf ("Reason: %s.\n", sys_errlist [errno]);
		exit (2);
	}

	fputs ("/*", includefile);
	fputs (" *\n", includefile);
	fputs (" * This file is generated by the nqsmgrhelp progam on\n",
								includefile);
	fputs (" *\n", includefile);
	fputs (" *	", includefile);
	fputs (fmttime (&time_val), includefile);
	fputs (" *\n", includefile);
	fputs (" *\n", includefile);
	fputs (" * Do not edit it by hand\n", includefile);
	fputs (" *\n", includefile);
	fputs (" * DESCRIPTION:\n", includefile);
	fputs (" *\n", includefile);
	fputs (" *	NQS qmgr help file offset definitions file.\n",
								includefile);
	fputs (" *\n", includefile);
	fputs (" */\n", includefile);
	fputs ("\n", includefile);

	/*
	 *  The header for the nqsmgrhelp file has now been written.
	 *  Scan the help source file to generate the proper #define
	 *  constants.
	 */
	offset = 0;
	prevch = '\n';
	while ((ch = getc (helpfile)) != EOF) {
		offset++;			/* One more character */
		if (ch == '#' && prevch == '\n') {
			/*
			 *  A '#' has been found at the beginning of a line
			 *  in the help file.  This marks the beginning of a
			 *  help page.
			 */
			fputs ("#define	", includefile);
			while ((ch = getc (helpfile)) != EOF && ch != '\n') {
				offset++;	/* One more character */
				/*
				 *  Scan the help page name.
				 */
				putc (ch, includefile);
			}
			offset++;		/* Newline character read */
			fprintf (includefile, "\t%1ldL\n", offset);
		}
		prevch = ch;			/* Remember prev char */
	}
	/*
	 *  We are done generating the #include file for the NQS qmgr
	 *  help file offsets.  Unlink the old nqsmgrhelp.h file and
	 *  link in the new version.
	 */
	fclose (includefile);
	fclose (helpfile);
	unlink ("nqsmgrhelp.h");
	if (link (temp, "nqsmgrhelp.h") == -1) {
		/*
		 *  Unable to establish link to new version of the
		 *  #include NQS qmgr help file offsets file.
		 */
		printf ("Nqsmgrhelp.h #include file update failed.\n");
		printf ("Reason: %s.\n", sys_errlist [errno]);
		exit (3);
	}
	unlink (temp);
	/*
	 *  Return successful completion to the caller.
	 */
	exit (0);
}

/*** fmttime
 *
 *
 *	char *fmttime():
 *
 *	Return a pointer to a formatted time string where the time
 *	is specified as a long integer defining the number of seconds
 *	since 00:00:00 GMT, January 1, 1970.
 */
char *fmttime (timeinsecs)
time_t *timeinsecs;
{
#ifndef _XOPEN_SOURCE
	/* This may not be the best thing to switch on here.  The problem
	 * is that the timezone function is not in the Paragon C library, while
	 * it is on the Suns and Mt. Xinu 486 boxes.  Thus this workaround.
	 * Without this this function does not compile native on Paragon.
	 *		Dave Leslie 3/24/93.
	 */
	extern char *timezone();
#else
	char buff[16];
	char sign;
#endif
	extern struct tm *localtime ();	/* Get local time */
	extern char *asctime();		/* Format time */

	static char buffer [40];	/* Output buffer */
	char *tzn;			/* Time zone name */
	char *ts;			/* Time string */
	struct tm *tp;			/* Time structure pointer */

	struct	timeval	tv;
	struct	timezone tz;

	gettimeofday (&tv, &tz);
	tp = localtime (timeinsecs);
	ts = asctime (tp);
#ifndef _XOPEN_SOURCE 
	tzn = timezone (tz.tz_minuteswest, tp->tm_isdst);
#else
	sign = (timezone > 0 ? '-' : '+');
	sprintf(buff, "GMT%c%d:%.2d", sign, abs(timezone / (60 * 60)), 
		timezone % (60 * 60));
	tzn = buff;
#endif
		
	if (tzn == (char *) 0) tzn = "";
	ts [24] = '\0';				/* Zap newline character */
	sprintf (buffer, "%.20s%s%s", ts, tzn, ts+19);
	return (buffer);
}
