/*
 * 
 * $Copyright
 * Copyright 1993, 1994, 1995  Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

#if !defined(lint) && !defined(_NOIDENT)
static char rcsid[] = "@(#)$RCSfile: cm_mknods.c,v $ $Revision: 1.2 $ (OSF) $Date: 1994/11/21 16:40:27 $";
#endif

#include <stdio.h>
#include <AFdefs.h>
#include <dirent.h>
#include <syslog.h>
#include <errno.h>
#include <sys/limits.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "cm.h"

#define	IS_DEVICE(x)	(S_ISCHR((x).st_mode) || S_ISBLK((x).st_mode))
#define	IS_DIRECTORY(x)	(S_ISDIR((x).st_mode))

int	mknod_cnt;
int	rmnod_cnt;


int
cm_mkdirpath ( char * dir, mode_t dmode )
{
	char *	dirp;
                                    		/* Skip any leading "/"'s */
	for (dirp = dir; *dirp == '/'; dirp++)
		continue;
						/* Iterate thru @ component */
	while ((dirp = (char *)NLstrchr(dirp, '/')) != '\0') {
		*dirp = '\0';
						/* mkdir, may err if exists */
		if (mkdir((char *)dir, dmode) != 0 && errno != EEXIST)
			return(MKNODS_EPERM);
						/* put "/" back, skip "/"'s */
		for (*dirp++ = '/'; *dirp == '/'; dirp++)
			continue;
	}
	return(0);
}


void
cm_mknods_destroy_major( cm_log_t * logp, char * entname, ulong op_flags, 
		char * dirname, int majno, int depth )
{
	struct stat 	statbuf;
	struct dirent * dp;
	DIR *		dirp;
	char 		path[PATH_MAX];
	int		rc;

	if (majno <= 0 || dirname == NULL || (dirp=opendir(dirname)) == NULL)
		return;

	for ( ; (dp=readdir(dirp)) != NULL; ) {

		strcpy(path, dirname);
		strcat(path, "/");
		strcat(path, dp->d_name);

		if (stat(path, &statbuf))
			continue;

		if (IS_DEVICE(statbuf) && majno == major(statbuf.st_rdev)) {

			rc = unlink(path);
			rmnod_cnt++;

			if (logp == NULL || !(op_flags & CM_RPT_RMNOD))
				continue;

			if (rmnod_cnt == 1 && (op_flags & CM_RPT_HEADER))
				cm_log(logp, LOG_ERR, cm_msg(MKNODS_REMOVING),
					entname);
			if (rc)
				cm_log(logp, LOG_ERR, cm_msg(MKNODS_EREMOVED),
					entname, path);
			else
				cm_log(logp, LOG_ERR, cm_msg(MKNODS_REMOVED),
					entname, path);

		} else if (IS_DIRECTORY(statbuf)) {
			if (!strcmp(dp->d_name,".") || !strcmp(dp->d_name,".."))
				continue;
			if (depth++ > 5)
				continue;
			cm_mknods_destroy_major(logp, entname, op_flags,
					path, majno, depth);
		}
    	}
    	closedir(dirp);
    	return;
}

/*
 *
 */
int
cm_mknods( cm_log_t * logp, char * entname, ulong op_flags, 
		cm_devices_t * devices )
{
	char *	fname;
	char *	p;
	int	i;
	int	devindex;
	int	minno;
	int	majno;
	int	rc;
	int	num;
	int	mode;
	int	error;
	struct stat 	statbuf;
	char 		filepath[PATH_MAX];
	device_names_t  devnamelst;
	device_minors_t devminorlst;
#define	MAX_DEVNAMES	128
	int     	margv_vec[MAX_DEVNAMES];
	char *		dargv_vec[MAX_DEVNAMES];

	/*
	 *	Initialize device name and minor list structures
	 */
	for (devindex=0; devindex < MAX_DEVNAMES; devindex++) {
		if ((dargv_vec[devindex] =
			(char *)calloc(NAME_MAX, sizeof(char))) == NULL) {
			error = MKNODS_ENOMEM;
			goto leave;
		}
	}
	devnamelst.dargv = dargv_vec;
	devnamelst.dargc = 0;
	devnamelst.dsiz = MAX_DEVNAMES;
	devnamelst.derr = 0;

	devminorlst.margv = margv_vec;
	devminorlst.margc = 0;
	devminorlst.msiz = MAX_DEVNAMES;
	devminorlst.merr = 0;

	/*
	 *	Expand device name and minor expressions into list structures
	 */
	(void) dbattr_mkdevnames(devices->devfiles, &devnamelst);
	(void) dbattr_mkdevminors(devices->devminors, &devminorlst);

	/*
	 *	Check for errors in expending expresssions
	 */
	if (devnamelst.derr) {
		error = devnamelst.derr;
		goto leave;
	}
	if (devminorlst.merr) {
		error = devminorlst.merr;
		goto leave;
	}

	if ((num=devnamelst.dargc) != devminorlst.margc) {
		error = MKNODS_EINVAL;
		goto leave;
	}
	if ((majno=devices->majno) <= 0) {
		error = MKNODS_ENOENT;
		goto leave;
	}
						/* Generate basepath */
	filepath[0] = '\0';
	if (devices->dir != NULL) {
		strcpy(filepath, devices->dir);
		strcat(filepath, "/");
	}
	if (devices->subdir != NULL) {
		strcat(filepath, devices->subdir);
		strcat(filepath, "/");
	}
	if (filepath[0] == '\0') {
		error = MKNODS_ENOENT;
		goto leave;
	}

					/* Remove old MAJOR device files */
	mknod_cnt = 0;
	rmnod_cnt = 0;
	if (op_flags & CM_RMNOD_MAJR) {
		if (op_flags & CM_MKNOD_FILE)
			cm_mknods_destroy_major(NULL, entname, op_flags,
				devices->dir, devices->majno, 0);
		else
			cm_mknods_destroy_major(logp, entname, op_flags,
				devices->dir, devices->majno, 0);
	}

					/* No device files to rm or mk */
	if ((op_flags & (CM_RMNOD_FILE|CM_MKNOD_FILE)) == 0) {
		error = 0;
		goto leave;
	}

					/* Make device path, if needed */
	if (op_flags & CM_MKNOD_FILE && stat(filepath, &statbuf)) {
		if (errno == ENOENT) {
			if (error=cm_mkdirpath(filepath, DIRMODE_DFLT))
				goto leave;
		}
	}
					/* Loop thru device file list */
	p = filepath +strlen(filepath);
	mode = devices->mode | devices->type;

	if (!(op_flags & CM_RMNOD_FILE))
		goto make;

    	for (i=0; i < num; i++) {
		fname = devnamelst.dargv[i];
		minno = devminorlst.margv[i];

		if (fname == NULL || *fname == '\0' || minno < 0)
			continue;

		strcpy(p, fname);

		if (stat(filepath, &statbuf))
			continue;

		rc = unlink(filepath);
		rmnod_cnt++;

		if (logp == NULL || !(op_flags & CM_RPT_RMNOD))
			continue;

		if (!(op_flags & CM_MKNOD_FILE))
			continue;

		if (rmnod_cnt == 1 && (op_flags & CM_RPT_HEADER)) 
			cm_log(logp, LOG_ERR, cm_msg(MKNODS_REMOVING),
				entname);
		if (rc)
			cm_log(logp, LOG_ERR, cm_msg(MKNODS_REMOVED),
				entname, filepath);
		else
			cm_log(logp, LOG_ERR, cm_msg(MKNODS_EREMOVED),
				entname, filepath);
	}

make:
	if (!(op_flags & CM_MKNOD_FILE))
		goto leave;

    	for (i=0; i < num; i++) {
		fname = devnamelst.dargv[i];
		minno = devminorlst.margv[i];

		if (fname == NULL || *fname == '\0' || minno < 0)
			continue;

		strcpy(p, fname);

		rc = mknod(filepath, mode, makedev(majno, minno));
		mknod_cnt++;

		if (logp == NULL || !(op_flags & CM_RPT_MKNOD)) 
			continue;

		if (mknod_cnt == 1 && (op_flags & CM_RPT_HEADER)) 
			cm_log(logp, LOG_ERR, cm_msg(MKNODS_MAKING), entname);

		if (rc)
			cm_log(logp, LOG_ERR, cm_msg(MKNODS_ECREATE),
				entname, filepath, majno, minno);
		else
			cm_log(logp, LOG_ERR, cm_msg(MKNODS_CREATED),
				entname, filepath, majno, minno);
	}
	error = 0;

leave:
	for(i=0; i < devindex; i++)
		(void) free(dargv_vec[i]);
	return(error);
}



