/* pic_nw.c - jumpering of ISI nw board */

/*
modification history
--------------------
*/

/*
This module contains the jumpering of ISI nw board.
*/

#include "UniWorks.h"
#include "picture.h"


/*******************************************************************************
*
* drawNw - draw nw
*/

VOID drawNw (pic)
    char *pic;

    {
    static int block[] = {10, 12, 11, 9, 7, 5};
    int io_adrs = 0;
    int int_lvl = 0;
    int ix;

    printAt (pic, 38, 1, "NW");
    jumperAt (pic, 5, 4, 8, HORIZONTAL, VERTICAL, 0xaf);
    printAt (pic, 5, 5, " IO ADRS");
    jumperAt (pic, 48, 4, 4, HORIZONTAL, VERTICAL, 0x0);
    jumperAt (pic, 53, 4, 4, HORIZONTAL, VERTICAL, 0x0);
    printAt (pic, 48, 5, " IO ADRS");

    /* io address */
    io_adrs = nw_io >> 17;

    for (ix = 0; ix < 6; ix++)
	if ((io_adrs = io_adrs >> 1) & 1)
	    jumperAt (pic, block[ix], 4, 1, HORIZONTAL, VERTICAL, 0x0);

    /* int level */
    int_lvl = (0x1 << (il_nw - 1));
    jumperAt (pic, 22, 3, 7, HORIZONTAL, VERTICAL, int_lvl);
    printAt (pic, 22, 4, "INT LVL");

    /* int ack */
    int_lvl = ~(il_nw) << 1;
    jumperAt (pic, 36, 3, 4, HORIZONTAL, VERTICAL, int_lvl);
    printAt (pic, 36, 4, "INT ACK");

    if (!inc_nw)
	printf ("Warning: nw not included.\n");
    }
