/* m68153.h - Motorola 68153 Bus Interruptor Module header file */

/*
modification history
--------------------
01a,03jun88,tja  extracted from frc21.h
*/

#ifndef	INCm68153h
#define	INCm68153h


/* BIM addresses */

#define BIM_CR1(base)	((char *) ((base) + 0x01))	/* control reg 1 */
#define BIM_CR2(base)	((char *) ((base) + 0x03))	/* control reg 2 */
#define BIM_CR3(base)	((char *) ((base) + 0x05))	/* control reg 3 */
#define BIM_CR4(base)	((char *) ((base) + 0x07))	/* control reg 4 */
#define BIM_VR1(base)	((char *) ((base) + 0x09))	/* vector reg 1 */
#define BIM_VR2(base)	((char *) ((base) + 0x0b))	/* vector reg 2 */
#define BIM_VR3(base)	((char *) ((base) + 0x0d))	/* vector reg 3 */
#define BIM_VR4(base)	((char *) ((base) + 0x0f))	/* vector reg 4 */

/* BIM control reg bits */

#define BIM_IRE		0x10		/* interrupt enable */
#define BIM_IRAC	0x08		/* interrupt auto-clear */
#define BIM_XIN		0x20		/* don't supply vector */
#define BIM_F		0x80		/* user defined flag */
#define BIM_FAC		0x40		/* clear flag in interrupt */

#endif	INCm68153h
