/* pic_cpu.c - SUN3/e jumpering */

static char *copyright = "Copyright 1988, Wind River Systems, Inc.";

/*
modification history
--------------------
01a,05aug88,pht  written.
*/

/*
This module contains the jumpering of the SUN 3/e.
It is only used by jump (4).

SEE ALSO: jump (4)
*/

#include "UniWorks.h"
#include "config.h"
#include "picture.h"


/*******************************************************************************
*
* drawBoard - draw cpu jumper config
*
* ARGSUSED1
*/

VOID drawBoard (pic, interactive)
    char *pic;
    BOOL interactive;

    {
    int i;
    int j;
    int temp;
    int inrLvl = 0;
    int jumpSt[8];

    bzero (jumpSt, sizeof (jumpSt));

    printAt (pic, 35, 1, "SUN 3/e");

    printAt (pic, 3, 14, " __________ ");
    printAt (pic, 3, 15, "|          |");
    printAt (pic, 3, 16, ">   ROM    |");
    printAt (pic, 3, 17, "|__________|");

    if (inc_ex)
	jumpSt[INT_LVL_EX]  = 1;
    if (inc_enp)
	jumpSt[INT_LVL_ENP] = 1;
    if (inc_ie)
	jumpSt[INT_LVL_IE]  = 1;
    if (inc_nw)
	jumpSt[INT_LVL_NW]  = 1;
    if (inc_pn)
	jumpSt[INT_LVL_PN]  = 1;

    for (j = 1; j <= 7; j++)          /* Calculating interrupt level variable */
	{ 
	if (jumpSt [j]==1)
	    { 
	    temp = 1;
	    for (i = 1; i <= 8 - j; i++)
		temp*=2;
	    inrLvl+=temp;
	    }
	}

    inrLvl /= 2;

    jumperAt(pic,35, 3, 7, HORIZONTAL, VERTICAL,   inrLvl);
    jumperAt(pic,42, 3, 2, HORIZONTAL, VERTICAL,   0x1);
    jumperAt(pic,39,16, 4, VERTICAL,   HORIZONTAL, 0xf);

    printAt(pic,32,3," .");
    printAt(pic,32,4,".:");
    printAt(pic,32,5,"X ");
  
    printAt(pic,41,18,"J800 3&4: System Controller");
    }
