/* pic_cpu.c - Mizar mz8115 jumpering */

static char *copyright = "Copyright 1988, Wind River Systems, Inc.";

/*
modification history
--------------------
01a,25jul87,pht  written.
*/

/*
This module contains the jumpering of the Mizar mz8115.
It is only used by jump (4).

SEE ALSO: jump (4)
*/

#include "UniWorks.h"
#include "config.h"
#include "picture.h"


/*******************************************************************************
*
* drawBoard - draw cpu jumper config
*
* ARGSUSED1
*/

int jumpSt[7];

VOID drawBoard (pic, interactive)
    char *pic;
    BOOL interactive;

    {
    void setJump();
    int i,j,k,m,n,inrLvl,temp;

    /* chop-off P2 bus ...*/
    for (m=0; m<=22; m++)
      printAt (pic, 34, m, "                                            ");
    for (n=3; n<=22; n++)
      printAt (pic, 34, n, "|");

    printAt (pic, 34, 1, "mz8115");

    for (i=1; i<=7; i++)
      jumpSt[i]=0;

   inrLvl=0;

   if (inc_ex)
       setJump(INT_LVL_EX);
   if (inc_enp)
       setJump(INT_LVL_ENP);
   if (inc_ie)
       setJump(INT_LVL_IE);
   if (inc_nw)
       setJump(INT_LVL_NW);
   if (inc_pn)
       setJump(INT_LVL_PN);

   for (j=1; j<=7; j++)   
     {
     if (jumpSt[j]==1)
       {
       temp=1;
       for (k=1; k<=j; k++)
	 temp*=2;
       inrLvl+=temp;
       }
     }
   inrLvl/=2;

   jumperAt(pic, 24, 16, 7, HORIZONTAL, VERTICAL, inrLvl);
   jumperAt(pic, 31, 16, 2, HORIZONTAL, VERTICAL, 0x3);
   jumperAt(pic, 23, 16, 1, HORIZONTAL, VERTICAL, 0x0);

   jumperAt(pic, 15, 12, 4, HORIZONTAL, VERTICAL, 0x4);
 
   printAt (pic, 19,  8," ____________ ");
   printAt (pic, 19,  9,"|            |");
   printAt (pic, 19, 10,"|   LB U12   <");
   printAt (pic, 19, 11,"|____________|");
   printAt (pic, 19, 12," ____________ ");
   printAt (pic, 19, 13,"|            |");
   printAt (pic, 19, 14,"|   UB U11   <");
   printAt (pic, 19, 15,"|____________|");

   printAt (pic,  7, 14,"SYSCON K5");
   printAt (pic, 16, 13,"^");
   }

void setJump(num)
    int num;
    {
    while (jumpSt[num] == 0)
      jumpSt[num]=1;
    }
