/* mz7120.h - Mizar mz7120 CPU board header file */

/*
modification history
--------------------
01b,29apr88,gae  added BUS and CPU constants.
01a,08jan88,miz	 written.
*/

/*
This file contains I/O address and related constants
for the Mizar mz7120.
*/

#ifndef	INCmz7170h
#define	INCmz7170h

#include "m68681.h"
#include "m68230.h"

#define TARGET_MZ_7120

#define BUS		VME_BUS
#define CPU		MC68020

/* memory constants */

#define MZ_RAM_BASE_ADRS	((char*) 0x00300000) /* 1st on-card RAM adrs */
#define MZ_RAM_END_ADRS		((char*) 0x003fffff) /* last on-card RAM adrs */

/* VME bus interrupt vectors. */

#define MZ_VEC_BASE		((unsigned long *) 0x00300000)

#define MZ_AVEC_1		25
#define MZ_AVEC_2		26
#define MZ_AVEC_3		27
#define MZ_AVEC_4		28	/* SP4		*/
#define MZ_AVEC_5		29	/* bus clear	*/
#define MZ_AVEC_6		30	/* clock	*/
#define MZ_AVEC_7		31	/* abort switch	*/


/* VME board control latch. */

#define MZ_BD_CONTROL_LATCH	((unsigned long *) 0x00100000)

#define MZ_BD_CONTROL_MASK	0x00000078
#define MZ_BD_BUS_SELECT	0x08
#define MZ_BD_TIMER_ENABLE	0x10
#define MZ_BD_LED1		0x20
#define MZ_BD_LED2		0x40

/* VME bus control latch. */

#define MZ_BUS_CONTROL_LATCH	((unsigned long *) 0x00180000)

#endif	INCmz7120h
