/* mv135/config.h - MVME-135 configuration header */

/*
modification history
--------------------
*/

/*
This module contains the parameters that define the configuration for
for the MVME-135 board.
*/

#ifndef INCconfigh
#define INCconfigh

#include "mv135.h"

#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */
#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/mv135/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"

/******************************************************************************/
/*                                                                            */
/*                  KERNEL SOFTWARE CONFIGURATION                             */
/*                                                                            */
/******************************************************************************/

#define FREE_RAM_ADRS		(&end)	/* start right after bss of UniWorks */	

#define MAX_TASKS		25	/* maximum # of tasks in system */

#define INT_LOCK_LEVEL  	7	/* interrupt disable mask */

#define MAX_SYS_SYMBOLS		3500	/* max symbols in sys symbol table */

#define ROOT_STACK_SIZE		5000	/* size of root's stack, in bytes */
#define SHELL_STACK_SIZE	10000	/* size of shell's stack, in bytes */

#define ISR_STACK_SIZE		1000	/* size of ISR stack, in bytes */

/* i/o system parameters */

#define NUM_DRIVERS		20	/* max 20 drivers in drvTable */
#define NUM_FILES		50	/* max 50 file open simultaneously */
#define NUM_RT_FILES		5	/* max 5 RT-11 files open */


/******************************************************************************/
/*                                                                            */
/*                  "GENERIC" SOFTWARE CONFIGURATION                          */
/*                                                                            */
/******************************************************************************/

/* included software facilities */

#define	INCLUDE_SHELL		/* command shell */
#define	INCLUDE_RLOGIN		/* remote login */
#define INCLUDE_TELNET		/* telnet-style remote login */
#define INCLUDE_RPC		/* rpc package */
#define INCLUDE_NFS		/* nfs package */
#define INCLUDE_FLOATING_POINT	/* floating point I/O */
#define INCLUDE_MC68881		/* MC68881/2 float point proc */
#define	INCLUDE_STDIO		/* standard I/O */
#define	INCLUDE_RT11		/* RT-11 file system */
#define	INCLUDE_RAMDRV		/* ram disk driver */
#define INCLUDE_DEBUG		/* native debugging */
#define	INCLUDE_TIMEX		/* timexLib for exec timing */
#define	INCLUDE_SPY		/* spyLib for task monitoring */
#define	INCLUDE_1.5COMPAT		/* 1.5 compatibility routines */
#define	INCLUDE_RAM		/* RAM pseudo-disk driver */
#define	INCLUDE_DBX		/* DBX debugger */

/* included hardware support */

#define INCLUDE_BP		/* include backplane net interface */
#define INCLUDE_ENP		/* include CMC Ethernet interface*/

/* excluded hardware support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define INCLUDE_EX		/* include Excelan Ethernet interface */
#define INCLUDE_PN		/* include Proteon network interface*/
#define INCLUDE_NW		/* include ISI Ethernet interface */
#define INCLUDE_VB		/* include isi backplane net interface*/
#define INCLUDE_HM		/* include isi backplane net interface*/
#define	INCLUDE_TS		/* TC50 half-inch tape driver */
#define	INCLUDE_SM		/* Interphase SMD controller */
#define INCLUDE_IE		/* include Sun Ethernet interface*/
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE

/* excluded facilities/support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/*#define INCLUDE_FORTRAN*/
#define INCLUDE_PASCAL		/* support for Pascal */
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE


/******************************************************************************/
/*                                                                            */
/*                   "GENERIC" BOARD CONFIGURATION                            */
/*                                                                            */
/******************************************************************************/

/* interrupt vectors */

#define VEC_BASE_ADRS		((char *) LOCAL_MEM_LOCAL_ADRS)

#define INT_VEC_CONFIG_TBL	63	/* usrCftbl ptr */

#define TRAP_KERNEL		0	/* trap 0 - kernel trap */
#define TRAP_UNIWORKS		1	/* trap 1 - UniWorks trap */
#define TRAP_DEBUG		2	/* trap 2 - breakpoint trap */


/******************************************************************************/
/*                                                                            */
/*                   "MISCELLANEOUS" CONSTANTS                                */
/*                                                                            */
/******************************************************************************/


/* Messages from exceptions during exceptions go at the following address */

#define EXC_MSG_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x800))

/* The bootroms put the boot line at the following address */

#define BOOT_LINE_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x700))

/* Default NFS parameters */

#define NFS_USER_ID	2001
#define NFS_GROUP_ID	100


/* backplane network parameters */

#define BP_OFF_BOARD    TRUE

#if     BP_OFF_BOARD
#define BP_ANCHOR_ADRS  ((char *) (0x00800000)) /* off-board bp anchor adrs */
#else
#define BP_ANCHOR_ADRS  ((char *) (0x00000600)) /* on-board bp anchor adrs */
#endif  BP_OFF_BOARD

#define BP_INT_TYPE	BP_INT_MAILBOX_1 	/* mailbox interrupt */
#define BP_INT_ARG1	VME_AM_SUP_SHORT_IO	/* bus address space */
#define BP_INT_ARG2	MPCSR_SIGHP(MPCSR_BUS_ADRS) /* bus adrs */
#define BP_INT_ARG3	((char) 0x80)		/* value */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */
 
#if     BP_OFF_BOARD
#define BP_MEM_ADRS     BP_ANCHOR_ADRS  /* off-board shared mem adrs */
#define BP_MEM_SIZE     0x80000         /* 512k */
#else
#define BP_MEM_ADRS     NONE            /* NONE = allocate sh. mem from pool */
#define BP_MEM_SIZE     0x10000         /* 64k */
#endif  BP_OFF_BOARD


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * the MVME-135 local memory address always appears at 0xffe00000 locally;
 * it will also appear at 0 locally if the right bit in CNT5_OPT0 is set.
 * We set that bit in romInit.s and use memory locally at 0.
 * RAM address on the bus is set by dip switches on the front panel.
 */

#define LOCAL_MEM_LOCAL_ADRS	0x0	   /* fixed */
#define LOCAL_MEM_BUS_ADRS  	sysBusAdrs /* initialized in sysHwInit */

/* Base address of the on-board ROM */

#define ROM_BASE_ADRS		0xfff00000

#endif	configh
