/* mv133.h - MVME-133, MVME-133A, MVME-133XT & MVME-134 header file */

/*
modification history
--------------------
01f,26jun88,gae  added SCC stuff.
01e,11feb88,gae  added MV133XT & MV134 constants.
		 moved MFP definition to m68901.h.
01d,09dec87,jcf  changed MFP_ADRS for mv133a compatibility.
		 added define for rtc of mv133a.
01c,22nov87,dnw  removed unused RAM_BASE_ADRS definition.
01b,29sep87,jcf	 added real time clock defines, and MV133_RAM_BASE_ADRS
01a,06aug87,jcf	 written by modifying the dy4 version 01a.
*/

/*
This file contains IO address and related constants
for the MV133, MV133A, MV133XT and the MV134.
*/

#ifndef	INCmv133
#define	INCmv133

#include "m68901.h"

#define TARGET_MV133

#define BUS		VME_BUS
#define CPU		MC68020

/* TARGETS */

#define	MV133		1
#define	MV133A		2
#define	MV133XT		3
#define	MV134		4

/* interrupt vector locations */

#define MFP_INT_VECT_NUM	0x40		/* MFP int. vector base num */

/* addresses */

/* Motorola MC68901 MFP (Multi-Function Peripheral) */

#define MV133_MFP_BASE_ADR	((char *) 0x00f80000)
#define MV133A_MFP_BASE_ADR	((char *) 0xfff80000)
#define MV133XT_MFP_BASE_ADR	MV133A_MFP_BASE_ADR
#define MV134_MFP_BASE_ADR	MV133A_MFP_BASE_ADR

 /* National Semiconductor MM58274 RTC (Real Time Clock) [MV133 & MV133A] */

#define MV133_RTC_BASE_ADR		((char *) 0x00fb0000)
#define MV133A_RTC_BASE_ADR		((char *) 0xfffb0000)

/* Mostek MK48T02 RTC (Real Time Clock) [MV133XT & MV134] */

#define MV133XT_RTC_BASE_ADR		((char *) 0xfffc0000)
#define MV134_RTC_BASE_ADR		MV133XT_RTC_BASE_ADR


#define PUPMMU_ADR	((char *) 0xfffd0000) /* MV134 MMU bus err/reset flag */

/* bit values for Module Status Register (MSR) */

#define	MSR_ACFAIL	(1<<15)	/* VMEbus ACFAIL* low then 1, high then 0 */
#define MSR_SYSCON	(1<<14)	/* VMEbus system controller then 1 */
#define MSR_PWRUP	(1<<13)	/* 0 on power-up, 1 on rtc access */
#define MSR_SRBIT4	(1<<12)	/* 0 when J15 pins 9-10 are connected */
#define MSR_SRBIT3	(1<<11)	/* 0 when J15 pins 7-8 are connected */
#define MSR_SRBIT2	(1<<10)	/* 0 when J15 pins 5-6 are connected */
#define MSR_SRBIT1	(1<<9)	/* 0 when J15 pins 3-4 are connected */
#define MSR_SRBIT0	(1<<8)	/* 0 when J15 pins 1-2 are connected */

/* Zilog Z8530 SCC (Serial Communications Controller) */

#define	N_SIO_CHANNELS	2	/* on P2 bus: Port A RS-485 Port B RS-232C */

#define SCC_INT_VECT_NUM	0x52	/* SCC interrupt vector base number */

#define	SCC_BASE_ADR	(0xfffa0000)
#define SCCB		((char *)(SCC_BASE_ADR+0))	/* B */
#define SCCB_D		((char *)(SCC_BASE_ADR+1))	/* B data */
#define SCCA		((char *)(SCC_BASE_ADR+2))	/* A */
#define SCCA_D		((char *)(SCC_BASE_ADR+3))	/* A data */

/* register addresses for the real time clock;
 * RTC_BASE_ADR determined at run time. */

/* The MV133 & MV133A use a National Semiconductor MM58274 */
#define RTC_CONTROL(base) ((char *) (base+0x0))	/* control port; pwrup bit */
#define RTC_TENTHS(base)  ((char *) (base+0x1))	/* tenths of secs */
#define RTC_SECS(base)    ((char *) (base+0x2))	/* seconds */
#define RTC_TENS_S(base)  ((char *) (base+0x3))	/* tens of seconds */
#define RTC_MINS(base)    ((char *) (base+0x4))	/* minutes */
#define RTC_MINS_T(base)  ((char *) (base+0x5))	/* tens of minutes */
#define RTC_HOURS(base)   ((char *) (base+0x6))	/* hours */
#define RTC_HOURS_T(base) ((char *) (base+0x7))	/* tens of hours */
#define RTC_DAYS(base)    ((char *) (base+0x8))	/* days */
#define RTC_DAYS_T(base)  ((char *) (base+0x9))	/* tens of days */
#define RTC_MON(base)     ((char *) (base+0xa))	/* months */
#define RTC_MON_T(base)   ((char *) (base+0xb))	/* tens of months */
#define RTC_YEAR(base)    ((char *) (base+0xc))	/* years */
#define RTC_YEAR_T(base)  ((char *) (base+0xd))	/* tens of years */
#define RTC_DAY(base)     ((char *) (base+0xe))	/* day of week */
#define RTC_SET_INT(base) ((char *) (base+0xf))	/* clock setting/inter reg */

/* The MV133XT & MV134 use a Mostek MT48TO2 */
#define	RTC_RAM(base)	((char *) base)		/* start of SRAM */
#define	RTC_RAM_SIZE	2040			/* 2040 bytes of SRAM */
#define	RTC_DATE(base)	((char *) base+2040)	/* 8 bytes of BCD-coded date */

#endif	INCmv133
