/* pic_cpu.c - Matrix MS-CPU100 jumpering */

static char *copyright = "Copyright 1988, Wind River Systems, Inc.";

/*
modification history
--------------------
01a,21sep88,gae  written.
*/

/*
This module contains the jumpering of the Matrix MS-CPU100.
It is only used by jump (4).

SEE ALSO: jump (4)
*/

#include "UniWorks.h"
#include "config.h"
#include "picture.h"


/*******************************************************************************
*
* drawBoard - draw cpu jumper config
*
* ARGSUSED1
*/

VOID drawBoard (pic, interactive)
    char *pic;
    BOOL interactive;

    {
    int ix;

    /* chop-off P2 bus ...*/

    for (ix = 0; ix <= 22; ix++)
      printAt (pic, 34, ix, "                                            ");

    for (ix = 3; ix <= 22; ix++)
	printAt (pic, 34, ix, "|");

    printAt (pic, 33, 1, "MS-CPU100");

    /* SYSCON */
    printAt (pic, 3, 2, "-  J4");
    printAt (pic, 3, 3, "-  SYSCON");
    printAt (pic, 20, 3, "SYSCON J6 X");

    printAt (pic, 15,  7, " -------  ------- ");
    printAt (pic, 15,  8, "|  ROM  ||  ROM  |");
    printAt (pic, 15,  9, "|       ||       |");
    printAt (pic, 15, 10, "|  U22  ||  U23  |");
    printAt (pic, 15, 11, "|       ||       |");
    printAt (pic, 15, 12, "|  ODD  ||  EVEN |");
    printAt (pic, 15, 13, " ---^---  ---^--- ");

    /* EPROM size */
    printAt (pic, 30, 17, "XX");
    printAt (pic, 30, 18, ".X");
    printAt (pic, 30, 19, "X.");
    printAt (pic, 19, 20, "EPROM SIZE J2");
    }
