/* ms100.h - Matrix MS-CPU100 CPU board header file */

/*
modification history
--------------------
01a,05sep88,dmp     written.
*/

/*
This file contains I/O address and related constants
for the Matrix MS-CPU100.
*/

#ifndef    INCms100h
#define    INCms100h

#include "m68681.h"
#include "ms100db.h"

#define TARGET_MS_100

#define BUS        VME_BUS
#define CPU        MC68000

/* memory constants */

#define MS_RAM_BASE_ADRS       ((char*) 0x00000000) /* 1st on-card RAM adrs */
#define MS_RAM_END_ADRS        ((char*) 0x000fffff) /* last on-card RAM adrs */

/* VME bus interrupt vectors. */
/* the vector base is for the 68010/68020 only */

#define MS_VEC_BASE             ((unsigned long *) 0x00000000)

#define MS_AVEC_1        25
#define MS_AVEC_2        26
#define MS_AVEC_3        27
#define MS_AVEC_4        28
#define MS_AVEC_5        29    
#define MS_AVEC_6        30    /* duart,time-of-day and bcsr     */
#define MS_AVEC_7        31    /* abort switch    */


/* duart auxiliary control register interrupt mask initial setting */

#define DUART_ACR_RECSF        DELTA_IP3_INT   /* enable receive vme sysfail */
#define DUART_ACR_MBOX         DELTA_IP0_INT   /* enable mailbox interrupt   */
#define DUART_OPR_MBOX         TXCA_16X	       /* enable mailbox             */
					       /* change-of-state interrupt  */

#endif    INCms100h
