/* frc21.h - Force SYS68K/CPU-21/29/32 CPU board header file */

/*
modification history
--------------------
02b,01aug88,gae  added frc32 stuff.
02a,11jul88,gae  updated with tja's merged frc21/9 port.
01d,29jun88,gae  added include of m68230.h.
01c,29apr88,gae  added BUS and CPU constants.
01b,22feb88,dnw  removed MPCC and PIT defines to their own header files.
01a,28may87,tja  written
*/

/*
This file contains I/O address and related constants for
VxWorks on the Force SYS68K/CPU-21, SYS68K/CPU-29 and SYS68K/CPU-32.
*/

#ifndef	INCfrc21h
#define	INCfrc21h

#include "m68230.h"
#include "m68153.h"

#define	TARGET_FRC_21

#define BUS		VME_BUS
#define CPU		MC68020

/* Force CPU Models */

#define	FRC_CPU_21	1
#define	FRC_CPU_29	2
#define	FRC_CPU_32	3

/*
Interrupt vectors.  Two Bus Interruptor Module (BIM) chips controls 
on-board interrupts. The local interrupt assignment is organized 
as follows:

    interrupt       BIM     
    source          channel
    -----------------------
    ABORT switch    INT0   
    MPCC 1          INT1   
    PI/T Timer      INT2   
    -----------------------
    SYSFAIL         INT3   
    IRQVMX          INT3   
    ACFAIL          INT3   
    MPCC 2/3        INT3   
    -----------------------

    interrupt       BIM 1		BIM 2    
    source          channel		channel
    -------------------------------------------
    ABORT switch    INT0
    MPCC 1          INT1
    PI/T 1 Timer    INT2   
    PI/T 1 Port     INT3   

CPU-29 (& 32) only:
    RTC					INT0
    MPCC 2 (optional)			INT1
    PI/T 2 Timer			INT2	
    PI/T 2 Port				INT3


All local interrupts are routed through the BIMs to program the
IRQ level and the IRQ vector and have higher priority than a
VMEBus interrupt of equal interrupt level.
*/

/* interrupt vectors */

#define INT_VEC_ABORT		64	/* ABORT */
#define INT_VEC_CO_MPCC		65	/* console MPCC */
#define INT_VEC_PIT1_TIMER	66	/* PI/T 1 TIMER */
#define INT_VEC_PIT1_PORT	67	/* PI/T 1 PORT */

/* CPU-29 only */

#define INT_VEC_RTC		68	/* Real Time Clock */
#define INT_VEC_PIT2_TIMER	69	/* PI/T 2 TIMER */
#define INT_VEC_PIT2_PORT	70	/* PI/T 2 PORT */

/* interrupt levels */

#define INT_LVL_ABORT		7                       
#define INT_LVL_PIT1_TIMER	6
#define INT_LVL_PIT1_PORT	4
#define INT_LVL_CO_MPCC		4
#define INT_LVL_RTC		5
#define INT_LVL_PIT2_TIMER	2
#define INT_LVL_PIT2_PORT	2


#define TY_XTAL_FREQ		8064000		/* freq of MPCC clock input */
#define CLOCK_FREQ		8064000 	/* freq of PI/T clock input */

#define N_MPCCS			2		/* no. of MPCC channels */

/* The base address for all on-board I/O devices is fixed */

#define IO_BASE		((char *) 0xff800000)

#define PIT_BASE_1	(IO_BASE + 0xc00)	/* parallel if/timer chip 1 */
#define PIT_BASE_2	(IO_BASE + 0xe00)	/* parallel if/timer chip 2 */

#define MPCC_BASE_1	(IO_BASE)		/* console serial port */
#define MPCC_BASE_2	(IO_BASE + 0x0200)	/* 2nd serial port */
#define MPCC_BASE_3	(IO_BASE + 0x0600)	/* optional 3rd serial port */

/* port addresses for BIM */
#define BIM_BASE_1	(IO_BASE + 0x800)	/* BIM chip 1 */
#define BIM_BASE_2	(IO_BASE + 0xa00)	/* BIM chip 2 */

#define RTC_BASE	(IO_BASE + 0X1000)	/* real-time clock */

/* RTC 62421 register addresses */

#define RTC_1_SEC	(IO_BASE + 0x1000)	/* 1 sec. digit */
#define RTC_10_SEC	(IO_BASE + 0x1001)	/* 10 sec. digit */
#define RTC_1_MIN	(IO_BASE + 0x1002)	/* 1 min. digit */
#define RTC_10_MIN 	(IO_BASE + 0x1003)	/* 10 min. digit */
#define RTC_1_HR	(IO_BASE + 0x1004)	/* 1 hour digit */
#define RTC_10_HR	(IO_BASE + 0x1005) 	/* pm/am + 10 hour digit */
#define RTC_1_DAY	(IO_BASE + 0x1006) 	/* 1 day digit */
#define RTC_10_DAY	(IO_BASE + 0x1007)	/* 10 day digit */
#define RTC_1_MON	(IO_BASE + 0x1008)	/* 1 month digit */
#define RTC_10_MON	(IO_BASE + 0x1009)	/* 10 month digit */
#define RTC_1_YR	(IO_BASE + 0x100a)	/* 1 year digit */
#define RTC_10_YR	(IO_BASE + 0x100b)	/* 10 year digit */
#define RTC_WEEK	(IO_BASE + 0x100c)	/* week */
#define RTC_CTR_D	(IO_BASE + 0x100d)	/* control d */
#define RTC_CTR_E	(IO_BASE + 0x100e)	/* control e */
#define RTC_CTR_F	(IO_BASE + 0x100f)	/* control f */

#endif	INCfrc21h
