/* svc_simple.c - simplified front end to rpc */

static char *copyright = "Copyright 1987, Wind River Systems, Inc.";

/*
 * Copyright (c) 1987 Wind River Systems, Inc.
 * Copyright (C) 1984, Sun Microsystems, Inc. 
 *
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/*
modification history
--------------------
*/

#ifndef lint
static char sccsid[] = "@(#)svc_simple.c 1.1 86/02/03 Copyr 1984 Sun Micro";
#endif

/* 
 * svc_simple.c
 * Simplified front end to rpc.
 *
 */

#include "rpc.h"
#include "socket.h"
#include "utime.h"
#undef TRUE
#undef FALSE
#include "rpcGbl.h"
#include "UniWorks.h"

int universal();

struct moduleStatics
    {
    struct proglst 
	{
	char *(*p_progname)();
	int  p_prognum;
	int  p_procnum;
	xdrproc_t p_inproc, p_outproc;
	struct proglst *p_nxt;
	} *proglst;
    SVCXPRT *transp;
    int madetransp;
    struct proglst *pl;
    };

STATUS svc_simpleInit (myModuleList)
    FAST MODULE_LIST *myModuleList;
    {

    /* allocate the module statics */

    myModuleList->svc_simple = 
	 (struct moduleStatics *) malloc (sizeof (struct moduleStatics)); 

    if (myModuleList->svc_simple == NULL)
	{
	printErr ("svc_simpleInit: out of Memory! \n");
	return (ERROR);
	}

    bzero (myModuleList->svc_simple, sizeof (struct moduleStatics)); 
    return (OK);
    }

registerrpc(prognum, versnum, procnum, progname, inproc, outproc)
	char *(*progname)();
	xdrproc_t inproc, outproc;
{
	FAST struct moduleStatics *ms = taskModuleList->svc_simple;
	
	if (procnum == NULLPROC) {
		printErr ("can't reassign procedure number %d\n", NULLPROC);
		return (-1);
	}
	if (!ms->madetransp) {
		ms->madetransp = 1;
		ms->transp = svcudp_create(RPC_ANYSOCK);
		if (ms->transp == NULL) {
			printErr ("couldn't create an rpc server\n");
			return (-1);
		}
	}
	pmap_unset(prognum, versnum);
	if (!svc_register(ms->transp, prognum, versnum, universal, IPPROTO_UDP)) {
	    	printErr ("couldn't register prog %d vers %d\n",
			  prognum, versnum);
		return (-1);
	}
	ms->pl = (struct proglst *)malloc(sizeof(struct proglst));
	if (ms->pl == NULL) {
		printErr ("registerrpc: out of memory\n");
		return (-1);
	}
	ms->pl->p_progname = progname;
	ms->pl->p_prognum = prognum;
	ms->pl->p_procnum = procnum;
	ms->pl->p_inproc = inproc;
	ms->pl->p_outproc = outproc;
	ms->pl->p_nxt = ms->proglst;
	ms->proglst = ms->pl;
	return (0);
}


universal(rqstp, transp)
	struct svc_req *rqstp;
	SVCXPRT *transp;
{
	int prog, proc;
	char *outdata;
	/* XXX char xdrbuf[UDPMSGSIZE]; */
	char *xdrbuf = (char *) malloc (UDPMSGSIZE);
	struct proglst *pl;
	FAST struct moduleStatics *ms = taskModuleList->svc_simple;

	if (xdrbuf == NULL)
	    {
	    panic ("rpc: universal: out of memory\n");
	    return;
	    }

	/* 
	 * enforce "procnum 0 is echo" convention
	 */
	if (rqstp->rq_proc == NULLPROC) {
		if (svc_sendreply(transp, xdr_void, 0) == FALSE) {
			printErr ("xxx\n");
			free (xdrbuf);
			exit(1);
		}
		free (xdrbuf);
		return;
	}
	prog = rqstp->rq_prog;
	proc = rqstp->rq_proc;
	for (pl = ms->proglst; pl != NULL; pl = pl->p_nxt)
		if (pl->p_prognum == prog && pl->p_procnum == proc) {
			/* decode arguments into a CLEAN buffer */
			/*XXX bzero(xdrbuf, sizeof(xdrbuf)); /* required ! */
			bzero(xdrbuf, UDPMSGSIZE); /* required ! */
			if (!svc_getargs(transp, pl->p_inproc, xdrbuf)) {
				svcerr_decode(transp);
				free (xdrbuf);
				return;
			}
			outdata = (*(pl->p_progname))(xdrbuf);
			if (outdata == NULL && pl->p_outproc != xdr_void)
				{
				/* there was an error */
				free (xdrbuf);
				return;
				}
			if (!svc_sendreply(transp, pl->p_outproc, outdata)) {
				printErr ("trouble replying to prog %d\n",
				    pl->p_prognum);
				free (xdrbuf);
				exit(1);
			/* free the decoded arguments */
			(void)svc_freeargs(transp, pl->p_inproc, xdrbuf);
			}
			free (xdrbuf);
			return;
		}
	printErr ("never registered prog %d\n", prog);
	free (xdrbuf);
	exit(1);
}

