
	.data
	.asciz	"Copyright 1988, Integrated Solutions, Inc."

/*
modification history
--------------------
*
*/

/*
DESCRIPTION

This library contains routines which duplicate the BSD string
processing package.  The functions operate on null-terminated strings.
They do not check for overflow of any resulting string.

SEE ALSO: Unix strings (3) documentation
*/

#define ASMLANGUAGE
#include "UniWorks.h"
#include "asm.h"

	.globl	_index
	.globl	_rindex
	.globl	_strcat
	.globl	_strncat
	.globl	_strcmp
	.globl	_strncmp
	.globl	_strlen
	.globl	_strcpy
	.globl	_strncpy

	.text
	.even

/**************************************************************************
*
* index - find a character in a string
* 
* RETURNS: the ptr in s at which the character c appears;
* 	NULL if not found.
 
* char *index (s, c)
*     FAST char *s;
*     FAST char c;

* {
*         do {
*                 if (*s == c)
*                         return(s);
*         } while (*s++);
*         return(NULL);
* }
*/

_index:
	link	a6,#0

	movl	a6@(8),a0	/* s */
	movb	a6@(15),d1	/* c */
	jne	2f

	movq	#-1,d0		/* special case: c == 0 */
    1:	tstb	a0@+
	dbeq	d0,1b
	jne	1b
	jra	3f		/* found a null -- return pointer to it */

    2:	movb	a0@+,d0		/* normal case: c != 0 */
	jeq	4f		/* found a null terminator -- failure */
	cmpb	d0,d1
	jne	2b
    3:	subql	#1,a0		/* back up, cause we overshot */
	movl	a0,d0
	unlk	a6
	rts
    4:	movq	#0,d0		/* not found -- return NULL */
	unlk	a6
	rts

/****************************************************************************
*
* rindex - find the last occurrence of a character in a string
*
* RETURNS:
*	Address of the last occurrence of character c in string s, or
*	NULL if not found.
  
*     char *rindex (sp, c)
*     FAST char *sp;
*     FAST char c;

* {
*         register char *r;
* 
*         r = NULL;
*         do {
*                 if (*sp == c)
*                         r = sp;
*         } while (*sp++);
*         return(r);
* }
*/

_rindex:
	link	a6,#0
	movq	#1,d0
	movl	d0,a1		/* NULL + 1 */
	movl	a6@(8),a0	/* sp */
	movb	a6@(15),d1	/* c */
	jne	3f

	movq	#-1,d0		/* special case: c == 0 */
    1:	tstb	a0@+
	dbeq	d0,1b
	jne	1b		/* wow, still more */

	subql	#1,a0		/* back up, cause we overshot */
	movl	a0,d0
	unlk	a6
	rts

    2:	cmpb	d0,d1		/* normal case: c != 0 */
	jne	3f
	movl	a0,a1		/* found it -- save ptr to just past it in a1 */
    3:	movb	a0@+,d0		/* entry point for normal case loop */
	jne	2b

	subql	#1,a1		/* back up, cause we overshot */
	movl	a1,d0
	unlk	a6
	rts

/****************************************************************************
*
* strlen - string length routine
*
* RETURNS: number of non-NULL bytes in string argument.
*

*     int strlen (s)
*     FAST char *s;

* {
*         register n;
* 
*         n = 0;
*         while (*s++)
*                 n++;
*         return(n);
* }
*/

_strlen:
	link	a6,#0
	movl	a6@(ARG1),a0	/* string */
	movq	#-1,d0		/* initialize counter: neg of (count+1) */
	jra	2f		/* enter loop */
    1:	addqw	#1,d0		/* propogate borrow thru all 32 bits */
	subql	#1,d0
    2:	tstb	a0@+		/* entry point of loop */
	dbeq	d0,2b
	jne	1b		/* wow, still more */
	notl	d0		/* negate & decrement counter */
	unlk	a6
	rts

/****************************************************************************
*
* strcpy - copy string s1 to s0. s0 must be large enough.
*
* RETURNS: s0.
*

*     char *strcpy (s0, s1)
*     FAST char *s0;
*     FAST char *s1;

* {
*         register char *os0;
* 
*         os0 = s0;
*         while (*s0++ = *s1++)
*                 ;
*         return(os0);
* }
*/

_strcpy:
	link	a6,#0
	movl	a6@(ARG1),a0	/* s0: dest */
	movl	a6@(ARG2),a1	/* s1: source */
	movl	a0,d0		/* set return value before we lose it */
	movq	#-1,d1		/* dummy counter for dbcc */
    1:	movb	a1@+,a0@+	/* copy the string */
	dbeq	d1,1b
	jne	1b		/* wow, still more */
	unlk	a6
	rts

/****************************************************************************
*
* strncpy - copy n characters from one string to another
*
* Copy s1 to s0, truncating or null-padding to always copy n bytes.
*
* RETURNS: s0.
*

*     char *strncpy (s0, s1, n)
*     FAST char *s0;
*     FAST char *s1;
*     FAST int n;

* {
*         register i;
*         register char *os0;
* 
*         os0 = s0;
*         for (i = 0; i < n; i++)
*                 if ((*s0++ = *s1++) == '\0') {
*                         while (++i < n)
*                                 *s0++ = '\0';
*                         return(os0);
*                 }
*         return(os0);
* }
*/

_strncpy:
	link	a6,#0
	movl	a6@(ARG1),a0	/* s0: dest */
	movl	a0,d0		/* return value */
	movl	a6@(ARG2),a1	/* s1: source */
	movl	a6@(ARG3),d1	/* n */
	jgt	2f
	unlk	a6
	rts			/* nonpositive count -- all done */
    1:	movb	a1@+,a0@+	/* COPY LOOP */
    2:	dbeq	d1,1b		/* entry point of copy loop */
	jeq	3f
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jge	1b
	unlk	a6
	rts			/* count exhausted -- return */
    3:	movl	d0,a1		/* save return value */
	movq	#0,d0		/* fill value: zero */
	jbr	5f
    4:	movb	d0,a0@+		/* CLEAR LOOP */
    5:	dbf	d1,4b		/* entry point of clear loop */
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jge	4b
	movl	a1,d0		/* restore return value */
	unlk	a6
	rts

/****************************************************************************
*
* strcat - concatenate one string to another
*
* Appends a copy of string s1 to end of string s0.
* Resulting string s0 is null terminated.
*
* RETURNS: pointer to s0
*

*     char *strcat (s0, s1)
*     FAST char *s0;
*     FAST char *s1;

* {
*         register char *os0;
* 
*         os0 = s0;
*         while (*s0++)
*                 ;
*         --s0;
*         while (*s0++ = *s1++)
*                 ;
*         return(os0);
* }
*/

_strcat:
	link	a6,#0
	movl	a6@(ARG1),a0	/* s0: dest */
	movl	a6@(ARG2),a1	/* s1: source */
	movl	a0,d0		/* set return value before we lose it */
	movq	#-1,d1		/* dummy counter for dbcc */

    1:	tstb	a0@+		/* scan for terminating null */
	dbeq	d1,1b
	jne	1b		/* wow, still more */
	subql	#1,a0		/* back up to point at terminating null */

    2:	movb	a1@+,a0@+	/* copy string, including terminating null */
	dbeq	d1,2b
	jne	2b		/* wow, still more */
	unlk	a6
	rts

/****************************************************************************
*
* strncat - concatenate n characters from one string to another
*
* Appends, at most, n characters from string s1 to end of string s0.
*
* RETURNS: Pointer to null-terminated s0.
*

*     char *strncat (s0, s1, n)
*     FAST char *s0;
*     FAST char *s1;
*     register int n;

* {
*         register char *os0;
* 
*         os0 = s0;
*         while (*s0++)
*                 ;
*         --s0;
*         while (*s0++ = *s1++)
*                 if (--n < 0) {
*                         *--s0 = '\0';
*                         break;
*                 }
*         return(os0);
* }
*/

_strncat:
	link	a6,#0
	movl	a6@(ARG1),a0	/* s0: dest */
	movl	a6@(ARG2),a1	/* s1: source */
	movl	a0,d0		/* set return value before we lose it */
	movq	#-1,d1		/* dummy counter for dbcc */

    1:	tstb	a0@+		/* scan to terminating null */
	dbeq	d1,1b
	jne	1b		/* wow, still more */

	subql	#1,a0		/* back up to point at terminating null */
	movl	a6@(ARG3),d1	/* count */

	movb	a1@+,a0@+	/* special case: first time (strict compat) */
	jeq	4f
	subql	#1,d1
	jlt	3f		/* initial check for 32-bit negative count */

    2:	movb	a1@+,a0@+	/* copy the string */
	dbeq	d1,2b
	jeq	4f		/* if end of string, we're all done */
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jge	2b
    3:	movb	#0,a0@-		/* count exhausted -- force null terminator */
    4:	unlk	a6
    	rts

/****************************************************************************
*
* strcmp - compare strings
*
* Compare strings:  s0>s1: >0  s0==s1: 0  s0<s1: <0
*
* RETURNS:  An integer greater than, equal to, or less than 0
*

*     int strcmp (s0, s1)
*     FAST char *s0;
*     FAST char *s1;

* {
*         while (*s0 == *s1++)
*                 if (*s0++=='\0')
*                         return(0);
*         return(*s0 - *--s1);
* }
*/

_strcmp:
	link	a6,#0
	movl	a6@(ARG1),a0	/* s0 */
	movl	a6@(ARG2),a1	/* s1 */

1:	movb	a0@+,d0
	movb	a1@+,d1
	jeq	2f		/* if end of s1, ret val is last char from s0 */
	subb	d1,d0
	jeq	1b		/* if difference is nonzero, ret val is diff */
2:
	extw	d0
	extl	d0
	unlk	a6
	rts

/****************************************************************************
*
* strncmp - compares up to n characters from one string to another
*
* Compare strings (at most n bytes):  s0>s1: >0  s0==s1: 0  s0<s1: <0
* 
* RETURNS: Integer greater than, equal to, or less than 0.
*

*     int strncmp (s0, s1, len)
*     FAST char *s0;
*     FAST char *s1;
*     FAST int len;

* {
* 
*         while (--n >= 0 && *s0 == *s1++)
*                 if (*s0++ == '\0')
*                         return(0);
*         return(n<0 ? 0 : *s0 - *--s1);
* }
*/

_strncmp:
	link	a6,#0
	movl	d2,sp@-		/* save d2 */
	movl	a6@(ARG1),a0	/* s0 */
	movl	a6@(ARG2),a1	/* s1 */
	movl	a6@(ARG3),d2	/* n */

    1:	subql	#1,d2
	jlt	4f
	movb	a0@+,d0
	movb	a1@+,d1
	jeq	2f		/* if end of s1 ret val is last char from s0 */
	subb	d1,d0
	jeq	1b		/* if difference is nonzero ret val is diff */
    2:	extw	d0
	extl	d0
    3:	movl	sp@+,d2		/* restore d2 */
	unlk	a6
	rts
    4:	movq	#0,d0		/* count exhausted -- ret val is zero */
	jra	3b

