/* mathALib - C callable math routines for the MC68881/2 */

	.data
	.asciz	"Copyright 1987-1988, Wind River Systems, Inc."

/*
modification history 
--------------------
*/

/*
DESCRIPTION
This library provides a C interface to the high level math functions
on the MC68881/2 floating point coprocessor.  Each routine has the following
format:

 . save f7
 . calculate fp function using double parameter 
 . transfer result to parameter storage
 . store result to d0, d1 reg.'s
 . restore old f7

WARNING
This library only works if there is a MC68881/2 coprocessor in the system!
Attempts to use these routines with no coprocessor present will result
in illegal instruction traps.

SEE ALSO: fppLib (1)
*/

#define ASMLANGUAGE
#include "UniWorks.h"
#include "asm.h"
#define	MATH_ASM


        .text
	.even
	.globl  _mathInit
        .globl  _tanh
        .globl  _cosh
        .globl  _sinh
        .globl  _log2
        .globl  _log10
        .globl  _log
        .globl  _exp
        .globl  _atan
        .globl  _acos
        .globl  _asin
        .globl  _tan
        .globl  _cos
        .globl  _sin
        .globl  _sqrt
        .globl  _fabs

/*******************************************************************************
*
* mathInit - initialize floating point math package
*
* This null routine is provided so the linker will pull in the math library.
*
* WARNING
* This library only works if there is a MC68881/2 coprocessor in the system!

* VOID mathInit ()

*/

_mathInit:
	rts

/*******************************************************************************
*
* acos - floating point arc-cosine
*

* double acos (dblParam)
*     double dblParam;

*/

_acos:
	link    a6,#0

#ifdef	MATH_ASM
	fmoved	f7,sp@-
	facosd	a6@(ARG1),f7
	fmoved	f7,a6@(ARG1)
	movl    a6@(ARG1),d0
	movl    a6@(4),d1
	fmoved	sp@,f7
#endif	MATH_ASM
	.word	0xf227,0x7780
	.word	0xf22e,0x579c,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x0004
	.word	0xf217,0x5780

	addqw   #8,sp
	unlk    a6
	rts

/*******************************************************************************
*
* asin - floating point arcsine
*

* double asin (dblParam)
*     double dblParam;

*/
_asin:
	link    a6,#0

#ifdef	MATH_ASM
	fmoved  f7,sp@-
	fasind  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movl    a6@(ARG1),d0
	movl    a6@(4),d1
	fmoved  sp@,f7
#endif	MATH_ASM
	.word	0xf227,0x7780
	.word	0xf22e,0x578c,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x0004
	.word	0xf217,0x5780

	addqw   #8,sp
	unlk    a6
	rts

/*******************************************************************************
*
* atan - floating point arctangent
*

* double atan (dblParam)
*     double dblParam;

*/
_atan:
	link    a6,#0

#ifdef	MATH_ASM
	fmoved  f7,sp@-
	fatand  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movl    a6@(ARG1),d0
	movl    a6@(4),d1
	fmoved  sp@,f7
#endif	MATH_ASM
	.word	0xf227,0x7780
	.word	0xf22e,0x578a,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x0004
	.word	0xf217,0x5780

	addqw   #8,sp
	unlk    a6
	rts

/*******************************************************************************
*
* cos - floating point cosine
*

* double cos (dblParam)
*     double dblParam;

*/
_cos:
	link    a6,#0

#ifdef	MATH_ASM
	fmoved  f7,sp@-
	fcosd   a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movl    a6@(ARG1),d0
	movl    a6@(4),d1
	fmoved  sp@,f7
#endif	MATH_ASM
	.word	0xf227,0x7780
	.word	0xf22e,0x579d,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x0004
	.word	0xf217,0x5780

	addqw   #8,sp
	unlk    a6
	rts

/*******************************************************************************
*
* cosh - floating point hyperbolic cosine
*

* double cosh (dblParam)
*     double dblParam;

*/
_cosh:
	link    a6,#0

#ifdef	MATH_ASM
	fmoved  f7,sp@-
	fcoshd  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movl    a6@(ARG1),d0
	movl    a6@(4),d1
	fmoved  sp@,f7
#endif	MATH_ASM
	.word	0xf227,0x7780
	.word	0xf22e,0x5799,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x0004
	.word	0xf217,0x5780

	addqw   #8,sp
	unlk    a6
	rts

/*******************************************************************************
*
* exp - floating point inverse natural logarithm (e ** (x))
*

* double exp (dblParam)
*     double dblParam;

*/
_exp:
	link    a6,#0

#ifdef	MATH_ASM
	fmoved  f7,sp@-
	fetoxd  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movl    a6@(ARG1),d0
	movl    a6@(4),d1
	fmoved  sp@,f7
#endif	MATH_ASM
	.word	0xf227,0x7780
	.word	0xf22e,0x5790,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x0004
	.word	0xf217,0x5780

	addqw   #8,sp
	unlk    a6
	rts

/*******************************************************************************
*
* fabs - floating point absolute value
*

* double fabs (dblParam)
*     double dblParam;

*/

_fabs: 
	link    a6,#0

#ifdef	MATH_ASM
	fmoved  f7,sp@-
	fabsd   a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movl    a6@(ARG1),d0
	movl    a6@(4),d1
	fmoved  sp@,f7
#endif	MATH_ASM
	.word	0xf227,0x7780
	.word	0xf22e,0x5798,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x0004
	.word	0xf217,0x5780

	addqw   #8,sp
	unlk    a6
	rts

/*******************************************************************************
*
* log - floating point natural logarithm 
*

* double log (dblParam)
*     double dblParam;

*/
_log:
	link    a6,#0

#ifdef	MATH_ASM
	fmoved  f7,sp@-
	flognd  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movl    a6@(ARG1),d0
	movl    a6@(4),d1
	fmoved  sp@,f7
#endif	MATH_ASM
	.word	0xf227,0x7780
	.word	0xf22e,0x5794,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x0004
	.word	0xf217,0x5780

	addqw   #8,sp
	unlk    a6
	rts

/*******************************************************************************
*
* log10 - floating point logarithm base 10 
*

* double log10 (dblParam)
*     double dblParam;

*/
_log10:
	link    a6,#0

#ifdef	MATH_ASM
	fmoved  f7,sp@-
	flog10d a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movl    a6@(ARG1),d0
	movl    a6@(4),d1
	fmoved  sp@,f7
#endif	MATH_ASM
	.word	0xf227,0x7780
	.word	0xf22e,0x5795,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x0004
	.word	0xf217,0x5780

	addqw   #8,sp
	unlk    a6
	rts

/*******************************************************************************
*
* log2 - floating point logarithm base 2 
*

* double log2 (dblParam)
*     double dblParam;

*/
_log2:
	link    a6,#0

#ifdef	MATH_ASM
	fmoved  f7,sp@-
	flog2d  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movl    a6@(ARG1),d0
	movl    a6@(4),d1
	fmoved  sp@,f7
#endif	MATH_ASM
	.word	0xf227,0x7780
	.word	0xf22e,0x5796,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x0004
	.word	0xf217,0x5780

	addqw   #8,sp
	unlk    a6
	rts

/*******************************************************************************
*
* sin - floating point sine
*

* double sin (dblParam)
*     double dblParam;

*/
_sin:
	link    a6,#0

#ifdef	MATH_ASM
	fmoved  f7,sp@-
	fsind   a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movl    a6@(ARG1),d0
	movl    a6@(4),d1
	fmoved  sp@,f7
#endif	MATH_ASM
	.word	0xf227,0x7780
	.word	0xf22e,0x578e,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x0004
	.word	0xf217,0x5780

	addqw   #8,sp
	unlk    a6
	rts

/*******************************************************************************
*
* sinh - floating point hyperbolic sine
*

* double sinh (dblParam)
*     double dblParam;

*/
_sinh:
	link    a6,#0

#ifdef	MATH_ASM
	fmoved  f7,sp@-
	fsinhd  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movl    a6@(ARG1),d0
	movl    a6@(4),d1
	fmoved  sp@,f7
#endif	MATH_ASM
	.word	0xf227,0x7780
	.word	0xf22e,0x5782,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x0004
	.word	0xf217,0x5780

	addqw   #8,sp
	unlk    a6
	rts

/*******************************************************************************
*
* sqrt - floating point square root
*

* double sqrt (dblParam)
*     double dblParam;

*/

_sqrt:
	link    a6,#0

#ifdef	MATH_ASM
	fmoved  f7,sp@-
	fsqrtd  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movl    a6@(ARG1),d0
	movl    a6@(4),d1
	fmoved  sp@,f7
#endif	MATH_ASM
	.word	0xf227,0x7780
	.word	0xf22e,0x5784,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x0004
	.word	0xf217,0x5780

	addqw   #8,sp
	unlk    a6
	rts

/*******************************************************************************
*
* tan - floating point tangent
*

* double tan (dblParam)
*     double dblParam;

*/

_tan:
	link    a6,#0

#ifdef	MATH_ASM
	fmoved  f7,sp@-
	ftand   a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movl    a6@(ARG1),d0
	movl    a6@(4),d1
	fmoved  sp@,f7
#endif	MATH_ASM
	.word	0xf227,0x7780
	.word	0xf22e,0x578f,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x0004
	.word	0xf217,0x5780

	addqw   #8,sp
	unlk    a6
	rts

/*******************************************************************************
*
* tanh - floating point hyperbolic tangent
*

* double tanh (dblParam)
*     double dblParam;

*/

_tanh:
	link    a6,#0

#ifdef	MATH_ASM
	fmoved  f7,sp@-
	ftanhd  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movl    a6@(ARG1),d0
	movl    a6@(4),d1
	fmoved  sp@,f7
#endif	MATH_ASM
	.word	0xf227,0x7780
	.word	0xf22e,0x5789,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x0004
	.word	0xf217,0x5780

	addqw   #8,sp
	unlk    a6
	rts
