/* compatPLib.c - compatibility routines for the prim sources */

static char *copyright = "Copyright 1988, Integrated Solutions, Inc.";

/*
modification history
--------------------
*/

/*
DESCRIPTION
*/

#include "UniWorks.h"
#include "vrtx32.h"
#include "taskLib.h"
#include "memLib.h"

extern PARTITION memSysPartition;	/* system partition used by malloc... */

/*
 * DESCRIPTION The routines in this file are provided for compatibilty with
 * UniWorks 1.5. 
 */

compatPInit()
{
}

/*******************************************************************************
*
* cmpbuf - compare one buffer to another
*
* This routine compares the first nbytes characters of "buf1" to "buf2".
*
* RETURNS
*   0 if first nbytes of "buf1" and "buf2" are identical
*  -1 if buf1 < buf2
*   1 if buf1 > buf2
*/

int 
cmpbuf(buf1, buf2, nbytes)
	FAST char      *buf1;	/* pointer to destination buffer	 */
	FAST char      *buf2;	/* pointer to source buffer		 */
	FAST int        nbytes;	/* number of bytes to compare		 */

{
	while (--nbytes >= 0) {
		if (*buf1 < *buf2)
			return (-1);
		if (*buf1++ > *buf2++)
			return (1);
	}

	return (0);		/* equality */
}
/*******************************************************************************
*
* cpybuf - copy one buffer to another
*
* This routine calls bcopy.
*
* SEE ALSO: bcopy(2)
*
*/

VOID 
cpybuf(to_buf, from_buf, nbytes)
	char           *to_buf;	/* pointer to destination buffer */
	char           *from_buf;	/* pointer to source buffer */
	int             nbytes;	/* number of bytes to copy */
{
	bcopy(from_buf, to_buf, nbytes);
}
/*******************************************************************************
*
* filbuf - fill buffer with character
*
* This routine calls bfill.
*
* SEE ALSO: bfill(2)
*
*/
VOID 
filbuf(buf, nbytes, ch)
	FAST char      *buf;	/* pointer to buffer */
	FAST int        nbytes;	/* number of bytes to copy */
	FAST char       ch;	/* char with which to fill buffer */
{
	bfill(buf, nbytes, ch);
}
/*******************************************************************************
*
* fioSetIn - set current assignment of standard input fd (obsolete)
*
* This routine is obsolete, use ioGlobalStdSet (2).
*
*/
fioSetIn(fd)
	int             fd;
{
	ioGlobalStdSet(0, fd);
}
/*******************************************************************************
*
* fioSetOut - set current assignment of standard output fd (obsolete)
*
* This routine is obsolete, use ioGlobalStdSet (2).
*
*/
fioSetOut(fd)
	int             fd;
{
	ioGlobalStdSet(1, fd);
}
/*******************************************************************************
*
* fioSetErr - set current assignment of standard error fd (obsolete)
*
* This routine is obsolete, use ioGlobalStdSet (2).
*
*/
fioSetErr(fd)
	int             fd;
{
	ioGlobalStdSet(2, fd);
}
/*******************************************************************************
*
* fppPrintRegs - print contents of a task's floating-point registers
*/

VOID 
fppPrintRegs(pTcb)
	FAST VX_TCB    *pTcb;
{
	fppTaskRegsShow(pTcb->tcb_id);
}
/*******************************************************************************
*
* fppGetTaskRegs - get a task's floating-point registers from TCB
*/

STATUS 
fppGetTaskRegs(pTcb, fpregs, pFpcr, pFpsr, pFpiar)
	FAST VX_TCB    *pTcb;
	double          fpregs[];	/* floating-point registers 0 - 7	 */
int            *pFpcr;		/* control register			 */
int            *pFpsr;		/* status register			 */
int            *pFpiar;		/* instruction address register		 */
{
	return (fppTaskRegsGet(pTcb->tcb_id, fpregs, pFpcr, pFpsr, pFpiar));
}
/*******************************************************************************
*
* fppSetTaskRegs - set a task's floating-point registers 
*/

STATUS 
fppSetTaskRegs(pTcb, fpregs, fpcr, fpsr, fpiar)
	FAST VX_TCB    *pTcb;
	double          fpregs[];	/* floating-point registers 0 - 7	 */
int             fpcr;		/* control register			 */
int             fpsr;		/* status register			 */
int             fpiar;		/* instruction address register		 */
{
	return (fppTaskRegsSet(pTcb->tcb_id, fpregs, fpcr, fpsr, fpiar));
}
/*******************************************************************************
*
* create - create a file
*
*/
int 
create(name, mode)
	char           *name;	/* name of the file to create */
	int             mode;	/* file creation mode */
{
	return (creat(name, mode));
}
/*******************************************************************************
*
* memList - print free list
*
*/
VOID 
memList()
{
	memPartShow(&memSysPartition, 1);
}

/*******************************************************************************
*
* memStat - print statistics
*
*/
VOID 
memStat()
{
	memPartShow(&memSysPartition, 0);
}

/*******************************************************************************
*
* memPartList - print list for a particular partition
*
*/
VOID 
memPartList(partId)
	FAST PART_ID    partId;	/* partition ID */
{
	memPartShow(partId, 1);
}

/*******************************************************************************
*
* memPartStat - print statistics for a particular partition
*
*/
VOID 
memPartStat(partId)
	FAST PART_ID    partId;	/* partition ID */
{
	memPartShow(partId, 0);
}
/*******************************************************************************
*
* memDbg - turn debuggin on/off.
*
*/
memDbg(debug)
	BOOL            debug;
{
	if (debug)
		memOptionsSet(MEM_ALLOC_ERROR_LOG_AND_SUSPEND);
	else
		memOptionsSet(MEM_ALLOC_ERROR_RETURN);
}

/*******************************************************************************
*
* memAllocate - allocate memory (obsolete)
*
* This routine is here for upward compatability with software developed
* under previous versions of UniWorks.  It is simply a call to malloc (2).
*
* RETURNS
*   pointer to fragment, or
*   NULL if unsuccessful.
*/

char           *
memAllocate(nBytes)
	int             nBytes;	/* number of bytes to allocate */

{
	return (malloc(nBytes));
}
/*******************************************************************************
*
* setStatus - set calling task's status
*
* For compatibility with 3.21. This routine simply calls errnoSet.
*
*/
STATUS 
setStatus(status)
	int             status;	/* error status value to set */
{
	return (errnoSet(status));
}

/*******************************************************************************
*
* setTaskStatus - set another task's status
*
* For compatibility with 3.21. This routine simply calls errnoOfTaskSet.
*
*/
STATUS 
setTaskStatus(taskid, status)
	int             taskid;	/* task's id, 0 means current task */
	int             status;	/* status code number */
{
	return (errnoOfTaskSet(taskid, status));
}

/*******************************************************************************
*
* getStatus - get calling task's status
*
* For compatibility with 3.21. This routine simply calls errnoGet.
*
*/
STATUS 
getStatus()
{
	return (errnoGet());
}

/*******************************************************************************
*
* getTaskStatus - get another task's status
*
* For compatibility with 3.21. This routine simply calls errnoOfTaskGet.
*
*/
STATUS 
getTaskStatus(taskid)
	int             taskid;	/* task's id, 0 means current task */
{
	return (errnoOfTaskGet(taskid));
}
/*******************************************************************************
*
* ioGetDefDev - get default device
*
*/
VOID ioGetDefDev (name)
	char *name;
{
	ioDefDevGet(name);
}
/*******************************************************************************
*
* ioSetDefDev - set default device
*
*/
VOID ioSetDefDev (name)
	char *name;
{
	ioDefPathSet(name);
}
/*******************************************************************************
*
* ioGetDefDevTail - get default path
*
*/
VOID ioGetDefDevTail (head, tail)
    char *head;         /* name of device */
    char *tail;         /* where to return value */
{
	ioDefDirGet(tail);
}
