
# line 2 "shell.yacc"
/* shell.yacc - UniWorks shell */
 
static char *copyright = "Copyright 1984-1988, Wind River Systems, Inc.";
  
/*
modification history
--------------------
*/

/*
DESCRIPTION
This is the parser for the UniWorks shell, written in yacc.
It provides the basic programmer's interface to UniWorks.
It is a C expression interpreter, containing no built-in commands.  

SEE ALSO: "Shell"
*/

#include "UniWorks.h"
#include "sysSymTbl.h"

#define YYSTYPE VALUE		/* type of parse stack */

#define	MAX_SHELL_LINE	128	/* max chars on line typed to shell */

#define MAX_ARGS	30	/* max number of args on stack */
#define MAX_FUNC_ARGS	10	/* max number of args to any one function */

#define BIN_OP(op)	rvOp((getRv(&yypvt[-2], &tmpVal1)), op, \
			      getRv(&yypvt[-0], &tmpVal2))

#define	RV(value)	(getRv (&(value), &tmpVal2))
#define NULLVAL		(VALUE *) NULL

#define CHECK		if (semError) YYERROR
#define SET_ERROR	semError = TRUE


typedef enum		/* TYPE */
    {
    T_UNKNOWN,
    T_BYTE,
    T_WORD,
    T_INT,
    T_FLOAT,
    T_DOUBLE
    } TYPE;

typedef enum		/* SIDE */
    {
    LHS,
    RHS,
    FHS,	/* function: rhs -> lhs */
    } SIDE;

typedef struct		/* VALUE */
    {
    SIDE side;
    TYPE type;
    union
	{
	int *lv;	/* pointer to any of the below */

	char byte;
	short word;
	int rv;
	char *string;
	float fp;
	double dp;
	} value;
    } VALUE;

IMPORT int redirInFd;
IMPORT int redirOutFd;

LOCAL BOOL semError;	/* TRUE = semantic error found */
LOCAL VALUE tmpVal1;	/* used by BIN_OP above for expression evaluation */
LOCAL VALUE tmpVal2;	/* used by BIN_OP above for expression evaluation */
LOCAL int argStack [MAX_ARGS];	/* arguments to functions */
LOCAL int nArgs;	/* number of args currently on argStack */
LOCAL BOOL usymFlag;	/* TRUE = U_SYMBOL has been seen */
LOCAL VALUE usymVal;	/* value of U_SYMBOL which has been seen */

# define NL 0
# define T_SYMBOL 258
# define D_SYMBOL 259
# define U_SYMBOL 260
# define NUMBER 261
# define CHAR 262
# define STRING 263
# define FLOAT 264
# define OR 265
# define AND 266
# define EQ 267
# define NE 268
# define GE 269
# define LE 270
# define INCR 271
# define DECR 272
# define ROT_LEFT 273
# define ROT_RIGHT 274
# define UMINUS 275
# define PTR 276
# define TYPECAST 277
# define ENDFILE 278
# define LEX_ERROR 279
# define MULA 280
# define DIVA 281
# define MODA 282
# define ADDA 283
# define SUBA 284
# define SHLA 285
# define SHRA 286
# define ANDA 287
# define ORA 288
# define XORA 289
# define UNARY 290
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 279 "shell.yacc"


#include "a_out.h"
#include "ctype.h"
#include "memLib.h"
#include "strLib.h"
#include "symLib.h"

#include "shell_slex_c"

/* forward declarations */

LOCAL int newString ();
LOCAL VALUE *getRv ();
LOCAL int *getLv ();
LOCAL VALUE evalExp ();

/*******************************************************************************
*
* yystart - initialize local variables
*
* NOMANUAL
*/

VOID yystart (line)
    char *line;

    {
    lexNewLine (line);
    semError = FALSE;
    usymFlag = FALSE;
    nArgs = 0;
    }
/*******************************************************************************
*
* yyerror - report error
*
* This routine is called by yacc when an error is detected.
*/

LOCAL VOID yyerror (string)
    char *string;

    {
    if (semError)	/* semantic errors have already been reported */
	return;

    /* print error depending on what look-ahead token is */

    switch (yychar)
	{
	case U_SYMBOL:	/* U_SYM not at beginning of line */
	    printf ("undefined symbol: %s\n", yylval.value.rv);
	    break;

	case LEX_ERROR:	     /* lex should have already reported the problem */
	    break;

	default:
	    if (usymFlag)    /* leading U_SYM was followed by invalid assign */
		printf ("undefined symbol: %s\n", (char *)usymVal.value.rv);
	    else
		printf ("%s\n", string);
	    break;
	}
    }
/*******************************************************************************
*
* rvOp - sets rhs of yyval to evaluated expression
*/

LOCAL VOID rvOp (pY1, op, pY2)
    VALUE *pY1;
    int op;
    VALUE *pY2;

    {
    VALUE yy;

    yy = evalExp (pY1, op, pY2);

    setRv (&yyval, &yy);
    }
/*******************************************************************************
*
* assign - make assignment of new value to a cell
*/

LOCAL VOID assign (pLv, pRv)
    FAST VALUE *pLv;	/* lhs to be assigned into */
    FAST VALUE *pRv;	/* rhs value */

    {
    VALUE val;

    /* verify that lv can be assigned to, then make the assignment */

    if (chkLvAccess (pLv) && checkRv (pRv))
	{
	(void)getRv (pRv, &val);

	/* make value agree in type */

	pLv->type = pRv->type;

	typeConvert (&val, pLv->type, RHS);

	switch (pLv->type)
	    {
	    case T_BYTE:
		* (char *)getLv (pLv) = val.value.byte;
		break;

	    case T_WORD:
		* (short *)getLv (pLv) = val.value.word;
		break;

	    case T_INT:
		*getLv (pLv) = val.value.rv;
		break;

	    case T_FLOAT:
		* (float *)getLv (pLv) = val.value.fp;
		break;

	    case T_DOUBLE:
		* (double *)getLv (pLv) = val.value.dp;
		break;

	    default:
		printf ("bad assignment.\n");
		SET_ERROR;
	    }
	}
    else
	{
	printf ("bad assignment.\n");
	SET_ERROR;
	}
    }
/*******************************************************************************
*
* newString - allocate and copy a string
*/

LOCAL int newString (string)
    char *string;

    {
    int length    = strlen (string) + 1;
    char *address = malloc ((unsigned) length);

    if (address == NULL)
	{
	printf ("not enough memory for new string.\n");
	SET_ERROR;
	}
    else
	bcopy (string, address, length);

    return ((int)address);
    }
/*******************************************************************************
*
* newSym - allocate a new symbol and add to symbol table
*/

LOCAL VALUE newSym (name, type)
    char *name;
    TYPE type;

    {
    VALUE value;
    char *address = malloc (sizeof (double));

    if (address == NULL)
	{
	printf ("not enough memory for new variable.\n");
	SET_ERROR;
	}

    else if (symAdd (sysSymTbl, name, (char *) address, (N_BSS | N_EXT)) != OK)
	{
	free (address);
	printf ("can't add '%s' to system symbol table - error = 0x%x.\n",
		name, errnoGet());
	SET_ERROR;
	}
    else
	{
	printf ("new symbol \"%s\" added to symbol table.\n", name);

	value.side	= LHS;
	value.type	= type;
	value.value.lv	= (int *) address;
	}

    return (value);
    }
/*******************************************************************************
*
* printSym - print symbolic value
*/

LOCAL VOID printSym (val, prefix, suffix)
    FAST int val;
    char *prefix;
    char *suffix;

    {
    int symVal;
    UTINY type;
    char name [MAX_SYS_SYM_LEN + 1];

    if ((symValFind (sysSymTbl, val, name, &symVal, &type) == OK) && 
	(symVal != 0) && ((val - symVal) < 0x1000))
	{
	printf (prefix);

	if (val == symVal)
	    printf ("%s", name);
	else
	    printf ("%s + 0x%x", name, val - symVal);

	printf (suffix);
	}
    }
/*******************************************************************************
*
* newArgList - start a new argument list
*/

LOCAL VALUE newArgList ()
    {
    VALUE value;

    value.side	   = RHS;
    value.type	   = T_INT;
    value.value.rv = nArgs;

    return (value);
    }
/*******************************************************************************
*
* addArg - add an argument to an argument list
*/

LOCAL VOID addArg (pArgList, pNewArg)
    VALUE *pArgList;
    FAST VALUE *pNewArg;

    {
    VALUE val;
    int partA;
    int partB;
    BOOL isfloat = pNewArg->type == T_FLOAT || pNewArg->type == T_DOUBLE;

    if (isfloat)
	nArgs++;	/* will need an extra arg slot */

    if (nArgs == MAX_ARGS || (nArgs - pArgList->value.rv) == MAX_FUNC_ARGS)
	{
	if (isfloat)
	    nArgs--;	/* return borrowed slot */

	printf ("too many arguments to functions.\n");
	SET_ERROR;
	}
    else
	{
	/* push arg value on top of arg stack */

	(void)getRv (pNewArg, &val);

	if (isfloat)
	    {
	    nArgs--;	/* return borrowed slot */

	    /* put float as integers on argStack */

	    doubleToInts (pNewArg->type == T_FLOAT ?
			  val.value.fp : val.value.dp,
			  &partA, &partB);

	    argStack[nArgs++] = partA;
	    argStack[nArgs++] = partB;
	    }
	else if (checkRv (&val))
	    {
	    int rv;

	    switch (val.type)
		{
		case T_BYTE:
		    rv = val.value.byte;
		    break;

		case T_WORD:
		    rv = val.value.word;
		    break;

		case T_INT:
		    rv = val.value.rv;
		    break;

		default:
		    printf ("addArg: bad type.\n");
		    SET_ERROR;
		}

	    argStack[nArgs++] = rv;
	    }
	}
    }
/*******************************************************************************
*
* doubleToInts - separate double into two integer parts
*/

LOCAL VOID doubleToInts (d, partA, partB)
    double d;
    int *partA;
    int *partB;

    {
    union 
	{
	struct
	    {
	    int a;
	    int b;
	    } part;
	double d;
	} val;

    val.d = d;

    *partA = val.part.a;
    *partB = val.part.b;
    }
/*******************************************************************************
*
* funcCall - call a function
*/

LOCAL VALUE funcCall (pV, pArgList)
    VALUE *pV;
    VALUE *pArgList;

    {
    static int funcStatus;	/* status from function calls */
    int a [MAX_FUNC_ARGS];
    VALUE value;
    FAST int i;
    FAST int argNum;
    int oldInFd	 = ioGlobalStdGet (STD_IN);
    int oldOutFd = ioGlobalStdGet (STD_OUT);
    FUNCPTR pFunc = (pV->side == LHS) ? (FUNCPTR) (int)getLv (pV)
				      : (FUNCPTR) pV->value.rv;

    if (checkAccess ((int) pFunc))
	{
	/* get any specified args off stack, or pre-set all args to 0 */

	for (argNum = pArgList->value.rv, i = 0;
	     i < MAX_FUNC_ARGS; argNum++, i++)
	    {
	    a [i] = (argNum < nArgs) ? argStack[argNum] : 0;
	    }

        /* set standard in/out to redirection fds */

	if (redirInFd >= 0)
	    ioGlobalStdSet (STD_IN, redirInFd);

	if (redirOutFd >= 0)
	    ioGlobalStdSet (STD_OUT, redirOutFd);

	/* call function and save resulting status */

	errnoSet (funcStatus);

	value.side = RHS;
	value.type = pV->type;

	switch (pV->type)
	    {
	    case T_BYTE:
	    case T_WORD:
	    case T_INT:
		{
		int rv = (* pFunc) (a[0], a[1], a[2], a[3], a[4], a[5], a[6],
				    a[7], a[8], a[9]);

		switch (pV->type)
		    {
		    case T_BYTE:
			value.value.byte = (char) rv;
			break;

		    case T_WORD:
			value.value.word = (short) rv;
			break;

		    case T_INT:
			value.value.rv = rv;
			break;
		    }

		break;
		}

	    case T_FLOAT:
		value.value.fp = (* (float (*)())pFunc) (a[0], a[1], a[2], a[3],
					a[4], a[5], a[6], a[7], a[8], a[9]);
		break;

	    case T_DOUBLE:
		value.value.dp = (* (double (*)())pFunc) (a[0], a[1],
			    a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9]);
		break;

	    default:
		printf ("funcCall: bad function type.\n");
		SET_ERROR;
	    }

	funcStatus = errnoGet ();

	/* restore original in/out fds */

	if (redirInFd >= 0)
	    ioGlobalStdSet (STD_IN, oldInFd);

	if (redirOutFd >= 0)
	    ioGlobalStdSet (STD_OUT, oldOutFd);

	/* arg stack back to previous level */

	nArgs = pArgList->value.rv;
	}

    return (value);
    }
/*******************************************************************************
*
* chkLvAccess - check that a value is an accessable left value
*/

LOCAL BOOL chkLvAccess (pValue)
    VALUE *pValue;

    {
    if (!checkLv (pValue))
	return (FALSE);

    return (checkAccess ((int) getLv (pValue)));
    }
/*******************************************************************************
*
* checkAccess - check that an address is accessable
*/

LOCAL BOOL checkAccess (adrs)
    int adrs;

    {
    if (sysMemProbe ((char *) adrs) != OK)
	{
	printf ("attempt to access non-existent address: 0x%x.\n", adrs);
	SET_ERROR;
	return (FALSE);
	}

    return (TRUE);
    }
/*******************************************************************************
*
* checkLv - check that a value can be used as left value
*/

LOCAL BOOL checkLv (pValue)
    VALUE *pValue;

    {
    if (pValue->side != LHS)
	{
	printf ("invalid application of 'address of' operator.\n");
	SET_ERROR;
	return (FALSE);
	}

    return (TRUE);
    }
/*******************************************************************************
*
* checkRv - check that a value can be used as right value
*/

LOCAL BOOL checkRv (pValue)
    VALUE *pValue;

    {
    if (pValue->side == LHS)
	return (chkLvAccess (pValue));

    return (TRUE);
    }
/*******************************************************************************
*
* getRv - get a value's right value 
*/

LOCAL VALUE *getRv (pValue, pRv)
    FAST VALUE *pValue;
    FAST VALUE *pRv;			/* where to put value */

    {
    if (pValue->side == RHS)
	*pRv = *pValue;
    else
	{
	pRv->side = RHS;
	pRv->type = pValue->type;

	switch (pValue->type)
	    {
	    case T_BYTE:
		pRv->value.byte = *(char *)pValue->value.lv;
		break;

	    case T_WORD:
		pRv->value.word = *(short *)pValue->value.lv;
		break;

	    case T_INT:
		pRv->value.rv = *pValue->value.lv;
		break;

	    case T_FLOAT:
		pRv->value.fp = *(float *)pValue->value.lv;
		break;

	    case T_DOUBLE:
		pRv->value.dp = *(double *)pValue->value.lv;
		break;

	    default:
		printf ("getRv: invalid rhs.");
		SET_ERROR;
	    }
	}

    return (pRv);
    }
/*******************************************************************************
*
* getLv - get a value's left value (address)
*/

LOCAL int *getLv (pValue)
    VALUE *pValue;

    {
    return (checkLv (pValue) ? pValue->value.lv : 0);
    }
/*******************************************************************************
*
* setLv - set a lv
*/

LOCAL VOID setLv (pVal1, pVal2)
    FAST VALUE *pVal1;
    FAST VALUE *pVal2;

    {
    if (pVal2->side == LHS)
	{
	printf ("setLv: invalid lhs.\n");
	SET_ERROR;
	}

    if ((int)pVal2->type != (int)T_INT)
	{
	printf ("setLv: type conflict.\n");
	SET_ERROR;
	}

    pVal1->side     = LHS;
    pVal1->type     = pVal2->type;
    pVal1->value.lv = (int *)pVal2->value.rv;
    }
/*******************************************************************************
*
* setRv - set the rv
*/

LOCAL VOID setRv (pVal1, pVal2)
    FAST VALUE *pVal1;
    FAST VALUE *pVal2;

    {
    pVal1->side = RHS;
    pVal1->type = pVal2->type;

    switch (pVal2->type)
	{
	case T_BYTE:
	    pVal1->value.byte = (pVal2->side == LHS) ?
			    *(char *)pVal2->value.lv : pVal2->value.byte;
	case T_WORD:
	    pVal1->value.word = (pVal2->side == LHS) ?
			    *(short *)pVal2->value.lv : pVal2->value.word;

	case T_INT:
	    pVal1->value.rv = (pVal2->side == LHS) ?
			    *pVal2->value.lv : pVal2->value.rv;
	    break;

	case T_FLOAT:
	    pVal1->value.fp = (pVal2->side == LHS) ?
			    *(float *)pVal2->value.lv : pVal2->value.fp;
	    break;

	case T_DOUBLE:
	    pVal1->value.dp = (pVal2->side == LHS) ?
			    *(double *)pVal2->value.lv : pVal2->value.dp;
	    break;

	default:
	    printf ("setRv: bad type.\n");
	    SET_ERROR;
	}
    }
/*******************************************************************************
*
* printLv - print left-hand side value
*
* "ssss + xxx = xxxx"
*/

LOCAL VOID printLv (pValue)
    VALUE *pValue;

    {
    FAST int *lv = getLv (pValue);

    printSym ((int) lv, "", " = ");

    printf ("0x%x", lv);
    }
/*******************************************************************************
*
* printRv - print right-hand side value
*
* The format for integers is:
*
* "nnnn = xxxx = 'c' = ssss + nnn"
*                           ^ only if nn < LIMIT for some ssss
*                 ^ only if value is printable
*/

LOCAL VOID printRv (pValue)
    VALUE *pValue;

    {
    VALUE val;
    int rv;

    (void)getRv (pValue, &val);

    switch (pValue->type)
	{
	case T_BYTE:
	    rv = val.value.byte;
	    goto caseT_INT;

	case T_WORD:
	    rv = val.value.word;
	    goto caseT_INT;

	case T_INT:
	    rv = val.value.rv;
	    /* drop through */

	caseT_INT:
	    printf ("%d = 0x%x", rv, rv);
	    if (isascii (rv) && isprint (rv))
		printf (" = '%c'", rv);

	    printSym (rv, " = ", "");
	    break;

	case T_FLOAT:
	    printf ("%g", val.value.fp);
	    break;

	case T_DOUBLE:
	    printf ("%g", val.value.dp);
	    break;

	default:
	    printf ("printRv: bad type.\n");
	    SET_ERROR;
	}
    }
/*******************************************************************************
*
* printValue - print out value
*/

LOCAL VOID printValue (pValue)
    FAST VALUE *pValue;

    {
    if (pValue->side == LHS)
	{
	if (checkLv (pValue) && checkRv (pValue))
	    {
	    printLv (pValue);
	    printf (": value = ");

	    printRv (pValue);
	    printf ("\n");
	    }
	else
	    {
	    printf ("invalid lhs.\n");
	    SET_ERROR;
	    }
	}
    else if (checkRv (pValue))
	{
	printf ("value = ");

	printRv (pValue);
	printf ("\n");
	}
    else
	{
	printf ("invalid rhs.\n");
	SET_ERROR;
	}
    }

/* TYPE SUPPORT */

LOCAL VALUE evalUnknown ();
LOCAL VALUE evalByte ();
LOCAL VALUE evalWord ();
LOCAL VALUE evalInt ();
LOCAL VALUE evalFloat ();
LOCAL VALUE evalDouble ();

typedef struct		/* EVAL_TYPE */
    {
    VALUE (*eval) ();
    } EVAL_TYPE;

LOCAL EVAL_TYPE evalType [] =
    {
    /*	eval		type		*/
    /*	---------------	--------------	*/
      { evalUnknown,	/* T_UNKNOWN*/	},
      { evalByte,	/* T_BYTE   */	},
      { evalWord,	/* T_WORD   */	},
      { evalInt,	/* T_INT    */	},
      { evalFloat,	/* T_FLOAT  */	},
      { evalDouble,	/* T_DOUBLE */	},
    };

/*******************************************************************************
*
* evalExp - evaluate expression
*/

LOCAL VALUE evalExp (pValue1, op, pValue2)
    VALUE *pValue1;
    int op;
    VALUE *pValue2;

    {
    VALUE *p1 = pValue1;
    VALUE *p2 = pValue2;

    if (pValue2 == NULLVAL) /* unary expresions must set pValue2 to something */
	p2 = pValue2 = pValue1;

    /* make sure values have the same type */

    if ((int)p1->type > (int)p2->type)
	typeConvert (p2, p1->type, p1->side);
    else
	typeConvert (p1, p2->type, p2->side);

    return ((evalType[(int)pValue1->type].eval) (pValue1, op, pValue2));
    }
/*******************************************************************************
*
* evalUnknown - evaluate for unknown result
*
* ARGSUSED
*/

LOCAL VALUE evalUnknown (pValue1, op, pValue2)
    VALUE *pValue1;
    int op;
    VALUE *pValue2;

    {
    printf ("evalUnknown: bad evaluation.\n");

    SET_ERROR;

    return (*pValue1);	/* have to return something */
    }
/*******************************************************************************
*
* evalByte - evaluate for byte result
*/

LOCAL VALUE evalByte (pValue1, op, pValue2)
    VALUE *pValue1;
    int op;
    VALUE *pValue2;

    {
    VALUE *p1 = pValue1;
    VALUE *p2 = pValue2;
    VALUE result;

    /* evaluate as integers and then convert back */

    typeConvert (p1, T_INT, RHS);
    typeConvert (p2, T_INT, RHS);

    result = evalInt (p1, op, p2);

    typeConvert (&result, T_BYTE, RHS);

    return (result);
    }
/*******************************************************************************
*
* evalWord - evaluate for word result
*/

LOCAL VALUE evalWord (pValue1, op, pValue2)
    VALUE *pValue1;
    int op;
    VALUE *pValue2;

    {
    VALUE *p1 = pValue1;
    VALUE *p2 = pValue2;
    VALUE result;

    /* evaluate as integers and then convert back */

    typeConvert (p1, T_INT, RHS);
    typeConvert (p2, T_INT, RHS);

    result = evalInt (p1, op, p2);

    typeConvert (&result, T_WORD, RHS);

    return (result);
    }
/*******************************************************************************
*
* evalInt - evaluate for integer result
*/

LOCAL VALUE evalInt (pValue1, op, pValue2)
    VALUE *pValue1;
    int op;
    VALUE *pValue2;

    {
#define	OP_INT(op)	rv = e1 op e2; break
#define	OP_INT_U(op)	rv = op e1; break

    FAST int e1 = pValue1->value.rv;
    FAST int e2 = pValue2->value.rv;
    FAST int rv;
    VALUE result;

    switch (op)
	{
	case ADDA:
	case '+':
	    OP_INT(+);
	case SUBA:
	case '-':
	    OP_INT(-);
	case MULA:
	case '*':
	    OP_INT(*);
	case DIVA:
	case '/':
	    OP_INT(/);
	case '!':
	    OP_INT_U(!);
	case '~':
	    OP_INT_U(~);
	case MODA:
	case '%':
	    OP_INT(%);
	case ANDA:
	case '&':
	    OP_INT(&);
	case XORA:
	case '^':
	    OP_INT(^);
	case ORA:
	case '|':
	    OP_INT(|);
	case '<':
	    OP_INT(<);
	case '>':
	    OP_INT(>);
	case OR:
	    OP_INT(||);
	case AND:
	    OP_INT(&&);
	case EQ:
	    OP_INT(==);
	case NE:
	    OP_INT(!=);
	case GE:
	    OP_INT(>=);
	case LE:
	    OP_INT(>=);
	case INCR:
	    OP_INT_U(++);
	case DECR:
	    OP_INT_U(--);
	case SHLA:
	case ROT_LEFT:
	    OP_INT(<<);
	case SHRA:
	case ROT_RIGHT:
	    OP_INT(>>);
	case UMINUS:
	    OP_INT_U(-);
	default:
	    rv = 0;
	    printf ("operands have incompatible types.\n");
	    SET_ERROR;
	}

    result.side     = RHS;
    result.type     = pValue1->type;
    result.value.rv = rv;

    return (result);
    }
/*******************************************************************************
*
* evalFloat - evaluate for float result
*/

LOCAL VALUE evalFloat (pValue1, op, pValue2)
    VALUE *pValue1;
    int op;
    VALUE *pValue2;

    {
    VALUE *p1 = pValue1;
    VALUE *p2 = pValue2;
    VALUE result;

    /* evaluate as doubles and then convert back */

    typeConvert (p1, T_DOUBLE, RHS);
    typeConvert (p2, T_DOUBLE, RHS);

    result = evalDouble (p1, op, p2);

    typeConvert (&result, T_FLOAT, RHS);

    return (result);
    }
/*******************************************************************************
*
* evalDouble - evaluate for double result
*/

LOCAL VALUE evalDouble (pValue1, op, pValue2)
    VALUE *pValue1;
    int op;
    VALUE *pValue2;

    {
#define	OP_DOUBLE(op)	dp = e1 op e2; break
#define	OP_DOUBLE_U(op)	dp = op e1; break

    FAST double e1 = pValue1->value.dp;
    FAST double e2 = pValue2->value.dp;
    FAST double dp;
    VALUE result;

    switch (op)
	{
	case ADDA:
	case '+':
	    OP_DOUBLE(+);
	case SUBA:
	case '-':
	    OP_DOUBLE(-);
	case MULA:
	case '*':
	    OP_DOUBLE(*);
	case DIVA:
	case '/':
	    OP_DOUBLE(/);
	case '!':
	    OP_DOUBLE_U(!);

	case '<':
	    OP_DOUBLE(<);
	case '>':
	    OP_DOUBLE(>);
	case OR:
	    OP_DOUBLE(||);
	case AND:
	    OP_DOUBLE(&&);
	case EQ:
	    OP_DOUBLE(==);
	case NE:
	    OP_DOUBLE(!=);
	case GE:
	    OP_DOUBLE(>=);
	case LE:
	    OP_DOUBLE(>=);
	case INCR:
	    OP_DOUBLE_U(++);
	case DECR:
	    OP_DOUBLE_U(--);

	case UMINUS:
	    OP_DOUBLE_U(-);

	default:
	    dp = 0;
	    printf ("operands have incompatible types.\n");
	    SET_ERROR;
	}

    result.side     = RHS;
    result.type     = T_DOUBLE;
    result.value.dp = dp;

    return (result);
    }

/* TYPE CONVERSION */

LOCAL VOID convUnknown ();
LOCAL VOID convByte ();
LOCAL VOID convWord ();
LOCAL VOID convInt ();
LOCAL VOID convFloat ();
LOCAL VOID convDouble ();

LOCAL FUNCPTR convType [] =
    {
    /*  conversion	type	    */
    /*  ----------	----------- */
	convUnknown,	/* T_UNKNOWN*/
	convByte,	/* T_BYTE   */
	convWord,	/* T_WORD   */
	convInt,	/* T_INT    */
	convFloat,	/* T_FLOAT  */
	convDouble,	/* T_DOUBLE */
    };

/*******************************************************************************
*
* typeConvert - change value to specified type
*/

LOCAL VOID typeConvert (pValue, type, side)
    FAST VALUE *pValue;
    TYPE type;
    SIDE side;

    {
    if (side == FHS)
	{
	pValue->side = RHS;
	pValue->type = type;
	}
    else if (side == RHS)
	{
	if (pValue->side == LHS)
	    pValue->type = type;
	else
	    (convType [(int) type]) (pValue);
	}
    else if (pValue->side == LHS)
	pValue->type = type;
    else
	{
	printf ("typeConvert: bad type.\n");
	SET_ERROR;
	}
    }
/*******************************************************************************
*
* convUnknown - convert value to unknown
*
* ARGSUSED
*/

LOCAL VOID convUnknown (pValue)
    VALUE *pValue;

    {
    printf ("convUnknown: bad type.\n");
    SET_ERROR;
    }
/*******************************************************************************
*
* convByte - convert value to byte
*/

LOCAL VOID convByte (pValue)
    FAST VALUE *pValue;

    {
    char value;
    
    if ((int)pValue->type > (int)T_BYTE)
	{
	convWord (pValue);
	value = pValue->value.word;
	pValue->value.byte = value;
	pValue->type = T_BYTE;
	}
    }
/*******************************************************************************
*
* convWord - convert value to word
*/

LOCAL VOID convWord (pValue)
    FAST VALUE *pValue;

    {
    short value;
    
    if ((int)pValue->type < (int)T_WORD)
	{
	value = pValue->value.byte;
	pValue->value.word = value;
	pValue->type = T_WORD;
	}
    else if ((int)pValue->type > (int)T_WORD)
	{
	convInt (pValue);
	value = pValue->value.rv;
	pValue->value.word = value;
	pValue->type = T_WORD;
	}
    }
/*******************************************************************************
*
* convInt - convert value to integer
*/

LOCAL VOID convInt (pValue)
    FAST VALUE *pValue;

    {
    int value;
    
    if ((int)pValue->type < (int)T_INT)
	{
	convWord (pValue);
	value = pValue->value.word;
	pValue->value.rv = value;
	pValue->type = T_INT;
	}
    else if ((int)pValue->type > (int)T_INT)
	{
	convFloat (pValue);
	value = pValue->value.fp;
	pValue->value.rv = value;
	pValue->type = T_INT;
	}
    }
/*******************************************************************************
*
* convFloat - convert value to float
*/

LOCAL VOID convFloat (pValue)
    FAST VALUE *pValue;

    {
    float value;
    
    if ((int)pValue->type < (int)T_FLOAT)
	{
	convInt (pValue);
	value = pValue->value.rv;
	pValue->value.fp = value;
	pValue->type = T_FLOAT;
	}
    else if ((int)pValue->type > (int)T_FLOAT)
	{
	convDouble (pValue);
	value = pValue->value.dp;
	pValue->value.fp = value;
	pValue->type = T_FLOAT;
	}
    }
/*******************************************************************************
*
* convDouble - convert value to double
*/

LOCAL VOID convDouble (pValue)
    FAST VALUE *pValue;

    {
    double value;
    
    if ((int)pValue->type < (int)T_DOUBLE)
	{
	convFloat (pValue);

	value = pValue->value.fp;
	pValue->value.dp = value;
	pValue->type = T_DOUBLE;
	}
    }
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 63
# define YYLAST 810
short yyact[]={

  29,  32, 106,  21,  21,  27,  25,  20,  26, 108,
  28, 105, 104, 115, 111, 107,  69,   1,  66,  11,
  68,   2,   0,  42,  55,  41,  22,  29,  32,   0,
  21,   0,  27,  25,   0,  26,   0,  28,  67,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 109,   0,
  42,  55,  41,  22,  23,  23, 110,  33,   0,   0,
   0,   0,   0,   0,   0,  29,  32,   0,  21, 103,
  27,  25,   0,  26,   0,  28,   0,   0,   0,   0,
   0,  23,   0,   0,  33,   0,   0,  34,  42,  55,
  41,  22,  29,  32,   0,  21,   0,  27,  25,   0,
  26,   0,  28,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  34,  42,  55,  41,  22,  23,
   0,   0,  33,   0,   0,   0,   0,   0,  29,  32,
   0,  21,   0,  27,  25,   0,  26,   0,  28,   0,
   0,   0,   0,   0,   0,   0,  23,   0,   0,  33,
   0,  42,  34,  41,  22,  29,  32,   0,  21,   0,
  27,  25,   0,  26,   0,  28,  29,  32,   0,  21,
   0,  27,  25,   0,  26,   0,  28,   0,  42,  34,
  41,   0,  23,   0,   0,  33,   0,  29,   0,  42,
  21,  41,  27,  25,   0,  26,   0,  28,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,  23,
   0,   0,  33,   0,   0,  34,   0,   0,   0,   0,
  23,   0,   0,  33,   0,   0,   0,   0,  36,  35,
  37,  38,  39,  40,  43,  44,  31,  30,   0,  24,
  24,  23,  34,  51,  52,  49,  45,  46,  53,  54,
  47,  48,  50,  34,   0,  36,  35,  37,  38,  39,
  40,  43,  44,  31,  30,   0,  24,  21,   0,   0,
  51,  52,  49,  45,  46,  53,  54,  47,  48,  50,
  29,  32,   0,  21,   0,  27,  25,   0,  26,   0,
  28,   0,   0,  36,  35,  37,  38,  39,  40,  43,
  44,  31,  30,  42,  24,  41,   0,   0,  51,  52,
  49,  45,  46,  53,  54,  47,  48,  50,  23,   0,
  36,  35,  37,  38,  39,  40,  43,  44,  31,  30,
   0,  24,   0,   0,  23,  51,  52,  49,  45,  46,
  53,  54,  47,  48,  50,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,  36,  35,  37,  38,
  39,  40,  43,  44,  31,  30,   0,  24,   0,   0,
  29,  32,   0,  21,   0,  27,  25,   0,  26,   0,
  28,   0,   0,   0,  35,  37,  38,  39,  40,  43,
  44,  31,  30,  42,  24,  41,  37,  38,  39,  40,
  43,  44,  31,  30,   0,  24,  29,   0,   0,  21,
   0,  27,  25,   0,  26,   0,  28,   0,   0,   0,
   0,  43,  44,   0,  23,  15,  24,  33,   0,  42,
  13,  41,  10,   0,  12,   0,   0,  14,  29,   0,
   0,  21,   0,  27,  25,   0,  26,  29,  28,   0,
  21,   0,  27,  25,   0,  26,   0,  28,   0,   0,
  23,  42,  15,  41,   0,   0,   0,  13,   0,  10,
  29,  12,   0,  21,  14,  27,   0,   0,   0,   0,
  28,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  23,   0,   0,   0,   0,   0,  43,  44,
   0,  23,   0,  24,   0,   0,   0,   0,   0,   0,
  37,  38,  39,  40,  43,  44,  31,  30,  16,  24,
   0,   0,   0,   0,  23,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  37,  38,  39,  40,  43,  44,  31,  30,   0,  24,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,  37,  38,  39,  40,
  43,  44,  31,  30,   0,  24,   0,   0,   0,   0,
   5,   4,  19,   8,   7,   6,   9,   0,   0,   0,
   0,   0,   0,  17,  18,   0,   0,   0,   0,  57,
  39,  40,  43,  44,  31,  30,   0,  24,   0,   0,
   0,  43,  44,  31,  30,   0,  24,   5,   4,  19,
   8,   7,   6,   9,   0,   0,   0,   0,   0,   3,
  17,  18,   0,   0,  43,  44,   0,   0,   0,  24,
  56,  58,  59,  60,  61,  62,  63,  64,  65,   0,
   0,  70,  71,  72,  73,  74,  75,  76,  77,  78,
  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,
  89,  90,  91,   0,   0,  92,  93,  94,  95,  96,
  97,  98,  99, 100, 101, 102,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 112,   0, 113, 114 };
short yypact[]={

 429,-1000, -52,  55,-1000,-1000,-1000,-1000,-1000,-1000,
 392, 429, 429, 429, 429, 429, 429, 429, 429,-1000,
 429, 429, 429, 429, 429, 429, 429, 429, 429, 429,
 429, 429, 429, 429, 429, 429, 429, 429, 429, 429,
 429, 429, 429,-1000,-1000, 429, 429, 429, 429, 429,
 429, 429, 429, 429, 429, 429,  28, -29,-1000, -36,
 -36, -36, -36, -36, -36, -36, -59,-1000, -26, -35,
  55, -10, -37,-1000, 433, 433, 227, 227, 227, 150,
 150, 369, 243, 333, 129, 118, 401, 401, 410, 410,
 410, 410,  91,  91,  91,  91,  91,  91,  91,  91,
  91,  91,  91,-1000,-1000, -27, 429,-1000, 429, 429,
-1000, -28,  91,  55,  91,-1000 };
short yypgo[]={

   0,  17,  21, 699,  20,  19,  18,  16 };
short yyr1[]={

   0,   1,   1,   2,   2,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   6,   3,   4,   4,   7,
   7,   5,   5 };
short yyr2[]={

   0,   1,   3,   0,   1,   1,   1,   1,   1,   1,
   1,   3,   4,   2,   2,   2,   2,   2,   2,   5,
   4,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   2,   2,   2,   2,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   0,   4,   0,   1,   1,
   3,   3,   5 };
short yychk[]={

-1000,  -1,  -2,  -3, 259, 258, 263, 262, 261, 264,
  40,  -5,  42,  38,  45,  33, 126, 271, 272, 260,
  59,  40,  63,  91, 276,  43,  45,  42,  47,  37,
 274, 273,  38,  94, 124, 266, 265, 267, 268, 269,
 270,  62,  60, 271, 272, 283, 284, 287, 288, 282,
 289, 280, 281, 285, 286,  61,  -3, 277,  -3,  -3,
  -3,  -3,  -3,  -3,  -3,  -3,  -6,  -1,  -4,  -7,
  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,
  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,
  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,
  -3,  -3,  -3,  41,  41,  40,  61,  41,  44,  58,
  93,  41,  -3,  -3,  -3,  41 };
short yydef[]={

   3,  -2,   1,   4,   5,   6,   7,   8,   9,  10,
   0,   0,   0,   0,   0,   0,   0,   0,   0,  55,
   3,  57,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,  42,  43,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  13,  14,
  15,  16,  17,  18,  40,  41,   0,   2,   0,  58,
  59,   0,   0,  21,  22,  23,  24,  25,  26,  27,
  28,  29,  30,  31,  32,  33,  34,  35,  36,  37,
  38,  39,  44,  45,  46,  47,  48,  49,  50,  51,
  52,  53,  54,  11,  61,   0,   0,  12,   0,   0,
  20,   0,  56,  60,  19,  62 };
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif not lint

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 4:
# line 164 "shell.yacc"
{ printValue (&yypvt[-0]); CHECK; } break;
case 6:
# line 168 "shell.yacc"
{ yypvt[-0].side = RHS; setRv (&yyval, &yypvt[-0]); } break;
case 7:
# line 169 "shell.yacc"
{ yyval = yypvt[-0]; yyval.value.rv = newString((char*)yypvt[-0].value.rv);
			   CHECK; } break;
case 11:
# line 174 "shell.yacc"
{ yyval = yypvt[-1]; } break;
case 12:
# line 176 "shell.yacc"
{ yyval = funcCall (&yypvt[-3], &yypvt[-1]); CHECK; } break;
case 13:
# line 178 "shell.yacc"
{ 
			typeConvert (&yypvt[-0], yypvt[-1].type, yypvt[-1].side); yyval = yypvt[-0];
			CHECK;
			} break;
case 14:
# line 182 "shell.yacc"
{ VALUE tmp;
					  (void)getRv (&yypvt[-0], &tmp);
					  setLv (&yyval, &tmp);
					  CHECK;
					} break;
case 15:
# line 187 "shell.yacc"
{ yyval.value.rv = (int)getLv (&yypvt[-0]);
					  yyval.type = T_INT; yyval.side = RHS; } break;
case 16:
# line 189 "shell.yacc"
{ rvOp (RV(yypvt[-0]), UMINUS, NULLVAL); } break;
case 17:
# line 190 "shell.yacc"
{ rvOp (RV(yypvt[-0]), '!', NULLVAL); } break;
case 18:
# line 191 "shell.yacc"
{ rvOp (RV(yypvt[-0]), '~', NULLVAL); } break;
case 19:
# line 192 "shell.yacc"
{ setRv (&yyval, RV(yypvt[-4])->value.rv ? &yypvt[-2]
								       : &yypvt[-0]); } break;
case 20:
# line 194 "shell.yacc"
{ BIN_OP ('+');
					  typeConvert (&yyval, T_INT, RHS);
					  setLv (&yyval, &yyval); } break;
case 21:
# line 197 "shell.yacc"
{ BIN_OP ('+');
					  typeConvert (&yyval, T_INT, RHS);
					  setLv (&yyval, &yyval); } break;
case 22:
# line 200 "shell.yacc"
{ BIN_OP ('+'); } break;
case 23:
# line 201 "shell.yacc"
{ BIN_OP ('-'); } break;
case 24:
# line 202 "shell.yacc"
{ BIN_OP ('*'); } break;
case 25:
# line 203 "shell.yacc"
{ BIN_OP ('/'); } break;
case 26:
# line 204 "shell.yacc"
{ BIN_OP ('%'); } break;
case 27:
# line 205 "shell.yacc"
{ BIN_OP (ROT_RIGHT); } break;
case 28:
# line 206 "shell.yacc"
{ BIN_OP (ROT_LEFT); } break;
case 29:
# line 207 "shell.yacc"
{ BIN_OP ('&'); } break;
case 30:
# line 208 "shell.yacc"
{ BIN_OP ('^'); } break;
case 31:
# line 209 "shell.yacc"
{ BIN_OP ('|'); } break;
case 32:
# line 210 "shell.yacc"
{ BIN_OP (AND); } break;
case 33:
# line 211 "shell.yacc"
{ BIN_OP (OR); } break;
case 34:
# line 212 "shell.yacc"
{ BIN_OP (EQ); } break;
case 35:
# line 213 "shell.yacc"
{ BIN_OP (NE); } break;
case 36:
# line 214 "shell.yacc"
{ BIN_OP (GE); } break;
case 37:
# line 215 "shell.yacc"
{ BIN_OP (LE); } break;
case 38:
# line 216 "shell.yacc"
{ BIN_OP ('>'); } break;
case 39:
# line 217 "shell.yacc"
{ BIN_OP ('<'); } break;
case 40:
# line 218 "shell.yacc"
{ rvOp (RV(yypvt[-0]), INCR, NULLVAL);
						  assign (&yypvt[-0], &yyval); CHECK; } break;
case 41:
# line 220 "shell.yacc"
{ rvOp (RV(yypvt[-0]), DECR, NULLVAL);
						  assign (&yypvt[-0], &yyval); CHECK; } break;
case 42:
# line 222 "shell.yacc"
{ VALUE tmp;
						  tmp = yypvt[-1];
						  rvOp (RV(yypvt[-1]), INCR, NULLVAL);
						  assign (&yypvt[-1], &yyval); CHECK;
						  yyval = tmp; } break;
case 43:
# line 227 "shell.yacc"
{ VALUE tmp;
						  tmp = yypvt[-1];
						  rvOp (RV(yypvt[-1]), DECR, NULLVAL);
						  assign (&yypvt[-1], &yyval); CHECK;
						  yyval = tmp; } break;
case 44:
# line 232 "shell.yacc"
{ BIN_OP (ADDA); assign (&yypvt[-2], &yyval); CHECK;} break;
case 45:
# line 233 "shell.yacc"
{ BIN_OP (SUBA); assign (&yypvt[-2], &yyval); CHECK;} break;
case 46:
# line 234 "shell.yacc"
{ BIN_OP (ANDA); assign (&yypvt[-2], &yyval); CHECK;} break;
case 47:
# line 235 "shell.yacc"
{ BIN_OP (ORA);  assign (&yypvt[-2], &yyval); CHECK;} break;
case 48:
# line 236 "shell.yacc"
{ BIN_OP (MODA); assign (&yypvt[-2], &yyval); CHECK;} break;
case 49:
# line 237 "shell.yacc"
{ BIN_OP (XORA); assign (&yypvt[-2], &yyval); CHECK;} break;
case 50:
# line 238 "shell.yacc"
{ BIN_OP (MULA); assign (&yypvt[-2], &yyval); CHECK;} break;
case 51:
# line 239 "shell.yacc"
{ BIN_OP (DIVA); assign (&yypvt[-2], &yyval); CHECK;} break;
case 52:
# line 240 "shell.yacc"
{ BIN_OP (SHLA); assign (&yypvt[-2], &yyval); CHECK;} break;
case 53:
# line 241 "shell.yacc"
{ BIN_OP (SHRA); assign (&yypvt[-2], &yyval); CHECK;} break;
case 54:
# line 242 "shell.yacc"
{ assign (&yypvt[-2], &yypvt[-0]); yyval = yypvt[-2]; } break;
case 55:
# line 247 "shell.yacc"
{ usymFlag = TRUE; usymVal = yypvt[-0]; } break;
case 56:
# line 249 "shell.yacc"
{
			if (yypvt[-3].type != T_UNKNOWN)
			    {
			    printf ("typecast of lhs not allowed.\n");
			    YYERROR;
			    }
			else
			    {
			    yyval = newSym ((char *)yypvt[-3].value.rv, yypvt[-0].type); CHECK;
			    assign (&yyval, &yypvt[-0]); CHECK;
			    }
			usymFlag = FALSE;
			} break;
case 57:
# line 265 "shell.yacc"
{ yyval = newArgList (); } break;
case 59:
# line 270 "shell.yacc"
{ yyval = newArgList (); addArg (&yyval, &yypvt[-0]); CHECK; } break;
case 60:
# line 272 "shell.yacc"
{ addArg (&yypvt[-2], &yypvt[-0]); CHECK; } break;
case 61:
# line 275 "shell.yacc"
{ yypvt[-1].side = RHS; yyval = yypvt[-1]; } break;
case 62:
# line 276 "shell.yacc"
{ yypvt[-3].side = FHS; yyval = yypvt[-3]; } break;
		}
		goto yystack;  /* stack new state and value */

	}
