/* rtULib.c - RT-11 file I/O library for UNIX */

static char *copyright = "Copyright 1984-1988, Wind River Systems, Inc.";

/*
modification history
--------------------
*/

/*
This library makes it possible to use rtLib (1) under UNIX.  It provides the
rdSec and wrtSec routines that rtLib (1) uses, and they both go through UNIX.

In order to use these, the fd in the descriptor must refer to a UNIX file
that has been opened.

SEE ALSO: rtLib (1)
*/

/* LINTLIBRARY */

#include "UniWorks.h"
#include "ctype.h"
#include "rtULib.h"


/***********************************************************************
*
* rtURdSec - read a sector from an RT-11 volume
*
* This routine reads the specified sector from the specified volume.
*
* RETURNS: status (OK, ERROR)
*/

STATUS rtURdSec (pRtUDev, secNum, buffer)
    RT_UNIX_DEV *pRtUDev;	/* pointer to volume descriptor */
    FAST int secNum;		/* number of block to read */
    char *buffer;		/* buffer to receive block */

    {
    FAST RT_VOL_DESC *pRtVol = & (pRtUDev->rtvol);

    /* Add a one track offset to the sector number */

    if (pRtVol->vd_rtFmt)
	    secNum += pRtVol->vd_secTrack;

    /* read sector */

    lseek (pRtUDev->fd, (long) (secNum * pRtVol->vd_bytesPerSec), 0);

    if (read (pRtUDev->fd, buffer, pRtVol->vd_bytesPerSec) < OK)
	return (ERROR);

    return (OK);
    }
/***********************************************************************
*
* rtUWrtSec - write a sector to an RT-11 volume
*
* This routine writes the specified sector to the specified volume.
*
* RETURNS: status (OK, ERROR)
*/

STATUS rtUWrtSec (pRtUDev, secNum, buffer)
    RT_UNIX_DEV *pRtUDev;	/* pointer to volume descriptor */
    int secNum;			/* number of sector to write */
    char *buffer;		/* buffer to write to block */

    {
    FAST RT_VOL_DESC *pRtVol = & (pRtUDev->rtvol);

    /* Add a one track offset to the sector number */

    if (pRtVol->vd_rtFmt)
	    secNum += pRtVol->vd_secTrack;

    /* write sector */

    lseek (pRtUDev->fd, (long) (secNum * pRtVol->vd_bytesPerSec), 0);

    if (write (pRtUDev->fd, buffer, pRtVol->vd_bytesPerSec) < OK)
	return (ERROR);

    return (OK);
    }
/*******************************************************************************
*
* iosDevFind - find an I/O device in the device list
*
* This is a dummy version of iosDevFind. It should be in iosULib.c, but that
* doesn't exist.
*
* RETURNS:
*    NULL, always.
*
* ARGSUSED
*/

DEV_HDR *iosDevFind (name, pNameTail)
    char *name;			/* Name of the device */
    char **pNameTail;		/* Where to return ptr to tail of the name */

    {
    return (NULL);
    }
