/* compatHLib.c - compatibility routines for the high sources */

static char *copyright = "Copyright 1988, Integrated Solutions, Inc.";

/*
modification history
--------------------
*/

/*
DESCRIPTION
*/

#include "UniWorks.h"
#include "taskLib.h"
#include "sysSymTbl.h"

/*
 * DESCRIPTION The routines in this file are provided for compatibilty with
 * UniWorks 1.5. 
 */

compatHInit()
{
}
/*******************************************************************************
*
* netGetInetAddr - get the internet address of the host
*
* The "host" may be specified by either its internet address in
* standard internet address format (eg 90.0.0.2), or by its name (its host name)
* which has already been added to the remote host table (with remAddHost).
* 
* RETURNS:
*  internet address (integer form), or
*  ERROR.
*
*/

int 
netGetInetAddr(host)
	char           *host;

{
	FAST int        inetAddr;

	/*
	 * First, look for host, by name, in the host table. If it's not
	 * there, assume the address is in dot notation and convert it to an
	 * integer. 
	 */

	if ((inetAddr = remGetHostByName(host)) == ERROR)
		inetAddr = (int) inet_addr(host);

	return (inetAddr);
}
/*******************************************************************************
*
* remInetAddr - parse and convert an internet address (OBSOLETE!!)
*
* Call the UNIX compatible inet_addr() instead.
*
* RETURNS
*    Internet address (as an int).
*
*/
int 
remInetAddr(cp)
	FAST char      *cp;	/* pointer to internet address in standard
				 * internet format i.e. "90.0.0.4" */

{
	return ((int) inet_addr(cp));
}
/*******************************************************************************
*
* closeSocket - close a socket (obsolete)
*
* This routine exists for backward compatability.  New applications 
* should simply call close(2).
*
* RETURNS: OK | ERROR
*/

STATUS 
closeSocket(sd)
	int             sd;	/* socket descriptor to be closed */

{
	return (close(sd));
}
/*******************************************************************************
*
* printStatus - print the definition of specified error status value
*
*/

VOID 
printStatus(status)
	FAST int        status;	/* status code whose name is to be printed */
{
	printErrno(status);
}

/*******************************************************************************
*
* shellSetOrigIn - set the shell's default input fd
*
*/
VOID shellSetOrigIn(fd)
	int fd;
{
	shellOrigStdSet(STD_IN, fd);
}
/*******************************************************************************
*
* shellSetOrigOut - set the shell's default output fd
*
*/
VOID shellSetOrigOut(fd)
	int fd;
{
	shellOrigStdSet(STD_OUT, fd);
}
/*******************************************************************************
*
* shellSetOrigErr - set the shell's default error fd
*
*/
VOID shellSetOrigErr(fd)
	int fd;
{
	shellOrigStdSet(STD_ERR, fd);
}
