/*
 * Integrated Solutions
 *
 * Created for internal io support only. Global defs are taken from
 * err.c and include only those neccesary for internal io. Routines
 * contained in here were modified so that stdio isn't used.
 */

#include "fio.h"

/*
 * error messages
 */

extern char *f_errlist[];
extern int f_nerr;

/*
 * global definitions
 */

int errno; 		/* SJR added here*/

flag reading;		/*1 if reading,		0 if writing*/
flag external;		/*1 if external io,	0 if internal */
flag sequential;	/*1 if sequential io,	0 if direct*/
flag formatted;		/*1 if formatted io,	0 if unformatted,
				-1 if list directed, -2 if namelist */
char *fmtbuf, *icptr, *icend, *fmtptr;
int (*doed)(),(*doned)();
int (*doend)(),(*donewrec)(),(*dorevert)(),(*dotab)();
int (*putn)();			/*for formatted io*/
int (*getn)(),(*ungetn)();
int recpos;		/*place in current record*/
ftnint recnum;		/* current record number */
int reclen;		/* current record length */
int cursor,scale;
int radix;
ioflag signit,tab,cplus,cblank,elist,errflag,endflag;
flag leof;
struct ioiflg ioiflg_;	/* initialization flags */


/* 
 * The following are globaled so that each fortran module is loaded
 * when UniWorks is made.
 */

fortInit()
{
	asm("	.globl _z_getc");
	asm("	.globl _en_fio");
	asm("	.globl _ecvt");
	asm("	.globl _pars_f");
	asm("	.globl _icvt");
	asm("	.globl _rd_ed");
	asm("	.globl _r_mod");
	asm("	.globl _s_rsfi");
	asm("	.globl _s_cat");
	asm("	.globl _s_cmp");
	asm("	.globl _s_copy");
	asm("	.globl _s_wsfi");
	asm("	.globl _w_ed");
}


f77_abort(err_val)
{
	return(errno=err_val);
}

s_stop()
{
	return;
}

fatal(n,s)
{
	printf("\n");

	if(n<0)
		printf("%s: [%d] end of file\n",s,n);
	else if(n>=F_ER && n<F_MAXERR)
		printf("%s: [%d] %s\n",s,n,f_errlist[n-F_ER]);
	else
		printf("%s: [%d] unknown error number\n",s,n);

	if (elist) {	
		printf("lately: %s %s %s %s I/O\n",
			reading?"reading":"writing",
			sequential?"sequential":"direct",
			formatted>0?"formatted":(formatted==0?"unformatted":
				(formatted==LISTDIRECTED?"list":"namelist")),
			external?"external":"internal");
		if (formatted) {	
			if(fmtbuf) prnt_fmt(n);
			if(!external) prnt_int();/* print internal array */
		}
	}
	f77_abort(n);
}

prnt_int()
{	char *ep;
	printf ("part of last string: ");
	ep = icptr - (recpos<12?recpos:12);
	while (ep<icptr) printf("%c",*ep++);
	printf("|");
	while (ep<(icptr+5) && ep<icend) printf("%c",*ep++);
	printf("\n");
}

LOCAL
prnt_fmt(n) int n;
{	int i; char *ep;
	printf("format: ");
	if(n==F_ERFMT)
	{	i = fmtptr - fmtbuf;
		ep = fmtptr - (i<25?i:25);
		if(ep != fmtbuf) printf("... ");
		i = i + 5;
	}
	else
	{	ep = fmtbuf;
		i = 25;
		fmtptr = fmtbuf - 1;
	}
	while(i && *ep)
	{	printf("%c",(*ep==GLITCH)?'"':*ep);
		if(ep==fmtptr) printf("|");
		ep++; i--;
	}
	if(*ep) printf(" ...");
	printf("\n");
}

