/* wait.h - Unix compatible wait structures for remote debugging support */

/*
modification history
--------------------
01b,17nov87,dnw  removed unnecessary stuff.
*/

#ifndef INCwaith
#define INCwaith

/*
 * If w_stopval==WSTOPPED, then the second structure
 * describes the information returned, else the first.
 */
union wait
    {
    int	w_status;

    /* Terminated process status. */

    struct
	{
	unsigned short	w_Fill1:16;	/* high 16 bits unused */
	unsigned short	w_Retcode:8;	/* exit code if w_termsig==0 */
	unsigned short	w_Coredump:1;	/* core dump indicator */
	unsigned short	w_Termsig:7;	/* termination signal */
	} w_T;

    /* Stopped process status. */

    struct
	{
	unsigned short	w_Fill2:16;	/* high 16 bits unused */
	unsigned short	w_Stopsig:8;	/* signal that stopped us */
	unsigned short	w_Stopval:8;	/* == W_STOPPED if stopped */
	} w_S;
    };
#define	w_termsig	w_T.w_Termsig
#define w_coredump	w_T.w_Coredump
#define w_retcode	w_T.w_Retcode
#define w_stopval	w_S.w_Stopval
#define w_stopsig	w_S.w_Stopsig

#define	WSTOPPED	0177	/* value of s.stopval if process is stopped */

#endif INCwaith
