/* taskLib.h - header for generic kernel interface */

/*
modification history
--------------------
01h,22jun88,dnw  name tweaks.
01g,30may88,dnw  changed to v4 names.
01f,28may88,dnw  deleted obsolete status values.
		 added EXC_INFO to tcbx.
01e,18may88,jcf  added psos semaphore head to tcbx.
		  extended maximum number of hooks to 10.
01d,13may88,rdc  added signal info to tcbx.
01c,28apr88,ecs  added IMPORTs of idle & taskName.
01b,13apr88,gae  added function declarations; option bit VX_STDIO;
		 taskStd[] to TCB extension.
01a,25jan88,jcf  written by extracting from vxLib.h v02l.
*/

#ifndef INCtaskLibh
#define INCtaskLibh

#include "vwModNum.h"
#include "taskVarLib.h"
#include "sigLib.h"
#include "excLib.h"
#include "lstLib.h"

/* generic status codes */

#define S_taskLib_NO_FREE_TASK_ID		(M_taskLib | 101)
#define S_taskLib_NAME_NOT_FOUND		(M_taskLib | 102)
#define S_taskLib_TASK_ID_ERROR			(M_taskLib | 103)
#define S_taskLib_TASK_HOOK_TABLE_FULL		(M_taskLib | 104)
#define S_taskLib_TASK_HOOK_NOT_FOUND		(M_taskLib | 105)
#define S_taskLib_TASK_VAR_NOT_FOUND		(M_taskLib | 106)


/* miscellaneous */

#define MAX_TASK_ARGS	10	/* maximum args passed to task on 'taskSpawn' */

#define VX_MAX_TASK_SWITCH_RTNS	10	/* max number of task switch callout
					 * routines that can be added */

#define VX_MAX_TASK_DELETE_RTNS	10	/* max number of task delete callout
					 * routines that can be added */

#define VX_MAX_TASK_CREATE_RTNS	10	/* max number of task create callout 
					 * routines that can be added */

/* task option bits */

#define VX_SUPERVISOR_MODE 0x01	/* 0 = user mode, 1 = supervisor mode */
#define VX_UNBREAKABLE	   0x02	/* reserved for dbgLib */
#define VX_DEALLOC_STACK   0x04 /* deallocate the stack on task delete */
#define VX_FP_TASK	   0x08 /* 1 = floating-point coprocessor support */
#define VX_STDIO	   0x10 /* 1 = stdioLib support */
#define	VX_PASCAL	   0x20 /* 1 = Pascal support */

/* task control block extension */

typedef struct 			/* TCBX */
    {
    /* entry MUST be first field of TCBX because assembly language task entry
     * code expects it! */
    FUNCPTR entry;		/* original entry point of task */
    int taskId;			/* the taskId for this task */
    char *name;			/* name of task */
    int options;		/* task option bits (see below) */
    int errorStatus;		/* most recent task error status */
    char *topOfStack;		/* maximum top of stack */
    char *botOfStack;		/* bottom of stack */
    char *initialSP;		/* initial stack pointer */
    char *fpContext;		/* ptr to floating-point coprocessor context */
    int taskStd[3];		/* task standard input/output/error */
    NODE semNode;		/* used by psos to keep list of blocked tasks */
    ULONG taskTicks;		/* used by spyLib: total number of ticks */
    ULONG taskIncTicks;		/* used by spyLib: number of ticks in slice */
    TASK_SIGNAL_INFO *signalInfo; /* ptr to signal info for task */
    EXC_INFO excInfo;		/* exception info if task causes exception */
    TASK_VAR *taskVar;		/* ptr to first task variable */
    int spare;			/* unused; available to users */
    } TCBX;

/* task descriptor */

typedef struct 			/* TASK_DESC */
    {
    char *td_name;		/* name of task */
    int td_next;		/* handle on next task */
    int td_priority;		/* task priority */
    int td_id;			/* task id */
    int td_status;		/* task status */
    char *td_sp;		/* stack pointer save */
    char *td_usp;		/* user stack pointer save */
    char *td_spbottom;		/* pointer to bottom of stack */
    int td_delay;		/* delay/timeout ticks */
    FUNCPTR entry;		/* original entry point of task */
    int errorStatus;		/* most recent task error status */
    char *topOfStack;		/* maximum top of stack */
    char *initialSP;		/* initial stack pointer */
    int options;		/* task option bits (see below) */
    } TASK_DESC;


/* function declarations */

IMPORT TCBX *taskTcbX ();	/* get task control block extension */
IMPORT VOID idle ();		/* idle task */
IMPORT char *taskName ();	/* get name associated with a task id */

#endif INCtaskLibh
