/* rtdefs.h - routing header file */

/*
 * Copyright (c) 1987 Wind River Systems, Inc.
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * and the VxWorks Software License Agreement specify the terms and
 * conditions for redistribution.
 *
 *	@(#)defs.h	5.2 (Berkeley) 8/6/85
 */

/*
modification history
--------------------
02a,03apr87,ecs  added header and copyright.
*/

/*
 * Internal data structure definitions for
 * user routing process.  Based on Xerox NS
 * protocol specs with mods relevant to more
 * general addressing scheme.
 */
#include "types.h"
#include "socket.h"

#include "route.h"
#include "in.h"

#include "netdb.h"

#include "trace.h"
#include "interface.h"
#include "rttable.h"

/*
 * When we find any interfaces marked down we rescan the
 * kernel every CHECK_INTERVAL seconds to see if they've
 * come up.
 */
#define	CHECK_INTERVAL	(1*60)

#define	LOOPBACKNET	0x7f000000	/* 127.0.0.0 */
#define equal(a1, a2) \
	(bcmp((caddr_t)(a1), (caddr_t)(a2), sizeof (struct sockaddr)) == 0)
/* XXX
#define	min(a,b)	((a)>(b)?(b):(a))
*/

struct	sockaddr_in addr;	/* address of daemon's socket */

struct	in_addr inet_makeaddr();
int	inet_addr();
char	*malloc();
int	exit();
int	sendmsg();
int	supply();
int	timer();
int	cleanup();
