/* mbuf.h - mbuf header file */

/*
 * Copyright (c) 1987 Wind River Systems, Inc.
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * and the VxWorks Software License Agreement specify the terms and
 * conditions for redistribution.
 *
 *	@(#)mbuf.h	7.1 (Berkeley) 6/4/86
 */

/*
modification history
--------------------
02b,04nov87,dnw  moved mfree and mbstat definitions to uipc_mbuf.c.
02c,28aug87,dnw  removed unnecessary defines.
		 added include of types.h
02b,03apr87,ecs  added header and copyright.
02a,02feb87,jlf  removed ifdef CLEAN
*/

#ifndef INCmbufh
#define INCmbufh

#include "types.h"

/* Constants related to memory allocator. */

#define	MSIZE		128			/* size of an mbuf */

#define	MMINOFF		12			/* mbuf header length */
#define	MTAIL		4
#define	MMAXOFF		(MSIZE-MTAIL)		/* offset where data ends */
#define	MLEN		(MSIZE-MMINOFF-MTAIL)	/* mbuf data length */

#define NUM_MBUFS_TO_EXPAND	8
#define INIT_FREE_MBUFS		32

/* Macros for type conversion */


/* address in mbuf to mbuf head */
#define	dtom(x)		((struct mbuf *)((int)x & ~(MSIZE-1)))

/* mbuf head, to typed data */
#define	mtod(x,t)	((t)((int)(x) + (x)->m_off))

struct mbuf
    {
    struct	mbuf *m_next;		/* next buffer in chain */
    u_long	m_off;			/* offset of data */
    short	m_len;			/* amount of data in this mbuf */
    short	m_type;			/* mbuf type (0 == free) */
    u_char	m_dat[MLEN];		/* data storage */
    struct	mbuf *m_act;		/* link in higher-level mbuf list */
    };

/* mbuf types */
#define	MT_FREE		0	/* should be on free list */
#define	MT_DATA		1	/* dynamic (data) allocation */
#define	MT_HEADER	2	/* packet header */
#define	MT_SOCKET	3	/* socket structure */
#define	MT_PCB		4	/* protocol control block */
#define	MT_RTABLE	5	/* routing tables */
#define	MT_HTABLE	6	/* IMP host tables */
#define	MT_ATABLE	7	/* address resolution tables */
#define	MT_SONAME	8	/* socket name */
#define	MT_ZOMBIE	9	/* zombie proc status */
#define	MT_SOOPTS	10	/* socket options */
#define	MT_FTABLE	11	/* fragment reassembly header */
#define	MT_RIGHTS	12	/* access rights */
#define	MT_IFADDR	13	/* interface address */

/* flags to m_get */
#define	M_DONTWAIT	0
#define	M_WAIT		1

/* flags to m_pgalloc */
#define	MPG_MBUFS	0		/* put new mbufs on free list */
#define	MPG_CLUSTERS	1		/* put new clusters on free list */
#define	MPG_SPACE	2		/* don't free; caller wants space */

/* length to m_copy to copy all */
#define	M_COPYALL	1000000000

/*
 * m_pullup will pull up additional length if convenient;
 * should be enough to hold headers of second-level and higher protocols. 
 */
#define	MPULL_EXTRA	32

#define	MGET(m, i, t) \
	{ int ms = splimp(); \
	  if ((m)=mfree) \
		{ if ((m)->m_type != MT_FREE) panic("mget"); (m)->m_type = t; \
		  mbstat.m_mtypes[MT_FREE]--; mbstat.m_mtypes[t]++; \
		  mfree = (m)->m_next; (m)->m_next = 0; \
		  (m)->m_off = MMINOFF; } \
	  else \
		(m) = m_more(i, t); \
	  splx(ms); }
#define	MFREE(m, n) \
	{ int ms = splimp(); \
	  if ((m)->m_type == MT_FREE) panic("mfree"); \
	  mbstat.m_mtypes[(m)->m_type]--; mbstat.m_mtypes[MT_FREE]++; \
	  (m)->m_type = MT_FREE; \
	  (n) = (m)->m_next; (m)->m_next = mfree; \
	  (m)->m_off = 0; (m)->m_act = 0; mfree = (m); \
	  splx(ms); \
	}

/* Mbuf statistics. */

struct mbstat
    {
    short	m_mbufs;	/* mbufs obtained from page pool */
    short	m_clusters;	/* clusters obtained from page pool */
    short	m_clfree;	/* free clusters */
    short	m_drops;	/* times failed to find space */
    short	m_mtypes[256];	/* type specific mbuf allocations */
    };

extern struct mbstat mbstat;
extern struct mbuf *mfree;

extern struct mbuf *m_get();
extern struct mbuf *m_getclr();
extern struct mbuf *m_free();
extern struct mbuf *m_more();
extern struct mbuf *m_copy();
extern struct mbuf *m_pullup();

#endif
