/* in_var.h - internet interface header file */

/*
 * Copyright (c) 1987 Wind River Systems, Inc.
 * Copyright (c) 1985, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * and the VxWorks Software License Agreement specify the terms and
 * conditions for redistribution.
 *
 *	@(#)in_var.h	7.1 (Berkeley) 6/5/86
 */

/*
modification history
--------------------
02b,04nov87,dnw  removed KERNEL conditionals.
		 moved in_ifaddr definition to in.c.
		 moved ipintrq definition to ip_input.c.
02a,03apr87,ecs  added header and copyright.
*/

#ifndef INCin_varh
#define INCin_varh

/*
 * Interface address, Internet version.  One of these structures
 * is allocated for each interface with an Internet address.
 * The ifaddr structure contains the protocol-independent part
 * of the structure and is assumed to be first.
 */
struct in_ifaddr
    {
    struct	ifaddr ia_ifa;		/* protocol-independent info */
#define	ia_addr	ia_ifa.ifa_addr
#define	ia_broadaddr	ia_ifa.ifa_broadaddr
#define	ia_dstaddr	ia_ifa.ifa_dstaddr
#define	ia_ifp		ia_ifa.ifa_ifp
    u_long	ia_net;			/* network number of interface */
    u_long	ia_netmask;		/* mask of net part */
    u_long	ia_subnet;		/* subnet number, including net */
    u_long	ia_subnetmask;		/* mask of net + subnet */
    struct	in_addr ia_netbroadcast; /* broadcast addr for (logical) net */
    int		ia_flags;
    struct	in_ifaddr *ia_next;	/* next in list of internet addresses */
    };
/*
 * Given a pointer to an in_ifaddr (ifaddr),
 * return a pointer to the addr as a sockadd_in.
 */
#define	IA_SIN(ia) ((struct sockaddr_in *)(&((struct in_ifaddr *)ia)->ia_addr))

/* ia_flags */

#define	IFA_ROUTE	0x01		/* routing entry installed */

extern struct in_ifaddr *in_iaonnetof();

extern struct in_ifaddr *in_ifaddr;
extern struct ifqueue	ipintrq;		/* ip packet input queue */

#endif
