/* if_ring.h - network interface ring header file */

/*
 * Copyright (c) 1987 Wind River Systems, Inc.
 */

/*
modification history
--------------------
02a,03apr87,ecs  added header and copyright.
*/

/*
 * The "ring" data structures.
 *  Contains some number of slots, and read & write indexes thereinto.
 *  Also a size field, specifying the number of slots allocated.
 */
struct ring {
	short		r_rdidx;	/* read index */
	short		r_wrtidx;	/* write index */
	short		r_size;		/* number of slots in ring */
	unsigned char	r_tas;		/* TAS multi-processor interlock flag */
	char		r_pad;		/* alignment pad */
	int		r_slot[1];	/* slots -- actually more than 1 */
};

struct ring32 {
	short		r_rdidx;	/* read index */
	short		r_wrtidx;	/* write index */
	short		r_size;		/* number of slots in ring */
	unsigned char	r_tas;		/* TAS multi-processor interlock flag */
	char		r_pad;		/* alignment pad */
	int		r_slot[32];	/* slots */
};

struct ring256 {
	short		r_rdidx;	/* read index */
	short		r_wrtidx;	/* write index */
	short		r_size;		/* number of slots in ring */
	unsigned char	r_tas;		/* TAS multi-processor interlock flag */
	char		r_pad;		/* alignment pad */
	int		r_slot[256];	/* slots */
};

struct bcb {
	struct bcb	*b_link;
	short		b_stat;
	short		b_len;
	char		*b_addr;
	short		b_msglen;
	short		b_reserved;
};
