/* isiBootLib.h - header for isi-specific auto-boot */

/*
modification history
--------------------
01a,09oct87,jlf  written, by modifying ISI code.
*/

#include "if_ether.h"

typedef struct {
	struct ether_header	bp_eh;		/* standard ethernet header */
	int			bp_pkid;	/* packet id */
	char			bp_cmd;		/* command */
#define	BOOT_CONNECT		0x0
#define	BOOT_OPEN		0x1
#define	BOOT_READ		0x2
#define	BOOT_WRITE		0x3
#define	BOOT_CLOSE		0x4
#define	BOOT_AUTOBOOT		0x5
	int			bp_offset;	/* offset */
	int			bp_len;		/* length */
#define	BOOT_DATACNT		(1024+256+128+32)
	char			bp_data[BOOT_DATACNT];	/* data */
    } BOOT_PACKET;

char *bootstate[] = {
	"WAIT_OPEN",
	"OPENED",
	"ACTIVE",
	"ACTIVE",
	"WAIT_CONNECT",
	"WAIT_CONNECT_A",
};

char *command[] = {
	"CONNECT",
	"OPEN",
	"READ",
	"WRITE",
	"CLOSE",
	"AUTOBOOT",
};
