/* fppLib.h - floating-point coprocessor support library header */

/*
modification history
--------------------
01b,18mar88,gae  boosted FP_STATE_FRAME_SIZE by 32 for MC68882.
01a,12aug87,gae  written.
*/

#ifndef	INCfppLibh
#define	INCfppLibh

#ifndef	ASMLANGUAGE

/* number of fp registers on coprocessor */
#define	FP_NUM_REGS	8

/* maximum size of floating-point coprocessor state frame */
#define FP_STATE_FRAME_SIZE	216

typedef struct	/* DOUBLEX - double extended precision */
    {
    UTINY f[12];
    } DOUBLEX;

typedef struct	/* FP_CONTEXT - floating-point coprocessor state frame */
    {
    int fpcr;					/*			:   4 */
    int fpsr;					/*			:   4 */
    int fpiar;					/*			:   4 */
    DOUBLEX fpx[FP_NUM_REGS];			/* 8 extended doubles	:  96 */
    char stateFrame [FP_STATE_FRAME_SIZE];	/* coprocessor specific : 216 */
						/*	     	  TOTAL	: 326 */
    } FP_CONTEXT;

#else	ASMLANGUAGE

/* FP_CONTEXT structure offsets */

#define	FPCR		0x0	/* OFFSET(FP_CONTEXT, fpcr)		*/
#define	FPX		0xc	/* OFFSET(FP_CONTEXT, fpx[0])		*/
#define	STATEFRAME	0x6c	/* OFFSET(FP_CONTEXT, stateFrame[0])	*/

#endif	ASMLANGUAGE

#endif	INCfppLibh
