/* excLib.h - header for exception library */

/*
modification history
--------------------
01a,28may88,dnw  written
*/

#ifndef INCexcLibh
#define INCexcLibh

/* generic exception information -
 * kept in the tcb of tasks that have caused exceptions */

typedef struct
    {
    USHORT valid;		/* indicators that following fields are valid */
    USHORT vecNum;		/* vector number */
    INSTR *pc;			/* program counter */
    ULONG accessAddr;		/* access address */
    USHORT statusReg;		/* status register */
    USHORT funcCode;		/* func code (or ESF type if EXC_INVALID_TYPE)*/
    USHORT instrReg;		/* instruction register */
    } EXC_INFO;

/* exception info valid bits */

#define EXC_VEC_NUM		0x01	/* vector number valid */
#define EXC_PC			0x02	/* pc valid */
#define EXC_STATUS_REG		0x04	/* status register valid */
#define EXC_ACCESS_ADDR		0x08	/* access address valid */
#define EXC_FUNC_CODE		0x10	/* funcion code valid */
#define EXC_INSTR_REG		0x20	/* instruction register valid */
#define EXC_INVALID_TYPE	0x80	/* special indicator: ESF type was bad;
					 * type is in funcCode field */

#endif
