/* qsreg.h - ISI/Liberator SCSI header */

/*
 * Physical layout of WD33C93 address registers. There is an address register
 * which is write only. Reading that location gives the auxiliary status
 * register. Reading or writing to the wd_data location causes a read or
 * write to the register whose address is held in the address register.
 * The address register increments after each access to the data register
 * unless the register being accessed is the command or data register.
 */
struct qsdevice {
	unsigned char wd_addr_stat;
	unsigned char wd_data;
};

/*
 * Bits in the auxilliary status register
 */
#define	WD_AUX_INT	0x80	/* interrupt pending */
#define	WD_AUX_LCI	0x40	/* last command ignored */
#define	WD_AUX_BSY	0x20	/* level II cmd is being performed */
#define	WD_AUX_CIP	0x10	/* command in progress */
#define	WD_AUX_PE	0x02	/* parity error */
#define	WD_AUX_DBR	0x01	/* data buffer ready */

/*
 * The registers
 *
 * values to be loaded into the address register to access particular registers.
 *
 * Note: that the address register autoincrements after every access to a
 * register other than the address, auxilliary status, data and command
 * registers.
 */

#define	WD_OWNID	0
#define	WD_CONTROL	1
#define	WD_TIMEOUT	2	/* timeout in 8ms increments */
#define	WD_TOTAL_SECTORS	3
#define	WD_TOTAL_HEADS	4
#define	WD_TOT_CYL_MSB	5
#define	WD_TOT_CYL_LSB	6
#define	WD_LOG_ADDR0	7	/* most significant byte of logical address */
#define	WD_LOG_ADDR1	8
#define	WD_LOG_ADDR2	9
#define	WD_LOG_ADDR3	10
#define	WD_SECTOR	11
#define	WD_HEAD		12
#define	WD_CYL_MSB	13
#define	WD_CYL_LSB	14
#define	WD_TARGET	15
#define	WD_CMND_PHASE	16
#define	WD_SYNCHRNS	17
#define	WD_TRANS_COUNT0	18	/* most significant byte of transfer count */
#define	WD_TRANS_COUNT1	19
#define	WD_TRANS_COUNT2	20
#define	WD_DEST_ID	21
#define	WD_SOURCE_ID	22
#define	WD_STATUS	23
#define	WD_COMMAND	24
#define	WD_DATA		25

/* Bits in the destination id register */

#define	DEST_ID_MASK		0x07

/* Bits in the source id register */

#define	SRCID_BRD_MASK		0x07
#define	SRCID_SIV		0x08
#define	SRCID_NO_PRTYCHK	0x20	
#define	SRCID_SEL_ENBL		0x40
#define	SRCID_RESL_ENBL		0x80

/* Bits in the control register.  */

#define	WCNT_DMA	0x80	/* DMA select */
#define	WCNT_WDB	0x40	/* direct bufer access */
#define	WCNT_HA		0x02	/* halt on ATN */
#define	WCNT_HPE	0x01	/* halt on parity error */
		/*
		 * these next few defines only exist in the WD33C9[23]A
		 */
#define	WCNT_BUR	0x20	/* burst mode DMA */
#define	WCNT_HSTPE	0x10	/* halt on host parity error */
#define	WCNT_EDI	0x08	/* ending disconnect interrupt */
#define	WCNT_IDI	0x04	/* intermediate disconnect interrupt */

/* A list of the commands which can be issued to the SCSI controller.  */

#define	WD_CMD_RESET		0x00
#define	WD_CMD_ABORT		0x01
#define	WD_CMD_ASSRT_ATN	0x02
#define	WD_CMD_NEG_ACK		0x03
#define	WD_CMD_DISCONNECT	0x04
#define	WD_CMD_RESELECT		0x05
#define	WD_CMD_SEL_ATN		0x06
#define	WD_CMD_SEL_NOATN	0x07
#define	WD_CMD_SEL_ATN_TRNS	0x08
#define	WD_CMD_SEL_NOATN_TRNS	0x09
#define	WD_CMD_RESEL_RECV	0x0a
#define	WD_CMD_RESEL_SEND	0x0b
#define	WD_CMD_WAIT_SEL_RCV	0x0c
#define	WD_CMD_RCV_CMD		0x10
#define	WD_CMD_RCV_DATA		0x11
#define	WD_CMD_RCV_MSGOUT	0x12
#define	WD_CMD_RCV_UNSPEC_OUT	0x13
#define WD_CMD_SND_STATUS	0x14
#define WD_CMD_SND_DATA		0x15
#define WD_CMD_SND_MSGIN	0x16
#define WD_CMD_SND_UNSPEC_IN	0x17
#define	WD_CMD_TRANS_ADDR	0x18
#define	WD_CMD_TRANS_INFO	0x20
#define	WD_CMD_TRANS_PAD	0x21

#define	WD_CMD_SNGL_BYT	0x80	/* single byte transfer bit which gets or'ed in
				 * with the above transfer commands.
				 */

/* MCI (MSG C/D I/O) definitions */

#define	PHS_DATA_OUT		0x0
#define	PHS_DATA_IN		0x1
#define	PHS_COMMAND		0x2
#define	PHS_STATUS		0x3
#define	PHS_UNSPEC_OUT		0x4
#define	PHS_UNSPEC_IN		0x5
#define	PHS_MSG_OUT		0x6
#define	PHS_MSG_IN		0x7

#define	PHS_MASK		7

#define	PHS_IO		0x1
#define	PHS_CD		0x2
#define	PHS_MSG		0x4

/* Bits in the scsi status register */

#define WDST_GRP_MASK		0xf0

#define	WDST_RESET		0x00

/* scsi status group 1 - successful completion */

#define	WDST_COMPLETE		0x10

#define WDST_RESEL_CMPLT	0x10	/* reselect command completed */
#define WDST_SEL_CMPLT		0x11	/* select command completed */
			/* 
			 * For the next 2 - a receive,send,reselect and
			 * transfer, or wait-for select-and-recieve completed
			 */
#define	WDST_RCV_SND_NOATN_CMPLT 0x13	
#define	WDST_RCV_SND_ATN_CMPLT	0x14
#define	WDST_TRANS_ADDR_CMPLT	0x15	/* translate address cmd completed */
#define	WDST_SEL_AND_TRNS_CMPLT	0x16	/* select and transfer completed */

#define WDST_TRANS_CMPLT_DATA_OUT	0x18	
#define WDST_TRANS_CMPLT_DATA_IN	0x19	
#define WDST_TRANS_CMPLT_COMMAND	0x1a	
#define WDST_TRANS_CMPLT_STATUS		0x1b	
#define WDST_TRANS_CMPLT_RES_OUT	0x1c	
#define WDST_TRANS_CMPLT_RES_IN		0x1d	
#define WDST_TRANS_CMPLT_MSG_OUT	0x1e	
#define WDST_TRANS_CMPLT_MSG_IN		0x1f	

/* scsi status group 2 - command paused or aborted */

#define	WDST_PAUSE_ABORT	0x20

#define	WDST_MSG_IN_PAUSE	0x20	/* transfer paused with ACK */
#define	WDST_SEL_TRANS_ABORT	0x21	/* select and transfer aborted */
#define	WDST_SEL_RESEL_ABORT	0x22	/* a select or reselect aborted */
#define	WDST_RCV_SND_NOATN_ABORT 0x23	/* receive or send w/o ATN aborted */
#define	WDST_RCV_SND_ATN_ABORT	0x24	/* receive or send with ATN aborted */
#define WDST_TRANS_ABORT	0x28	/* check MCI bits for phase */

#define WDST_TRANS_ABORT_DATA_OUT	0x28	
#define WDST_TRANS_ABORT_DATA_IN	0x29	
#define WDST_TRANS_ABORT_COMMAND	0x2a	
#define WDST_TRANS_ABORT_STATUS		0x2b	
#define WDST_TRANS_ABORT_RES_OUT	0x2c	
#define WDST_TRANS_ABORT_RES_IN		0x2d	
#define WDST_TRANS_ABORT_MSG_OUT	0x2e	
#define WDST_TRANS_ABORT_MSG_IN		0x2f	

/* scsi status group 3 - command terminated */

#define WDST_TERMINATED		0x40	

#define	WDST_INVALID_CMD_TERM	0x40	/* invalid command issued */
#define	WDST_DISCONN_CMD_TERM	0x41	/* unexpected dissconnect */
#define	WDST_TIMEOUT_CMD_TERM	0x42	/* timeout during sel or resel */
#define	WDST_PE_NOATN_CMD_TERM	0x43	/* parity error - w/o ATN */
#define	WDST_PE_ATN_CMD_TERM	0x44	/* parity error - with ATN */
#define	WDST_BAD_ADDR_CMD_TERM	0x45	/* bad logical address */
#define WDST_BAD_TARG_RESEL_TERM 0x46	/* wrong target device reselected */
#define	WDST_BAD_BYTE_TERM	0x47	/* bad msg, status or cmd byte rcved */
#define	WDST_BAD_INFO_PHASE_TERM 0x48	/* check MCI bits for phase */

#define WDST_BAD_IPHS_DATA_OUT	0x48	
#define WDST_BAD_IPHS_DATA_IN	0x49	
#define WDST_BAD_IPHS_COMMAND	0x4a	
#define WDST_BAD_IPHS_STATUS	0x4b	
#define WDST_BAD_IPHS_RES_OUT	0x4c	
#define WDST_BAD_IPHS_RES_IN	0x4d	
#define WDST_BAD_IPHS_MSG_OUT	0x4e	
#define WDST_BAD_IPHS_MSG_IN	0x4f	

/* scsi status group 4 - service required */

#define WDST_SERVICE		0x80

#define	WDST_RESEL_SERV		0x80	/* reselected */
#define	WDST_SEL_NOATN_SERV	0x82	/* selected w/o ATN */
#define	WDST_SEL_ATN_SERV	0x83	/* selected with ATN */
#define	WDST_ATN_SERV		0x84	/* ATN asserted */
#define	WDST_DISCONN_SERV	0x85	/* disconnect occured */

#define WDST_REQ_SERV_DATA_OUT	0x88	
#define WDST_REQ_SERV_DATA_IN	0x89	
#define WDST_REQ_SERV_COMMAND	0x8a	
#define WDST_REQ_SERV_STATUS	0x8b	
#define WDST_REQ_SERV_RES_OUT	0x8c	
#define WDST_REQ_SERV_RES_IN	0x8d	
#define WDST_REQ_SERV_MSG_OUT	0x8e	
#define WDST_REQ_SERV_MSG_IN	0x8f	

