
/* Torch Computers Ltd. SCCS id @(#) openscsi.h 1.1@(#) */
struct lunelem {
	struct scsi_cmnd *l_cmndptr;
	char l_state;
	char l_flags;
	char l_sync_trans;
	char l_identify;
};

/*
 * states. Alterable by the TDMAC.
 */
#define	L_ST_NULL	0
#define	L_ST_PENDING	1

/*
 * flags. Alterable by the MPU. The lowest 3 bits encode the
 * destination ID. If L_FL_CHK_PARITY is used it must be used
 * for all LUNs on the controller card.
 */
#define	L_FL_DESTMASK	0x07
#define	L_FL_SEL_ATN	0x08
#define	L_FL_CHK_PARITY	0x10
#define	L_FL_MANUAL	0x20



#define	LEN_STATUS	2


struct scsi_cmnd {
	struct sc_link sc_datlnk;	/* saved data pointer */
	struct sc_link sc_dat3lnk;	/* after each data transfer phase the
					 * current data pointer gets copied here
					 */
	char *sc_pcmnd;	/* pointer to command bytes */
	char *sc_pstat;	/* pointer to status bytes */
	char sc_ncmnd;	/* number of command bytes */
	char sc_nstat;	/* number of status bytes */
	char sc_finstat;	/* end status */
	char sc_pad;
	struct scsi_cmnd *sc_chain;
	struct lunelem *sc_ptrlun;
		/*
		 * All fields before this point are used by the Openchip.
		 * When the command is passed to scissue(), sc_dat2lnk should
		 * have been set up. scissue() will copy it into sc_datlnk and
		 * sc_dat3lnk each time the command has to be sent (multiple
		 * issuings are the result of a received BUSY response).
		 */
	char sc_status[LEN_STATUS];
	struct sc_link sc_dat2lnk;
	struct scsiproto *sc_proto;
	long sc_cmndlngth;	/* length of data transfer for the command */
	long sc_rqsnslngth;	/* length of data transfer for request sense */
	short sc_flags;
	char sc_retries;	/* maximum number of times to issue command */
};

/*
 * Note that the values taken by the sc_finstat and sc_flags fields are the
 * same values used by the sp_finstat and sp_flags fields of a scsiproto
 * structure.
 */
