/* i208.h - header file for the intel 208 floppy disk controller bd. */

/*
modification history
--------------------
01h,08jan87,jlf  added ifndef's to keep from being included twice.
01g,11mar86,dnw  added ST3 bit definitions.
01f,27aug85,gae  added FM and MFM modes.
01e,18jul85,jlf  fixed names (more significant chars).
01d,23jul84,ecs  brought definition of IO_208 here from hwConfig.h.
01c,02aug83,dnw  removed I208_BASE, now IO_208 in ioLib.h.
01b,06jun83,dnw  added status register 0 definitions (ST0).
01a,24mar83,jlf  written
*/

#ifndef INCi208h
#define INCi208h	1

/* IO port addresses */

#define IO_208			((char *) 0xef0080)	/* 0x30 bytes */

#define I208_DMA0_ADR		(IO_208 + 0x00) 
#define I208_DMA0_CNT		(IO_208 + 0x01)
#define I208_DMA2_ADR		(IO_208 + 0x04)
#define I208_DMA2_CNT		(IO_208 + 0x05)
#define I208_DMA3_ADR		(IO_208 + 0x06)
#define I208_DMA3_CNT		(IO_208 + 0x07)
#define I208_DMA_CMND		(IO_208 + 0x08)
#define I208_DMA_REQ		(IO_208 + 0x09)
#define I208_DMA_SR_MASK	(IO_208 + 0x0a)
#define I208_DMA_MODE		(IO_208 + 0x0b)
#define I208_DMA_FL		(IO_208 + 0x0c)
#define I208_DMA_RESET		(IO_208 + 0x0d)
#define I208_DMA_LD_MASK	(IO_208 + 0x0f)
#define I208_FDC_STAT		(IO_208 + 0x10)
#define I208_FDC_DATA		(IO_208 + 0x11)
#define I208_AUX		(IO_208 + 0x12)
#define I208_POLL_STAT		(IO_208 + 0x12)
#define I208_RESET		(IO_208 + 0x13)
#define I208_LSB_SEG_ADR	(IO_208 + 0x14)
#define I208_MSB_SEG_ADR	(IO_208 + 0x15)

/* Bit values to write to DMAC. All other bits must be 0. */

#define I208_DMA_C_ROT_PRI	0x10		/* Rotating priority if 1 */
#define I208_DMA_C_DISABLE	0x04		/* disable DMA if 1 */

/* Bit values for DMA status */

#define I208_DMA_S_REQ3		0x80		/* Channel 3 DMA req */
#define I208_DMA_S_REQ2		0x40		/* Channel 2 req */
#define I208_DMA_S_REQ0		0x10		/* Channel 0 req */
#define I208_DMA_S_TC3		0x08		/* Channel 3 terminal cnt */
#define I208_DMA_S_TC2		0x04		/* Channel 2 terminal cnt */
#define I208_DMA_S_TC0		0x01		/* Channel 0 terminal cnt */

/* Bit values to write to DMA request reg */

#define I208_DMA_R_SET		0x04		/* Set request bit */
#define I208_DMA_R_RST		0x00		/* Reset request bit */
#define I208_DMA_R_C0		0x00		/* Select channel 0 */
#define I208_DMA_R_C1		0x01		/* Select channel 1 */
#define I208_DMA_R_C2		0x02		/* Select channel 2 */
#define I208_DMA_R_C3		0x03		/* Select channel 3 */

/* Bit values to write to DMA Set/Reset mask reg */

#define I208_DMA_MS_SET		0x04		/* Set mask bit */
#define I208_DMA_MS_RST		0x00		/* Reset mask bit */
#define I208_DMA_MS_C0		0x00		/* Select channel 0 */
#define I208_DMA_MS_C1		0x01		/* Select channel 1 */
#define I208_DMA_MS_C2		0x02		/* Select channel 2 */
#define I208_DMA_MS_C3		0x03		/* Select channel 3 */

/* Bit values to write to DMA load mask reg. */

#define I208_DMA_ML_S0		0x01		/* Set channel 0 mask bit */
#define I208_DMA_ML_S1		0x02		/* Set channel 1 mask bit */
#define I208_DMA_ML_S2		0x04		/* Set channel 2 mask bit */
#define I208_DMA_ML_S3		0x08		/* Set channel 3 mask bit */

/* Bit values to write to DMA Mode reg */

#define I208_DMA_M_BLOCK	0x80		/* Block mode */
#define I208_DMA_M_SINGLE	0x40		/* Single mode */
#define I208_DMA_M_DEMAND	0x00		/* Demand mode */
#define I208_DMA_M_INC		0x00		/* Address increment */
#define I208_DMA_M_DEC		0x20		/* Address decrement */
#define I208_DMA_M_AUTO_EN	0x10		/* Autoinitialize enable */
#define I208_DMA_M_VERIFY	0x00		/* Verify transfer */
#define I208_DMA_M_WRITE	0x04		/* Write transfer */
#define I208_DMA_M_READ		0x08		/* Read transfer */
#define I208_DMA_M_C0		0x00		/* Select channel 0 */
#define I208_DMA_M_C1		0x01		/* Select channel 1 */
#define I208_DMA_M_C2		0x02		/* Select channel 2 */
#define I208_DMA_M_C3		0x03		/* Select channel 3 */

/* Bit values read from FDC status reg */

#define I208_FDC_S_RQM		0x80		/* Request for master */
#define I208_FDC_S_DIO		0x40		/* Data IO */
#define I208_FDC_S_NON_DMA	0x20		/* Non-dma mode */
#define I208_FDC_S_BUSY		0x10		/* FDC busy */
#define I208_FDC_S_3BUSY	0x08		/* FDD 3 busy */
#define I208_FDC_S_2BUSY	0x04		/* FDD 2 busy */
#define I208_FDC_S_1BUSY	0x02		/* FDD 1 busy */
#define I208_FDC_S_0BUSY	0x01		/* FDD 0 busy */

/* Bits read from poll status byte */

#define I208_P_1		0x01		/* Controller interrupt */

/* Commands to the FDC chip */

#define I208_FDC_C_FM		0x00
#define I208_FDC_C_MFM		0x40

#define I208_FDC_C_SPECIFY	0x03
#define I208_FDC_C_SEEK		0x0f
#define I208_FDC_C_RD		0x06
#define I208_FDC_C_RD_DEL	0x0c
#define I208_FDC_C_RD_ID	0x0a
#define I208_FDC_C_RD_TRACK	0x02
#define I208_FDC_C_WT		0x05
#define I208_FDC_C_WT_DEL	0x09
#define I208_FDC_C_FORMAT	0x0d
#define I208_FDC_C_RECALIBRATE	0x07
#define I208_FDC_C_SN_DRIVE	0x04
#define I208_FDC_C_SN_INT	0x08

/* status register 0 definitions */

#define ST0			0	/* index in result data of st0 */

#define ST0_INTCODE		0xc0	/* interrupt reason code */

#define ST0_IC_ERROR		0x40	/* abnormal command termination */
#define ST0_IC_INVALIDCOMMAND	0x80	/* invalid command phase */
#define ST0_IC_READYCHANGE	0xc0	/* drive changed ready state */

/* status register 3 definitions */

#define ST3_FAULT		0x80	/* fault signal from drive */
#define ST3_WRT_PROTECT		0x40	/* write protected */
#define ST3_READY		0x20	/* ready signal from drive */
#define ST3_TRACK_0		0x10	/* track 0 signal from drive */
#define ST3_TWO_SIDED		0x08	/* two sided signal from drive */
#define ST3_HEAD		0x04	/* side signal from drive */
#define ST3_UNIT		0x03	/* drive number */

#endif
