/* cdbLib.h - header file for cdbLib */

/*
Modification History
--------------------
01a,02apr87,jlf  written
*/

/* message format for messages written to cdbPipe */

typedef union
    {
    int request;

    struct
	{
	int request;
	int pid;	/* process id */
	char *addr;	/* address of bp */
	} breakPoint;

    struct
	{
	int request;
	int pid;	/* process id */
	char *addr;	/* address of task (not needed) */
	} taskDeleted;

    struct
	{
	int request;
	int pid;	/* process id */
	char *addr;	/* start address of task */
	} taskCreated;

    struct
	{
	int request;
	char *cmd;	/* cdb request and params */
	} cdbCommand;

    struct
	{
	int request;
	int pid;	/* process id */
    	int (*sendInfo)();
	} newFile;

    } CDB_MSG;

#ifdef	is68k
#define inameNil -1
#endif	is68k

/* constants for request field */

#define MSG_BREAKPOINT 0
#define MSG_CDB_COMMAND 1
#define MSG_TASK_DELETED 2
#define MSG_TASK_CREATED 3
#define MSG_NEWFILE 4

/* nodes for the cdb task lists  (used in cdbSpawnList and cdbWaitList) */

typedef struct
    {
    NODE pointers;
    int taskId;
    char *addr;
    int cdbState;
    int (*sendInfo)();	/* hook for additional info */
    } TASK_NODE;

/* constants for cdbState field */

#define CDB_BREAK	MSG_BREAKPOINT
#define CDB_DELETED	MSG_TASK_DELETED 
#define CDB_CREATED	MSG_TASK_CREATED
#define CDB_NEWFILE	MSG_NEWFILE
#define CDB_INTERRUPTED	SIGINT
