/* demo.c - a program to demonstrate multitasking under UniWorks */

static char *copyright = "Copyright 1988, Wind River Systems, Inc.";

/*
modification history
--------------------
*/

/*
DESCRIPTION
This routine prints its task id and name and its startup parameter.
Is is for demonstration purposes.  It may be spawned, run
periodically, or called directly from the shell.

EXAMPLE
The following is an example from the UniWorks shell:

    -> ld 1 <demo.o  
    value = 0 = 0x0
    -> demo
    Hello from task 0x3d6cac (shell). Startup parameter was 0.
    value = 2 = 0x2
    -> sp demo, $10
    task spawned: id = 0x3c96d8, name = 1
    value = 3970776 = 0x3c96d8
    -> Hello from task 0x3c96d8 (1). Startup parameter was 16.

    -> repeat 4, demo, $a        
    task spawned: id = 0x3c96d8, name = 2
    value = 0 = 0x0
    -> Hello from task 0x3c96d8 (2). Startup parameter was 10.
    Hello from task 0x3c96d8 (2). Startup parameter was 10.    
    Hello from task 0x3c96d8 (2). Startup parameter was 10.
    Hello from task 0x3c96d8 (2). Startup parameter was 10.
    ->

SEE ALSO: "Getting Started"
*/

#include "UniWorks.h"

/*******************************************************************************
*
* demo - a simple demo routine
*
* This routine prints its task id and name and startup parameter.
*/

VOID demo (param)
    int param;

    {
    /* find out what task we are, and print message */

    printf ("Hello from task %#x (%s). Startup parameter was %d.\n",
	    taskIdSelf (), taskName (taskIdSelf()), param);
    }
