/* vme68k30.h - header file for Integrated Solutions VME-68k30 CPU board */

/*
modification history
--------------------
01e,17nov87,dnw		definitions of int vectors to config.h.
01d,20oct86,jlf 	added constants for usart timer.
01c,05mar86,llk+rdc	written.
*/

/*
This file contains IO address and related constants for the Integrated
Solutions CPU board.
*/

/* information for OCTART */

#define N_USART_CHANNELS	8		/* Number of serial channels */
#define N_USART_BLOCKS		4		/* Number of register blocks */

#define OCTART_ADDR	0xc0000000	/* Address of OCTART */

/* Bit values for options selected by MR1 of the OCTART */

#define	VME_U_NO_PAR	0x10
#define	VME_U_8_BITS	0x03

/* Bit values for options selected by MR2 of the OCTART */

#define	VME_U_1_STOP	0x07

/* Bit values for options selected by CR of the OCTART */

#define	VME_U_MR_RST	0x10
#define	VME_U_RX_RST	0x20
#define	VME_U_TX_RST	0x30
#define	VME_U_ERR_RST	0x40
#define	VME_U_BRK_RST	0x50	
#define	VME_U_TX_EN	0x04
#define	VME_U_TX_DIS	0x08
#define	VME_U_RX_EN	0x01
#define	VME_U_RX_DIS	0x02

/* bits for the status register (SR) or the octart */

#define VME_U_TX_RDY	0x04

/* Bit values for options selected by CSR of the OCTART */

#define	VME_U_RX_9600	0xB0
#define	VME_U_TX_9600	0x0B
#define	VME_U_RX_1200	0x60
#define	VME_U_TX_1200	0x06

/* bits and commands in the OCTART ACR reg */

#define VME_U_ACR_BRG_SEL	0x80		/* select BRG freq */
#define VME_U_ACR_CTR_EXT	0x00		/* counter-mode, extern clock */
#define VME_U_ACR_CTR_TXCA	0x10		/* counter-mode, Tx clock A */
#define VME_U_ACR_CTR_TXCB	0x20		/* counter-mode, Tx clock B */
#define VME_U_ACR_CTR_XTAL	0x30		/* counter-mode, xtal */
#define VME_U_ACR_TMR_EXT	0x40		/* timer-mode, extern clock */
#define VME_U_ACR_TMR_EXT_16	0x50		/* timer-mode, extern / 16 */
#define VME_U_ACR_TMR_XTAL	0x60		/* timer-mode, xtal */
#define VME_U_ACR_TMR_XTAL_16	0x70		/* timer-mode, xtal / 16 */

/* Bit values for options selected by IMR of the OCTART */

#define	VME_U_INT_RXA		0x02
#define	VME_U_INT_TXA		0x01
#define	VME_U_INT_RXB		0x20
#define	VME_U_INT_TXB		0x10
#define	VME_U_INT_TIMER		0x08

/* Addresses of the IMR's */

#define VME_U_IMRA	 0xc0000005
#define VME_U_IMRB	 0xc0000015
#define VME_U_IMRC	 0xc0000025
#define VME_U_IMRD	 0xc0000035

/* bits and commands in the OCTART OPCR reg */

#define VME_U_OPCR_MOPA_CTO	0x01		/* output port A = clk/timer */

/* input ports on the OCTART */

#define VME_U_IP0		 0xc000000D
#define VME_U_IP1		 0xc000001D
#define VME_U_IP2		 0xc000002D
#define VME_U_IP3		 0xc000003D

/* addresses of the register sets for the serial ports */

#define VME_U_CH0_ADDR		0xc0000000
#define VME_U_CH1_ADDR		0xc0000008
#define VME_U_CH2_ADDR		0xc0000010
#define VME_U_CH3_ADDR		0xc0000018
#define VME_U_CH4_ADDR		0xc0000020
#define VME_U_CH5_ADDR		0xc0000028
#define VME_U_CH6_ADDR		0xc0000030
#define VME_U_CH7_ADDR		0xc0000038

/* addresses of sys clk registers */

#define SYS_CLK_ACR	 0xc0000004	/* addr of sys clk acr*/
#define SYS_CLK_OPCR	 0xc000000D	/* addr of sys clk opcr*/
#define SYS_CLK_CTU	 0xc0000006
#define SYS_CLK_CTL	 0xc0000007
#define SYS_CLK_START	 0xc000000E
#define SYS_CLK_STOP	 0xc000000F
#define SYS_CLK_BLK	0

/* addresses of aux clk registers */

#define AUX_CLK_ACR	 0xc0000014	/* addr of sys clk acr*/
#define AUX_CLK_OPCR	 0xc000001D	/* addr of sys clk opcr*/
#define AUX_CLK_CTU	 0xc0000016
#define AUX_CLK_CTL	 0xc0000017
#define AUX_CLK_START	 0xc000001E
#define AUX_CLK_STOP	 0xc000001F
#define AUX_CLK_BLK	1

/* modes for counter/timers */

#define	MODE_FREERUN	1	/* start counter and let it run */
#define	MODE_TIMER	2	/* like sysClk */
#define	MODE_COUNTER	3	/* like auxClk */
#define	MODE_NONE	0
#define	MAX_MODES	3

#define NCTS		2
#define CT1		0	/* counter/timer 1 */
#define CT2		1	/* counter/timer 2 */


/* CPU on-board control register */

#define SCR_ADDR      	0xD0000000 	/* system control register */
#define	SCR_SOFT_TRAP	0x0001		/* enable software trap */
#define	SCR_INTR_ENAB	0x0002		/* enable interrupt */
#define SCR_VME_INT_ENAB 0x0004		/* enable VME interrupt */
#define	SCR_VME_RESET	0x0008		/* generate VME reset */
#define	SCR_CACHE_CLEAR	0x0010		/* flush cache */
#define	SCR_PROM_DISAB	0x0020		/* disable phantom prom */
#define	SCR_FPU_USE	0x0040		/* enable fpu */
#define	SCR_VME_SYSFAIL	0x0080		/* assert VME sysfail */
#define	SCR_CACHE_ENAB	0x0100		/* external cache enable */
#define	SCR_LED_3	0x0800		/* led 3 */
#define	SCR_LED_2	0x1000		/* led 2 */
#define	SCR_LED_1	0x2000		/* led 1 */
#define	SCR_LEDS	0x3800		/* turn off all leds */
#define	SCR_LED_OFF	0x3800		/* turn off all leds */

/* memory management stuff */

#define VME_PAGE_SIZE		0x1000

#define MEM_DUP_MAP     	0x20000000
#define	PROM_RESET_REBOOT	0x0C

/* cache instructions */

#define CACHE_ON        ICACHE_CLEAR|ICACHE_ENABLE|DCACHE_CLEAR|DCACHE_ENABLE|DCACHE_WA
#define CACHE_OFF       ICACHE_CLEAR|DCACHE_CLEAR

#define ICACHE_ENABLE   0x01
#define ICACHE_FREEZE   0x02
#define ICACHE_CE       0x04
#define ICACHE_CLEAR    0x08
#define ICACHE_BURST    0x10
#define DCACHE_ENABLE   0x0100
#define DCACHE_FREEZE   0x0200
#define DCACHE_CE       0x0400
#define DCACHE_CLEAR    0x0800
#define DCACHE_BURST    0x1000
#define DCACHE_WA       0x2000

/* nvram constants */
/* user nvram space is available between 0xc8000000 and 0xc8000700 */

#define	NVRAM_ADDR	0xC8000000	/* NonVolatile Ram address*/
#define NVRAM_USER_MAX	0x700		/* size of user nvram space */
#define	NVRAM_RESET_ADDR 0x08000000	/* NonVolatile Ram RESET address*/
#define	NVRAM_YEAR	(NVRAM_ADDR+0x7FF)	/* year counter */
#define	NVRAM_MONTH	(NVRAM_ADDR+0x7FE)	/* month counter */ 
#define	NVRAM_DATE	(NVRAM_ADDR+0x7FD)	/* date counter */ 
#define	NVRAM_DAY	(NVRAM_ADDR+0x7FC)	/* day counter */ 
#define	NVRAM_HOUR	(NVRAM_ADDR+0x7FB)	/* hour counter */ 
#define	NVRAM_MINUTE	(NVRAM_ADDR+0x7FA)	/* minute counter */ 
#define	NVRAM_SECOND	(NVRAM_ADDR+0x7F9)	/* second counter */ 
#define	NVRAM_CONTROL	(NVRAM_ADDR+0x7F8)	/* control register */ 
#define	NVRAM_RESET_COUNTER	(NVRAM_ADDR+0x7F4) /* reset counter */ 
#define	NVRAM_BOOT_ARGSIZE	80 		/* size of boot arg */ 
#define	NVRAM_BOOT_ARG	(NVRAM_RESET_COUNTER-NVRAM_BOOT_ARGSIZE)
#define	NVRAM_READ	0x40			/* read command */
#define NVRAM_WRITE	0x80			/* write command */

/* vbmatm constants */

#define VBMATM_REG      0xE0000000      /* VBMATM map registers */

/* VBMATM slot assignment */
#define VBM_SHORT_SLOT  0
#define VBM_STD16_SLOT    1
#define VBM_EXT_SLOT    2
#define VBM_STD32_SLOT    3
#define VBM_SLOTS       16              /* number of VBMATM slots */
#define VBM_AM_SHORT    0x2D            /* short io address modifier */
#define VBM_AM_STD      0x3D            /* standard address modifier */
#define VBM_AM_EXT      0x0D            /* extended address modifier */
#define VBM_PORT_16     1               /* 16 bit port size */
#define VBM_PORT_32     0               /* 32 bit port size */

#ifndef VME_SHORTIO
#define VME_SHORTIO     0x80000000      /* VBMATM(0) VME shortio address */
#define VME_STANDARD_16 0x88000000      /* VBMATM(1) VME standard address 16 */
#define VME_EXTENDED    0x90000000      /* VBMATM(2) VME extended address */
#define VME_STANDARD_32 0x98000000      /* VBMATM(3) VME standard address 32 */
#define VME_STANDARD	VME_STANDARD_16
#endif

#define VBM_BASE(x)     ((unsigned)(((x)<<27)|(0x80000000)))

