
/***************************************************************************
                      Copyright (C) 1990-2000 Kev
****************************************************************************
 Author: Kev                                              Issue: Version 2.0

****************************************************************************
	                        Revision history:
****************************************************************************

		Rev 1.00		October 1992		Kev
		(1)		First writting

		Rev 2.00		December 1998		Kev
		(1)		Added improved variable argument interpretation for Cprintf.
		(2)		Added support for last typed command buffer.
		(3)		Used arrow keys to allow single line editting. 
		
		Rev 3.00.00	1-June-1999			Kev
		(1)		Adapted to TBIOS transputer array.
****************************************************************************/

#ifndef	TERMINAL_INCLUDED
#define	TERMINAL_INCLUDED

#define	MAX_COMMANDS			20	/* Length of history record kept from command line */
#define	COMMAND_BUFFER_SIZE		60	/* Length of each history record */

/**** Define the allocation of the serial ports ****/

#define	SCC_PPP			1			/* This defines the PPP internet port */
#define	SCC_DEBUG		3			/* This defines the console port attached to a terminal */


/**** This structure is used to buffer just entered commands ****/

typedef struct
{
	int		Enabled;				/* Flasg that command buffer can be used */
	int		Max;					/* Indicates the number of buffers allocated */
	int		Ptr;					/* Point to the next available buffer to use */
	char *	Buffer[MAX_COMMANDS];	/* Point to buffers that holds previous cmds */
} HistoryBufType;


/**** Define functions local to this module ****/

extern          void	Ccls( void );
extern	        void	Cnewline( void );
extern	         int	Cquestion( void );
extern          void	Cputc( char );
extern          char	Cgetc( void );
extern	        char *	Cgets( void );
extern           int	CgetcStatus( void );
extern          char *	Cputs( char * );
extern	        void	CputsPoll( char * ptr );
extern          char *	Cprintf( char *, ... );
extern	        void	CenterText( char * string );
extern	         int	Cbold( void );
extern	         int	Cnormal( void );
extern	         int	Cblink( void );
extern	         int	Cunderline( void );
extern	        void	Cxycursor( int, int );
extern	        void	MemDump( char *, int );


#endif

/*******************************  EOF  **************************************/



