#ifndef _PARAMS
#if defined(__STDC__) || defined(__cplusplus)
#define _PARAMS(ARGS) ARGS
#else
#define _PARAMS(ARGS) ()
#endif
#endif /* _PARAMS */
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:systm.h 12.0$ */
/* $ACIS:systm.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/h/RCS/systm.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidsystm = "$Header:systm.h 12.0$";
#endif

#if !defined(KERNEL) && !defined(STANDALONE)
#include <sys/nfs_defines.h>
#endif

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)systm.h	7.1 (Berkeley) 6/4/86
 */

/*
 * Random set of variables
 * used by more than one
 * routine.
 */
int	hand;			/* current index into coremap used by daemon */
extern	char version[];		/* system version */

/*
 * Nblkdev is the number of entries
 * (rows) in the block switch. It is
 * set in binit/bio.c by making
 * a pass over the switch.
 * Used in bounds checking on major
 * device numbers.
 */
int	nblkdev;

/*
 * Number of character switch entries.
 * Set by cinit/prim.c
 */
int	nchrdev;

int	nswdev;			/* number of swap devices */
int	mpid;			/* generic for unique process id's */
char	runin;			/* scheduling flag */
char	runout;			/* scheduling flag */
int	runrun;			/* scheduling flag */
char	kmapwnt;		/* kernel map want flag */
char	curpri;			/* more scheduling */

int	maxmem;			/* actual max memory per process */
int	physmem;		/* physical memory on this CPU */
#ifdef ibm032
int	endmem;			/* physical end of memory */
int	holestart;		/* start of hole in address space */
int	holelength;		/* length of hole in address space */
/* ishole is true if page is inside memory hole */
#define ishole(v) ((v) >= holestart && (v) < holestart+holelength)
#endif

int	nswap;			/* size of swap space */
int	updlock;		/* lock for sync */
daddr_t	rablock;		/* block to be read ahead */
int	rasize;			/* size of block in rablock */
extern	int intstack[];		/* stack for interrupts */
dev_t	rootdev;		/* device of the root */
#ifdef VFS
struct vnode *rootvp;		/* vnode of root filesystem */ 
#endif
dev_t	dumpdev;		/* device to take dumps on */
long	dumplo;			/* offset into dumpdev */
dev_t	swapdev;		/* swapping device */
dev_t	argdev;			/* device for argument lists */
#ifdef VFS
struct vnode	*swapdev_vp;	/* vnode equivalent to above */
struct vnode	*argdev_vp;	/* vnode equivalent to above */
#endif

#ifdef __vax__
extern  int icode[];		/* user init code */
extern  int szicode;		/* its size */
#endif
#ifdef ibm032
extern  short icode[];		/* user init code */
extern  int szicode;		/* its size */
#endif

daddr_t	bmap();
caddr_t	calloc _PARAMS((__SIZE_TYPE__ , __SIZE_TYPE__ ));
unsigned max();
unsigned min();
int	memall();
#ifdef VFS
int	uchar(), schar();
#endif
int	vmemall();
caddr_t	wmemall();
swblk_t	vtod();

#ifdef VFS
/*struct vnode	*devtovp(); */
struct vnode	*bdevvp();	/* Added for specfs routines */ 
struct vnode	*specvp();	/* Added for nfs_vnodeops.c routine */ 
#endif

/*
 * Structure of the system-entry table
 */
extern struct sysent
{
	int	sy_narg;		/* total number of arguments */
	int	(*sy_call)();		/* handler */
} sysent[];

int	noproc;			/* no one is running just now */
char	*panicstr;
int	wantin;
int	boothowto;		/* reboot flags, from console subsystem */
int	selwait;

extern	char vmmap[];		/* poor name! */


/* casts to keep lint happy */
#define	insque(q,p)	_insque((queue_t)q,(queue_t)p)
#define	remque(q)	_remque((queue_t)q)
