/******************************************************************************
 *
 * TAPE2FILE - convert a simh mag tape image to normal file.
 *
 * Mainly useful for converting FST or TAR archives
 *
 * Ken Cornetet - ken@cornetet.org
 *
 * Usage: tape2file InputFile OutputFile
 *
 * This is public domain code. You may use this file for any purpose you choose.
 *
 *                       
 *
 *
 ******************************************************************************/



#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <memory.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>

#ifndef O_BINARY
#define O_BINARY 0
#endif

unsigned long MakeInt32( unsigned char *p );


main( int argc, char **argv )
{
	int n, i, fdin, fdout, x;

	char ibuf[32767], tmp[4];

    int reclen1, reclen2;

	if( (fdin = open(argv[1], O_RDONLY|O_BINARY)) < 0 ) {
		perror(argv[1]);
		exit(1);
	}

	if( (fdout = open(argv[2], O_WRONLY|O_BINARY|O_CREAT|O_TRUNC, 0666)) < 0 ) {
		perror(argv[2]);
		exit(1);
	}


	while( 1 ) {
        read(fdin, tmp, 4);
        reclen1 = MakeInt32(tmp);
        
		if(  reclen1 == 0 ) {
			break;
		}
		
		n = read(fdin, ibuf, reclen1);
        if( n != reclen1 ) {
            printf("Tape image error - expected: %d  read: %d\n", reclen1, n);
            exit(1);
        }
        
		read(fdin, tmp, 4);
        reclen2 = MakeInt32(tmp);
		if( reclen1 != reclen2 ) {
			printf("Tape image errror - leading and trailing lengths do not match. reclen1: %d  reclen2: %d\n", reclen1, reclen2);
			exit(1);
		}
		
        n = write(fdout, ibuf, reclen1);
        
        if( n != reclen1 ) {
            printf("write error\n");
            exit(1);
        }
	}

	close(fdin);
    close(fdout);
}

unsigned long MakeInt32( unsigned char *p )
{
	unsigned long tmp = 0;
    
	
    tmp +=  *p;          p++;
	tmp += ( *p << 8 );	 p++;
	tmp += ( *p << 16 ); p++;
	tmp += ( *p << 24 );

	return(tmp);
}




