/****************************************************************************
 File: tttpriv.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.4  $
 $Author:   kcatlin  $
 $Date:   17 Mar 1992 14:08:20  $

 This file contains things shared by various pieces of TttApp.
****************************************************************************/
#ifndef TTTPRIV_INCLUDED
#define TTTPRIV_INCLUDED

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#ifndef GEO_INCLUDED
#include <geo.h>
#endif

#ifndef SYSFONT_INCLUDED
#include <sysfont.h>
#endif

#ifndef TTTDATA_INCLUDED
#include <tttdata.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Useful Macros											   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


#define TttDbgHelper(str,set,flag,x) \
	Dbg(if (DbgFlagGet((set),(U32)(flag))) {DPrintf("%s: ",str); Debugf x;})


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Common Defines										   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Common Typedefs										   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef U8
TTT_VERSION, * P_TTT_VERSION;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Utility Routines										   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
//
// Function definitions for routines in tttutil.c.  Arguably these
// definitions should be in a separate header, but it's simpler just
// to keep them here.
//

STATUS PASCAL
TttUtilCreateScrollWin(
	OBJECT  		clientWin,
	P_OBJECT		pScrollWin);


STATUS PASCAL
TttUtilCreateMenu(
	OBJECT			parent,
	OBJECT			client,
	P_UNKNOWN		pEntries,	// really  P_TK_TABLE_ENTRY pEntries
	P_OBJECT			pMenu);


STATUS PASCAL
TttUtilAdjustMenu(
	OBJECT			menu);


STATUS PASCAL
TttUtilWrite(
	OBJECT			file,
	U32				numBytes,
	P_UNKNOWN		pBuf);


STATUS PASCAL
TttUtilWriteVersion(
	OBJECT			file,
	TTT_VERSION		version);


STATUS PASCAL
TttUtilRead(
	OBJECT			file,
	U32				numBytes,
	P_UNKNOWN		pBuf);


STATUS PASCAL
TttUtilReadVersion(
	OBJECT			file,
	TTT_VERSION		minVersion,
	TTT_VERSION		maxVersion,
	P_TTT_VERSION	pVersion);


STATUS PASCAL
TttUtilGetComponents(
	OBJECT			app,
	U16				getFlags,
	P_OBJECT			pScrollWin,
	P_OBJECT			pView,
	P_OBJECT			pDataObject);

//
// Values for the getFlags parameter to TttUtilGetComponents.
//
#define tttGetScrollWin		flag0
#define tttGetView       	flag1
#define tttGetDataObject	flag2


void PASCAL
TttUtilInitTextOutput(
	P_SYSDC_TEXT_OUTPUT	p,
	U16						align,
	P_U8						buf);


P_STRING PASCAL
TttUtilStrForSquareValue(
	TTT_SQUARE_VALUE	v);


TTT_SQUARE_VALUE PASCAL
TttUtilSquareValueForChar(
	char	ch);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Debugging Routines									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
//
// Function definitions for routines in tttdbg.c Arguably these
// definitions should be in a separate header, but it's simpler just to
// keep them here.
//

#ifdef DEBUG

MsgHandler(TttDbgDumpWindowTree);

MsgHandler(TttDbgDumpView);

MsgHandler(TttDbgDumpDataObject);

MsgHandler(TttDbgDumpDebugFlags);

MsgHandler(TttDbgChangeDebugSet);

MsgHandler(TttDbgChangeDebugFlag);

#endif // DEBUG


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                     Global Variables and Defines							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// 
// A Note on global well-knows versus private well-knowns.
// 
// All of the UIDs used in this application are global well-knowns.
// Strictly speaking, only the application class UID needs to be global.
// If none of the other classes are referenced outside of this
// application, then they can (and should) be private.
// 
// The UIDs here are global because that's the most general and least
// error-prone, and this application's role as template and tutorial
// make generality and stability very important.  However, any production
// application built constructed from this should consider making 
// some of these UIDs local.
//
// And, of course, any other application (production or not) constructed
// from this template should get their own allocation of uids.
//
// Also allocated to tic-tac-toe, but not yet used:
//		2225
// 
#define clsTttApp			MakeGlobalWKN(2222,1)
#define clsTttData	 	MakeGlobalWKN(2223,1)
#define clsTttView	 	MakeGlobalWKN(2224,1)

//
// Debug flag sets
//
#define tttAppDbgSet			0xC0
#define tttDataDbgSet		0xC1
#define tttUtilDbgSet		0xC2
#define tttViewDbgSet		0xC3
#define tttViewOptsDbgSet	0xC4
#define tttViewXferDbgSet	0xC5


#endif	// TTTPRIV_INCLUDED
