/****************************************************************************
 File: tttapp.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.3  $
 $Author:   kcatlin  $
 $Date:   30 Jan 1992 19:14:44  $

 This file contains the API definition for clsTttApp.
 clsTttApp inherits from clsApp.
****************************************************************************/
#ifndef TTTAPP_INCLUDED
#define TTTAPP_INCLUDED

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Defines										   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Common Typedefs								   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Exported Functions							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 ClsTttAppInit	returns STATUS
	Initializes / installs clsTttApp.

	This routine is only called during installation of the class.
*/
STATUS PASCAL
ClsTttAppInit (void);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Messages for clsTttApp						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

//
// Debug messages aren't in standard header form so that they won't 
// show up in automatically-generated datasheets.
//
#ifdef DEBUG
#define dbgMsgStart 0x40
#define	msgTttAppChangeDebugFlag   	MakeMsg(clsTttApp, dbgMsgStart + 0)
#define	msgTttAppChangeDebugSet		MakeMsg(clsTttApp, dbgMsgStart + 1)
#define	msgTttAppDumpWindowTree		MakeMsg(clsTttApp, dbgMsgStart + 2)
#define	msgTttAppDumpDebugFlags		MakeMsg(clsTttApp, dbgMsgStart + 3)
#define	msgTttAppDumpView			MakeMsg(clsTttApp, dbgMsgStart + 4)
#define	msgTttAppDumpDataObject		MakeMsg(clsTttApp, dbgMsgStart + 5)
#define	msgTttAppChangeTracing		MakeMsg(clsTttApp, dbgMsgStart + 6)
#define	msgTttAppForceRepaint		MakeMsg(clsTttApp, dbgMsgStart + 7)
#endif

#endif	// TTTAPP_INCLUDED
