/****************************************************************************
 File: options.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.7  $
   $Author:   kcatlin  $
     $Date:   05 Feb 1992 09:07:18  $

 This file contains the option sheet demoing code of the tkdemo application.
****************************************************************************/

#ifndef DEBUG_INCLUDED
#include <debug.h>
#endif

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#ifndef CLASSES_INCLUDED
#include <methods.h>
#endif

#ifndef SEL_INCLUDED
#include <sel.h>
#endif

#ifndef WIN_INCLUDED
#include <win.h>
#endif

#ifndef TLAYOUT_INCLUDED
#include <tlayout.h>
#endif

#ifndef TKTABLE_INCLUDED
#include <tktable.h>
#endif

#ifndef SWIN_INCLUDED
#include <swin.h>
#endif

#ifndef APP_INCLUDED
#include <app.h>
#endif

#ifndef APPTAG_INCLUDED
#include <apptag.h>
#endif

#ifndef CHOICE_INCLUDED
#include <choice.h>
#endif

#ifndef OPTTABLE_INCLUDED
#include <opttable.h>
#endif

#ifndef OPTION_INCLUDED
#include <option.h>
#endif

#ifndef PREFS_INCLUDED
#include <prefs.h>
#endif

#ifndef BUSY_INCLUDED
#include <busy.h>
#endif

#ifndef TKDEMO_INCLUDED
#include <tkdemo.h>
#endif



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *									Constants							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

static const TK_TABLE_ENTRY	uiEntries[] = {
	{"Widget 1", msgTkDemoUIButtonHit, 0, tagWidget1, tkButtonPargsUID},
	{"Gadget 1", msgTkDemoUIButtonHit, 0, tagGadget1, tkButtonPargsUID},
	{"Widget 2", msgTkDemoUIButtonHit, 0, tagWidget2, tkButtonPargsUID},
	{"Gadget 2", msgTkDemoUIButtonHit, 0, tagGadget2, tkButtonPargsUID},
	{pNull}
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Defines, Types, Globals, Etc				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

static const TK_TABLE_ENTRY	widgetCard1Mumble[] = {
	{"One", 0, 0, 1},
	{"Two", 0, 0, 2},
	{"Three", 0, 0, 3},
	{pNull}
};

static const TK_TABLE_ENTRY	widgetCard1Entries[] = {
	{"Font:"},	{0, 1, 0, tagWC1Font, tkNoClient | tkPopupChoiceFont, clsPopupChoice},
	{"Choice:"},	{widgetCard1Mumble, 1, 0, tagWC1Choice, 0, clsChoice},
	{"Toggles:"},	{widgetCard1Mumble, 1, 0, tagWC1Toggle, 0, clsToggleTable},
	{pNull}
};

static const TK_TABLE_ENTRY	gadgetCard1Entries[] = {
	{"Font:"},	{(P_UNKNOWN) slbRoleChoice1, 4, slbLookDecorate, tagGC1Font, tkNoClient, clsFontListBox},
	{pNull}
};

static const TK_TABLE_ENTRY	gadgetCard2Entries[] = {
	{"Underline:"},		{0, 0, 0, tagGC2Uline, tkNoClient, clsChoice},
		{"None", 0, 0, 0},
		{"Single", 0, 0, 1},
		{"Double", 0, 0, 2},
		{pNull},
	{pNull}
};


STATUS LOCAL TkDemoGetSelectedButton(
	OBJECT		self,
	BUTTON 		*object,
	U16			tagCurSel)
{
	APP_METRICS		am;
	FRAME_METRICS	fm;
	STATUS			s;

	ObjCallRet(msgAppGetMetrics, self, &am, s);
	ObjCallRet(msgFrameGetMetrics, am.mainWin, &fm, s);
	*object = (BUTTON) ObjectCall(msgWinFindTag, fm.clientWin,
			(P_ARGS) MakeTag(clsTkDemo, tagCurSel));

	return stsOK;

} /* TkDemoGetSelectedButton */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Global Utilities						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS GLOBAL TkDemoAddOptionsCard (
	WIN		swin,
	WIN		tabBar,
	APP		app)
{
	STATUS				s;
	CHOICE_NEW			cn;

	// Create the card window.
	ObjCallRet(msgNewDefaults, clsChoice, &cn, s);
	cn.win.tag = tagChoice;
	cn.gWin.style.gestureEnable = true;
	cn.tableLayout.numRows.constraint = tlInfinite;
	cn.tableLayout.numCols.constraint = tlAbsolute;
	cn.tableLayout.numCols.value = 2;
	cn.tableLayout.rowHeight.constraint = tlGroupMax;
	cn.tableLayout.rowHeight.gap = 4;
	cn.tableLayout.colWidth.constraint = tlGroupMax;
	cn.tableLayout.colWidth.gap = 4;
	cn.tkTable.pEntries = uiEntries;
	cn.tkTable.client = app;
	cn.tkTable.pButtonNew->gWin.style.gestureEnable = true;
	cn.tkTable.pButtonNew->border.style.edge = bsEdgeNone;
	cn.tkTable.pButtonNew->button.style.feedback = bsFeedbackInvert;
	cn.tkTable.pButtonNew->button.style.contact = bsContactToggle;
	ObjCallRet(msgNew, clsChoice, &cn, s);

	// Add it to the scrollwin.
	ObjCallRet(msgScrollWinAddClientWin, swin, (P_ARGS) cn.object.uid, s);

	// Create and add a corresponding tab.
	StsRet(AddTab(tabBar, "Options", cn.object.uid), s);

	return stsOK;

} /* TkDemoAddOptionsCard */

/****************************************************************************
	TkDemoUIButtonHit
	
	Handle the selection of a ui button.
****************************************************************************/
MsgHandlerArgType(TkDemoUIButtonHit, WIN)
{
	STATUS			s;
	BUTTON_STYLE	style;

	Dbg(Debugf("tkdemo[%p]: msgTkDemoUIButtonHit", self);)
	Dbg(Debugf("    setting sel null");)
	ObjCallRet(msgSelSetOwner, theSelectionManager, pNull, s);

	ObjCallRet(msgButtonGetStyle, pArgs, &style, s);

	if (style.on) {
		WIN_METRICS		wm;
		TKDEMO_INST	inst;
		
		inst = IDataDeref(pData, TKDEMO_INST);

		ObjCallRet(msgWinGetTag, pArgs, &wm, s);
		inst.tagCurSel = Tag(wm.tag);
		StsWarn(ObjectWrite(self, ctx, &inst));

		Dbg(Debugf("    setting sel to app");)
		ObjCallRet(msgSelSetOwner, theSelectionManager, self, s);
	}

	Dbg(DPrintf("\n");)

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* TkDemoUIButtonHit */


/****************************************************************************
	TkDemoSelYield
	
	Respond to msgSelYield when tkdemo has the selection.
****************************************************************************/
MsgHandler(TkDemoSelYield)
{
	TKDEMO_INST	inst;

	Dbg(Debugf("tkdemo[%p]: msgSelYield", self);)
	inst = IDataDeref(pData, TKDEMO_INST);
	inst.tagCurSel = 0;
	StsWarn(ObjectWrite(self, ctx, &inst));

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* TkDemoSelYield */

/****************************************************************************
	TkDemoOptionAddCards
	
	Handles msgOptionAddCards.
	
	Note on error handling: Once a card has been added to the sheet,
	destroying the sheet will destroy the card.
****************************************************************************/
MsgHandlerWithTypes(TkDemoOptionAddCards, P_OPTION_TAG, PP_TKDEMO_INST)
{
	OPTION_CARD			card;
	STATUS				s;

	//
	// Determine which sheet is requesting the cards. Only create
	// the cards if it is the Document option sheet. This test is
	// only needed by application subclasses. Other subclasses (such
	// as Tic-Tac-Toe's view class) don't need to perform such a test.
	//
	if (pArgs->tag == tagAppDocOptSheet) { 
		// Create the first card.
		card.tag = tagWidgetCard1;
		card.win = objNull;
		card.pName = "Widget Card 1";
		card.client = self;
		ObjCallJmp(msgOptionAddCard, pArgs->option, &card, s, Error);

		// Create the second card
		card.tag = tagGadgetCard1;
		card.win = objNull;
		card.pName = "Gadget Card 1";
		card.client = self;
		ObjCallJmp(msgOptionAddCard, pArgs->option, &card, s, Error);

		// Create the third & last card
		card.tag = tagGadgetCard2;
		card.win = objNull;
		card.pName = "Gadget Card 2";
		card.client = self;
		ObjCallJmp(msgOptionAddLastCard, pArgs->option, &card, s, Error);
	}
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	return s;
} /* TkDemoOptionAddCards */

STATUS LOCAL TkDemoGetFontValue(
	BUTTON		object,
	P_U32		value)
{
	LABEL_STYLE	style;
	STATUS		s;

	ObjCallRet(msgLabelGetStyle, object, &style, s);

 	if (style.fontType == lsFontSystem) {
 		PREF_SYSTEM_FONT_INFO	info;

 		PrefsSysFontInfo(&info);
 		*value = (U32) info.sysFontId;
 	} else {
 		SYSDC_FONT_SPEC		spec;

 		ObjCallRet(msgLabelGetFontSpec, object, &spec, s);
 		*value = (U32) spec.id;
 	}
	return stsOK;
}

/****************************************************************************
	TkDemoOptionRefreshCard

	Handles msgOptionRefreshCard
****************************************************************************/
MsgHandlerWithTypes(TkDemoOptionRefreshCard, P_OPTION_CARD, P_TKDEMO_INST)
{
	STATUS			s;
	BUTTON			object;
	WIN				control;
	LABEL_STYLE		style;
	U32				value;

	// Find the selected button object 
	StsRet(TkDemoGetSelectedButton(self, &object, pData->tagCurSel),s);

	switch (pArgs->tag) {
		case tagWidgetCard1:
			if (object) {
				StsRet(TkDemoGetFontValue(object, &value),s);
				control = (WIN) ObjectCall(
						msgWinFindTag, pArgs->win, (P_ARGS) tagWC1Font);
				ObjCallRet(msgControlSetValue, control, (P_ARGS) value, s);
				ObjCallRet(msgControlSetDirty, pArgs->win, (P_ARGS) false, s);
			}
			break;

		case tagGadgetCard1:
			if (object) {
				StsRet(TkDemoGetFontValue(object, &value),s);
				control = (WIN) ObjectCall(
						msgWinFindTag, pArgs->win, (P_ARGS) tagGC1Font);
				ObjCallRet(msgStrListBoxSetValue, control, (P_ARGS) value, s);
				ObjCallRet(msgStrListBoxSetDirty, control, (P_ARGS) false, s);
			}
			break;

		case tagGadgetCard2:
			if (object) {
				ObjCallRet(msgLabelGetStyle, object, &style, s);
				value = style.underline;
				control = (WIN) ObjectCall(
						msgWinFindTag, pArgs->win, (P_ARGS) tagGC2Uline);
				ObjCallRet(msgControlSetValue, control, (P_ARGS) value, s);
				ObjCallRet(msgControlSetDirty, pArgs->win, (P_ARGS) false, s);
			}
			break;
		default:	
			return ObjectCallAncestorCtx(ctx);
			break;
	}

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* TkDemoOptionRefreshCard */

/****************************************************************************
	TkDemoOptionDirtyCard

	Handles msgOptionDirtyCard
****************************************************************************/
MsgHandlerWithTypes(TkDemoOptionDirtyCard, P_OPTION_CARD, P_TKDEMO_INST)
{
	WIN			control;
	STATUS		s;

	if (pArgs->tag == tagGadgetCard1) {
		control = (WIN) ObjectCall(msgWinFindTag, pArgs->win, 
				(P_ARGS)tagGC1Font);
		ObjCallRet(msgStrListBoxSetDirty, control, (P_ARGS) true, s);
	} else {
		return ObjectCallAncestorCtx(ctx);
	}
	return stsOK;
	MsgHandlerParametersNoWarning;
	
} /* TkDemoOptionDirtyCard */

STATUS LOCAL TkDemoRefreshButton(
	BUTTON		object)
{
	WIN_METRICS		wm;
	STATUS			s;
	
 	ObjCallRet(msgWinGetMetrics, object, &wm, s);
 	if (WinShrinkWrap(wm.flags.style)) {
 		ObjCallRet(msgWinDirtyRect, object, pNull, s);
 		ObjectCall(msgWinSetLayoutDirty, object, (P_ARGS) true);
 		wm.options = wsLayoutDefault | wsLayoutMinPaint;
 		ObjCallRet(msgWinLayout, object, &wm, s);
 	} else
 		ObjCallRet(msgWinDirtyRect, object, pNull, s);

	return stsOK;

} /* TkDemoRefreshButton */

/****************************************************************************
	TkDemoOptionApplyCard

	Handles msgOptionApplyCard

****************************************************************************/
MsgHandlerWithTypes(TkDemoOptionApplyCard, P_OPTION_CARD, P_TKDEMO_INST)
{
	STATUS			s;
	BUTTON			object;
	WIN				control;
	LABEL_STYLE		style;
	BOOLEAN			dirty;
	U32				value;
	SYSDC_FONT_SPEC		spec;

	switch (pArgs->tag) {

		case tagWidgetCard1:
			StsRet(TkDemoGetSelectedButton(self, &object, pData->tagCurSel),s);
			ObjCallRet(msgLabelGetStyle, object, &style, s);
			control = (WIN) ObjectCall(
					msgWinFindTag, pArgs->win, (P_ARGS) tagWC1Font);
			ObjCallRet(msgControlGetDirty, control, &dirty, s);
			if (!dirty)
				goto Done;

			ObjCallRet(msgControlGetValue, control, &value, s);
			ObjCallRet(msgLabelGetFontSpec, object, &spec, s);
			style.fontType = lsFontCustom;
			spec.id = (U16) value;
			ObjCallRet(msgLabelSetFontSpec, object, &spec, s);
			ObjCallRet(msgLabelSetStyle, object, &style, s);
			StsRet(TkDemoRefreshButton(object),s);
			break;

		case tagGadgetCard1:
			StsRet(TkDemoGetSelectedButton(self, &object, pData->tagCurSel),s);
			ObjCallRet(msgLabelGetStyle, object, &style, s);
			control = (WIN) ObjectCall(
					msgWinFindTag, pArgs->win, (P_ARGS) tagGC1Font);
			ObjCallRet(msgStrListBoxGetDirty, control, &dirty, s);
			if (!dirty)
				goto Done;

			ObjCallRet(msgStrListBoxGetValue, control, &value, s);
			ObjCallRet(msgLabelGetFontSpec, object, &spec, s);
			spec.id = (U16) value;
			ObjCallRet(msgLabelSetFontSpec, object, &spec, s);
			style.fontType = lsFontCustom;
			ObjCallRet(msgLabelSetStyle, object, &style, s);
			StsRet(TkDemoRefreshButton(object),s);
			break;

		case tagGadgetCard2:
			StsRet(TkDemoGetSelectedButton(self, &object, pData->tagCurSel),s);
			ObjCallRet(msgLabelGetStyle, object, &style, s);
			control = (WIN) ObjectCall(
					msgWinFindTag, pArgs->win, (P_ARGS) tagGC2Uline);
			ObjCallRet(msgControlGetDirty, control, &dirty, s);
			if (!dirty)
				goto Done;

			ObjCallRet(msgControlGetValue, control, &value, s);
			style.underline = value;
			ObjCallRet(msgLabelSetStyle, object, &style, s);
			StsRet(TkDemoRefreshButton(object),s);

			break;
		default:
			return ObjectCallAncestorCtx(ctx);
			break;
	}

Done:
	ObjCallRet(msgControlSetDirty, pArgs->win, (P_ARGS) false, s);
	return stsOK;
	MsgHandlerParametersNoWarning;
} /* TkDemoOptionApplyCard */



/****************************************************************************
	TkDemoOptionApplicableCard

	Handles msgOptionApplicableCard
****************************************************************************/
MsgHandlerWithTypes(TkDemoOptionApplicableCard, P_OPTION_CARD, \
		P_TKDEMO_INST)
{
	if (pArgs->tag == tagWidgetCard1) {
		return ((pData->tagCurSel == 1) || (pData->tagCurSel == 3)) ? stsOK : stsFailed;
	}
	else if ((pArgs->tag == tagGadgetCard1) || (pArgs->tag == tagGadgetCard2)) {
		return ((pData->tagCurSel == 2) || (pData->tagCurSel == 4)) ? stsOK : stsFailed;
	}
	else {
		// let ancestor try to handle it 
		return ObjectCallAncestorCtx(ctx);
	}

	MsgHandlerParametersNoWarning;

} /* TkDemoOptionApplicableCard */


/****************************************************************************
	msgOptionProvideCard
****************************************************************************/
MsgHandlerWithTypes(TkDemoOptionProvideCard, P_OPTION_CARD, P_UNKNOWN)
{
	STATUS s;
	OPTION_TABLE_NEW new;

	pArgs->win = objNull;
	if (pArgs->tag == tagWidgetCard1)
	{
		ObjCallRet(msgNewDefaults, clsOptionTable, &new, s);
		new.tkTable.client = self;
		new.tkTable.pEntries = widgetCard1Entries;
		new.win.tag = pArgs->tag;
		ObjCallRet(msgNew, clsOptionTable, &new, s);
		pArgs->win = new.object.uid;

	}
	else if (pArgs->tag == tagGadgetCard1)
	{
		ObjCallRet(msgNewDefaults, clsOptionTable, &new, s);
		new.tkTable.client = self;
		new.tkTable.pEntries = gadgetCard1Entries;
		new.win.tag = pArgs->tag;
		ObjCallRet(msgNew, clsOptionTable, &new, s);
		pArgs->win = new.object.uid;
	}
	else if (pArgs->tag == tagGadgetCard2)
	{
		ObjCallRet(msgNewDefaults, clsOptionTable, &new, s);
		new.tkTable.client = self;
		new.tkTable.pEntries = gadgetCard2Entries;
		new.win.tag = pArgs->tag;
		ObjCallRet(msgNew, clsOptionTable, &new, s);
		pArgs->win = new.object.uid;
	}
	return stsOK;
	MsgHandlerParametersNoWarning;

} /* TkDemoOptionProvideCard */


