/****************************************************************************
 File: optables.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.5  $
   $Author:   kcatlin  $
     $Date:   05 Feb 1992 09:07:10  $

 This file contains the clsOptionTable demoing code of the tkdemo application.
****************************************************************************/

#ifndef OPTTABLE_INCLUDED
#include <opttable.h>
#endif

#ifndef SWIN_INCLUDED
#include <swin.h>
#endif

#ifndef BUTTON_INCLUDED
#include <button.h>
#endif

#ifndef MENU_INCLUDED
#include <menu.h>
#endif

#ifndef CHOICE_INCLUDED
#include <choice.h>
#endif

#ifndef TTABLE_INCLUDED
#include <ttable.h>
#endif

#ifndef TABBAR_INCLUDED
#include <tabbar.h>
#endif

#ifndef TKDEMO_INCLUDED
#include <tkdemo.h>
#endif


#define tagHFChoice     MakeTag(clsTkDemo, 1)
#define tagBDChoice     MakeTag(clsTkDemo, 2)
#define tagPagesChoice  MakeTag(clsTkDemo, 3)
#define tagNestedTbl    MakeTag(clsTkDemo, 4)

static const TK_TABLE_ENTRY	onOffChoice[] = {
	{0, 0, 0, 0, tkLabelEntry},
		{0, 0, 0, tagNestedTbl, tkTableWideGap | tkTableHorizontal | tkInputDisable, clsTkTable},
			{"On", 0, 0, 0, tkInputDisable | tkBorderMarginNone, clsLabel},
			{"Show", msgButtonNotify, 0, 0, tkButtonManagerNone, clsButton},
			{pNull},

	{"Off", 0, 0, 0, tkButtonOn},
	{pNull}
};

static const TK_TABLE_ENTRY	sampleCard[] = {
	{"Pages:"}, 		 	{0, 0, 0, tagPagesChoice, tkNoClient, clsChoice},
		{"All"},
		{0, 0, 0, 1, tkLabelEntry | tkButtonOn},
			{0, 0, 0, tagNestedTbl, tkTableHorizontal, clsTkTable},
				{"From", 0, 0, 0, tkBorderMarginNone, clsLabel},
				{"1", 2, 0, 0, 0, clsIntegerField},
				{"to", 0, 0, 0, tkBorderMarginNone, clsLabel},
				{"1", 2, 0, 0, 0, clsIntegerField},
				{pNull},

		{pNull},

	{"No. of Copies:"},		{"1", 0, 0, 0, 0, clsIntegerField},
	{"Name:"},				{0, 10, 0, 0, 0, clsTextField},

	{"Paper Size:"},		{0, 0, 0, 0, tkNoClient, clsChoice},
		{"8 1/2 X 11"},
		{"8 1/2 X 14", 0, 0, 1, tkButtonOn},
		{pNull},

	{"Printer:"},			{0, 0, 0, 0, tkNoClient, clsChoice},
		{"HP"},
		{"Diconix", 0, 0, 1},
		{"Apple", 0, 0, 2, tkButtonOn},
		{pNull},

	{"Header & Footer:"},	{onOffChoice, 0, 0, tagHFChoice, tkNoClient, clsChoice},

	{"Background Doc:"},	{onOffChoice, 0, 0, tagBDChoice, tkNoClient, clsChoice},

	{pNull}
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Local Utilities	  					   	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


STATUS LOCAL AdjustTblAlignment (WIN    w)
{
    STATUS              s;
    TBL_LAYOUT_METRICS  tm;

    w = (WIN) ObjectCall(msgWinFindTag, w, (P_ARGS) tagNestedTbl);
    ObjCallRet(msgTblLayoutGetMetrics, w, &tm, s);
    tm.style.childYAlignment = tlAlignBaseline;
    tm.rowHeight.constraint = tlGroupMax | tlBaselineBox;
    ObjCallRet(msgTblLayoutSetMetrics, w, &tm, s);

    return stsOK;

} /* AdjustTblAlignment */


STATUS LOCAL AddOptionTableExamples (WIN	parent)
{
	STATUS				s;
	OPTION_TABLE_NEW	otn;

	AddLabel(parent, "Standard Option Table, with Nested Tables");

	ObjCallRet(msgNewDefaults, clsOptionTable, &otn, s);
	otn.border.style.edge = bsEdgeAll;
    otn.tableLayout.style.childYAlignment = tlAlignBaseline;
    otn.tableLayout.rowHeight.constraint = tlGroupMax | tlBaselineBox;
	otn.tkTable.pEntries = sampleCard;
	ObjCallRet(msgNew, clsOptionTable, &otn, s);

    StsRet(AdjustTblAlignment((WIN) \
        ObjectCall(msgWinFindTag, otn.object.uid, (P_ARGS) tagPagesChoice)), s);
    StsRet(AdjustTblAlignment((WIN) \
        ObjectCall(msgWinFindTag, otn.object.uid, (P_ARGS) tagHFChoice)), s);
    StsRet(AdjustTblAlignment((WIN) \
        ObjectCall(msgWinFindTag, otn.object.uid, (P_ARGS) tagBDChoice)), s);

	otn.win.parent = parent;
	ObjCallRet(msgWinInsert, otn.object.uid, &otn.win, s);

	return stsOK;

} /* AddOptionTablesExample */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Global Utilities						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS GLOBAL TkDemoAddOptionTablesCard (
	WIN		swin,
	WIN		tabBar,
	APP		app)
{
	STATUS				s;
	OPTION_TABLE_NEW	otn;

	// Create the card window.
	ObjCallRet(msgNewDefaults, clsOptionTable, &otn, s);
	otn.tableLayout.style.childXAlignment = tlAlignLeft;
	ObjCallRet(msgNew, clsOptionTable, &otn, s);

	// Add it to the scrollwin.
	ObjCallRet(msgScrollWinAddClientWin, swin, (P_ARGS) otn.object.uid, s);

	// Create and add a corresponding tab.
	StsRet(AddTab(tabBar, "OptionTables", otn.object.uid), s);

	// fill the card with border examples
	StsRet(AddOptionTableExamples(otn.object.uid), s);

	return stsOK;

	Unused(app);

} /* TkDemoAddOptionTablesCard */


